/*
 * Decompiled with CFR 0.152.
 */
package com.crabshue.commons.json.serialization.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;

public class JSR310DateTimeSerializer
extends JsonSerializer<TemporalAccessor> {
    private static final DateTimeFormatter ISOFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.of("Z"));
    public static final JSR310DateTimeSerializer INSTANCE = new JSR310DateTimeSerializer();

    protected JSR310DateTimeSerializer() {
    }

    public void serialize(TemporalAccessor value, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        generator.writeString(ISOFormatter.format(value));
    }
}

