/*
 * Decompiled with CFR 0.152.
 */
package com.crabshue.commons.json.serialization;

import com.crabshue.commons.json.serialization.serializers.JSR310DateTimeSerializer;
import com.crabshue.commons.json.serialization.serializers.JSR310LocalDateDeserializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class ObjectMapperBuilder {
    private List<JsonInclude.Include> serializationInclusions = new ArrayList<JsonInclude.Include>();

    public static ObjectMapperBuilder builder() {
        return new ObjectMapperBuilder();
    }

    private ObjectMapperBuilder() {
    }

    public ObjectMapperBuilder withSerializationInclusion(@NonNull JsonInclude.Include serializationInclusion) {
        if (serializationInclusion == null) {
            throw new NullPointerException("serializationInclusion is marked @NonNull but is null");
        }
        this.serializationInclusions.add(serializationInclusion);
        return this;
    }

    public ObjectMapper build() {
        ObjectMapper ret = new ObjectMapper();
        JavaTimeModule module = new JavaTimeModule();
        module.addSerializer(OffsetDateTime.class, (JsonSerializer)JSR310DateTimeSerializer.INSTANCE);
        module.addSerializer(ZonedDateTime.class, (JsonSerializer)JSR310DateTimeSerializer.INSTANCE);
        module.addSerializer(LocalDateTime.class, (JsonSerializer)JSR310DateTimeSerializer.INSTANCE);
        module.addSerializer(Instant.class, (JsonSerializer)JSR310DateTimeSerializer.INSTANCE);
        module.addDeserializer(LocalDate.class, (JsonDeserializer)JSR310LocalDateDeserializer.INSTANCE);
        ret.registerModule((Module)module);
        this.serializationInclusions.forEach(arg_0 -> ((ObjectMapper)ret).setSerializationInclusion(arg_0));
        return ret;
    }
}

