/*
 * Decompiled with CFR 0.152.
 */
package com.crabshue.commons.json.serialization;

import com.crabshue.commons.exceptions.ApplicationException;
import com.crabshue.commons.exceptions.SystemException;
import com.crabshue.commons.exceptions.context.ErrorContext;
import com.crabshue.commons.exceptions.context.ErrorType;
import com.crabshue.commons.exceptions.utils.ExceptionMessageUtils;
import com.crabshue.commons.file.FileSystemUtils;
import com.crabshue.commons.json.serialization.ObjectMapperBuilder;
import com.crabshue.commons.json.serialization.exceptions.JsonErrorContext;
import com.crabshue.commons.json.serialization.exceptions.JsonErrorType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializer {
    private static final Logger logger = LoggerFactory.getLogger(JsonSerializer.class);
    private Object objectToSerialize;
    private Class<?> jsonSerializationView;
    private List<JsonInclude.Include> serializationInclusions = new ArrayList<JsonInclude.Include>();
    private List<SerializationFeature> serializationFeatures = new ArrayList<SerializationFeature>();
    private Object output;

    public static JsonSerializer of(@NonNull Object objectToSerialize) {
        if (objectToSerialize == null) {
            throw new NullPointerException("objectToSerialize is marked @NonNull but is null");
        }
        JsonSerializer ret = new JsonSerializer();
        ret.objectToSerialize = objectToSerialize;
        return ret;
    }

    public JsonSerializer withView(@NonNull Class<?> jsonSerializationView) {
        if (jsonSerializationView == null) {
            throw new NullPointerException("jsonSerializationView is marked @NonNull but is null");
        }
        this.jsonSerializationView = jsonSerializationView;
        return this;
    }

    public JsonSerializer withSerializationFeature(@NonNull SerializationFeature serializationFeature) {
        if (serializationFeature == null) {
            throw new NullPointerException("serializationFeature is marked @NonNull but is null");
        }
        this.serializationFeatures.add(serializationFeature);
        return this;
    }

    public JsonSerializer withSerializationInclusion(@NonNull JsonInclude.Include serializationInclusion) {
        if (serializationInclusion == null) {
            throw new NullPointerException("serializationInclusion is marked @NonNull but is null");
        }
        this.serializationInclusions.add(serializationInclusion);
        return this;
    }

    public JsonSerializer withOutput(@NonNull Object output) {
        if (output == null) {
            throw new NullPointerException("output is marked @NonNull but is null");
        }
        this.output = output;
        return this;
    }

    public <T> T serialize() {
        logger.debug("Invoked JSON serializer [{}]", (Object)this);
        ObjectWriter objectWriter = this.initializeObjectWriter();
        try {
            Writer writer = this.initializeWriter();
            objectWriter.writeValue(writer, this.objectToSerialize);
            if (writer instanceof StringWriter) {
                this.output = writer.toString();
            }
        }
        catch (IOException e) {
            throw new SystemException((Throwable)e);
        }
        logger.info("Serialized object [{}] to JSON", this.objectToSerialize);
        return (T)this.output;
    }

    private Writer initializeWriter() {
        Writer ret;
        if (Objects.isNull(this.output)) {
            ret = new StringWriter();
        } else if (this.output instanceof String) {
            ret = new StringWriter();
        } else if (this.output instanceof File || this.output instanceof Path) {
            File outputFile = this.output instanceof File ? (File)this.output : ((Path)this.output).toFile();
            FileSystemUtils.retrieveOrCreateFile((File)outputFile);
            try {
                ret = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new SystemException((Throwable)e);
            }
        } else {
            throw new ApplicationException((ErrorType)JsonErrorType.UNSUPPORTED_OUTPUT_FOR_JSON_SERIALIZATION).addContextValue((ErrorContext)JsonErrorContext.SUPPORTED_TYPES_FOR_JSON_SERIALIZATION, (Object)ExceptionMessageUtils.printList(Arrays.asList(String.class, File.class, Path.class), Class::getName));
        }
        return ret;
    }

    private ObjectWriter initializeObjectWriter() {
        ObjectMapperBuilder builder = ObjectMapperBuilder.builder();
        this.serializationInclusions.forEach(builder::withSerializationInclusion);
        ObjectMapper objectMapper = builder.build();
        ObjectWriter ret = objectMapper.writer();
        if (Objects.nonNull(this.jsonSerializationView)) {
            ret = ret.withView(this.jsonSerializationView);
        }
        for (SerializationFeature serializationFeature : this.serializationFeatures) {
            ret = ret.with(serializationFeature);
        }
        return ret;
    }

    public String toString() {
        return "JsonSerializer(objectToSerialize=" + this.objectToSerialize + ", jsonSerializationView=" + this.jsonSerializationView + ", serializationInclusions=" + this.serializationInclusions + ", serializationFeatures=" + this.serializationFeatures + ", output=" + this.output + ")";
    }
}

