/*
 * Decompiled with CFR 0.152.
 */
package com.crabshue.commons.file.validation;

import com.crabshue.commons.exceptions.ValidationException;
import com.crabshue.commons.exceptions.context.ErrorContext;
import com.crabshue.commons.exceptions.context.ErrorType;
import com.crabshue.commons.file.exceptions.FileErrorContext;
import com.crabshue.commons.file.exceptions.FileErrorType;
import java.io.File;
import lombok.NonNull;

public class FileValidationUtils {
    public static void validateFolder(@NonNull File folder) {
        if (folder == null) {
            throw new NullPointerException("folder is marked @NonNull but is null");
        }
        if (!folder.isDirectory()) {
            throw new ValidationException((ErrorType)FileErrorType.NOT_A_FOLDER).addContextValue((ErrorContext)FileErrorContext.FOLDER, (Object)folder);
        }
    }

    public static void validateFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        if (!file.isFile()) {
            throw new ValidationException((ErrorType)FileErrorType.NOT_A_FILE).addContextValue((ErrorContext)FileErrorContext.FILE, (Object)file);
        }
    }

    public static void validateWritable(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        if (!file.canWrite()) {
            throw new ValidationException((ErrorType)FileErrorType.NOT_WRITABLE).addContextValue((ErrorContext)FileErrorContext.FILE, (Object)file);
        }
    }

    public static void validateReadable(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        if (!file.canRead()) {
            throw new ValidationException((ErrorType)FileErrorType.NOT_READABLE).addContextValue((ErrorContext)FileErrorContext.FILE, (Object)file);
        }
    }

    public static void validateExecutable(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        if (!file.canWrite()) {
            throw new ValidationException((ErrorType)FileErrorType.NOT_EXECUTABLE).addContextValue((ErrorContext)FileErrorContext.FILE, (Object)file);
        }
    }
}

