/*
 * Decompiled with CFR 0.152.
 */
package com.crabshue.commons.file;

import com.crabshue.commons.exceptions.ApplicationException;
import com.crabshue.commons.exceptions.SystemException;
import com.crabshue.commons.exceptions.context.ErrorContext;
import com.crabshue.commons.exceptions.context.ErrorType;
import com.crabshue.commons.file.exceptions.FileErrorContext;
import com.crabshue.commons.file.exceptions.FileErrorType;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemUtils.class);

    public static File provideFolder(@NonNull String folderPath) {
        if (folderPath == null) {
            throw new NullPointerException("folderPath is marked @NonNull but is null");
        }
        return FileSystemUtils.provideFolder(new File(folderPath));
    }

    public static File provideFolder(@NonNull File folder) {
        if (folder == null) {
            throw new NullPointerException("folder is marked @NonNull but is null");
        }
        if (!folder.exists()) {
            try {
                FileUtils.forceMkdir((File)folder);
                logger.info("Folder created [{}]", (Object)folder);
            }
            catch (IOException e) {
                throw new SystemException((ErrorType)FileErrorType.ERROR_CREATING_FOLDER, (Throwable)e).addContextValue((ErrorContext)FileErrorContext.FOLDER, (Object)folder);
            }
        }
        return folder;
    }

    public static File provideSubFolder(@NonNull String subfolder, @NonNull File parent) {
        if (subfolder == null) {
            throw new NullPointerException("subfolder is marked @NonNull but is null");
        }
        if (parent == null) {
            throw new NullPointerException("parent is marked @NonNull but is null");
        }
        File ret = new File(parent, subfolder);
        return FileSystemUtils.provideFolder(ret);
    }

    public static File retrieveFileInFolder(@NonNull String name, @NonNull File folder) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        if (folder == null) {
            throw new NullPointerException("folder is marked @NonNull but is null");
        }
        File ret = new File(folder, name);
        if (!ret.exists() || !ret.isFile()) {
            throw new ApplicationException((ErrorType)FileErrorType.NO_FILE_FOUND, "No file found in the folder with given name").addContextValue((ErrorContext)FileErrorContext.FOLDER, (Object)folder).addContextValue((ErrorContext)FileErrorContext.FILENAME, (Object)name);
        }
        logger.info("File [{}] found in folder [{}]", (Object)ret, (Object)folder);
        return ret;
    }

    public static File copyFile(@NonNull File file, @NonNull File outputFile) {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        if (outputFile == null) {
            throw new NullPointerException("outputFile is marked @NonNull but is null");
        }
        try {
            FileUtils.copyFile((File)file, (File)outputFile);
        }
        catch (IOException e) {
            throw new SystemException((ErrorType)FileErrorType.ERROR_COPY_FILE, (Throwable)e).addContextValue((ErrorContext)FileErrorContext.FILE, (Object)file).addContextValue((ErrorContext)FileErrorContext.FILE, (Object)outputFile);
        }
        return outputFile;
    }

    public static File copyFileToFolder(@NonNull File file, @NonNull File targetFolder) {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        if (targetFolder == null) {
            throw new NullPointerException("targetFolder is marked @NonNull but is null");
        }
        if (!targetFolder.isDirectory()) {
            throw new IllegalArgumentException("target is not a directory " + targetFolder);
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Given file is not a file " + file);
        }
        File target = new File(targetFolder, file.getName());
        try {
            FileUtils.copyFile((File)file, (File)target);
        }
        catch (IOException e) {
            throw new SystemException((ErrorType)FileErrorType.ERROR_COPY_FILE, "Cannot copy file", (Throwable)e).addContextValue((ErrorContext)FileErrorContext.FILE, (Object)file).addContextValue((ErrorContext)FileErrorContext.FILE, (Object)target);
        }
        logger.info("Copied file [{}] to [{}]", (Object)file, (Object)target);
        return target;
    }

    public static File copyFolder(@NonNull File sourceFolder, @NonNull File targetFolder) {
        if (sourceFolder == null) {
            throw new NullPointerException("sourceFolder is marked @NonNull but is null");
        }
        if (targetFolder == null) {
            throw new NullPointerException("targetFolder is marked @NonNull but is null");
        }
        if (!sourceFolder.isDirectory()) {
            throw new IllegalArgumentException("at least one of the parameters is not a directory");
        }
        try {
            FileUtils.copyDirectory((File)sourceFolder, (File)targetFolder);
        }
        catch (IOException e) {
            throw new SystemException((ErrorType)FileErrorType.ERROR_COPY_FILE, "Cannot copy folder", (Throwable)e).addContextValue((ErrorContext)FileErrorContext.FOLDER, (Object)sourceFolder).addContextValue((ErrorContext)FileErrorContext.FOLDER, (Object)targetFolder);
        }
        logger.info("Copied folder [{}] to [{}]", (Object)sourceFolder, (Object)targetFolder);
        return targetFolder;
    }

    public static boolean isFolderEmpty(@NonNull File folder) {
        if (folder == null) {
            throw new NullPointerException("folder is marked @NonNull but is null");
        }
        Collection files = FileUtils.listFilesAndDirs((File)folder, (IOFileFilter)FileFilterUtils.trueFileFilter(), (IOFileFilter)FileFilterUtils.trueFileFilter());
        boolean ret = files.size() <= 1;
        logger.info("Folder [{}] is empty ? : {}", (Object)folder, (Object)ret);
        return ret;
    }

    public static File retrieveOrCreateFile(@NonNull File folder, @NonNull String filename) {
        if (folder == null) {
            throw new NullPointerException("folder is marked @NonNull but is null");
        }
        if (filename == null) {
            throw new NullPointerException("filename is marked @NonNull but is null");
        }
        File ret = new File(folder, filename);
        return FileSystemUtils.retrieveOrCreateFile(ret);
    }

    public static File retrieveOrCreateFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        if (!file.exists()) {
            FileSystemUtils.provideFolder(file.getParentFile());
            try {
                FileUtils.touch((File)file);
                logger.info("Created file [{}]", (Object)file);
            }
            catch (IOException e) {
                throw new SystemException((ErrorType)FileErrorType.ERROR_WRITING_FILE, (Throwable)e).addContextValue((ErrorContext)FileErrorContext.FILE, (Object)file);
            }
        } else {
            logger.info("Retrieved file [{}]", (Object)file);
        }
        return file;
    }

    public static boolean isFileEmpty(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        try {
            List lines = FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
            return lines.isEmpty();
        }
        catch (IOException e) {
            throw new SystemException((ErrorType)FileErrorType.ERROR_READING_FILE, "Cannot read file", (Throwable)e).addContextValue((ErrorContext)FileErrorContext.FILE, (Object)file);
        }
    }

    public static void cleanDirectory(@NonNull File folder) {
        if (folder == null) {
            throw new NullPointerException("folder is marked @NonNull but is null");
        }
        if (!folder.exists()) {
            logger.info("Folder [{}] does not exist. No need to clean.", (Object)folder);
            return;
        }
        try {
            FileUtils.cleanDirectory((File)folder);
        }
        catch (IOException e) {
            throw new SystemException((ErrorType)FileErrorType.ERROR_CLEANING_FOLDER, (Throwable)e).addContextValue((ErrorContext)FileErrorContext.FOLDER, (Object)folder);
        }
    }
}

