package com.crabshue.commons.file;

import org.apache.commons.lang3.Validate;

import lombok.NonNull;

/**
 * Utility class for operations on file names.
 *
 */
public class FilenameUtils {

    /**
     * Encode a filename.
     * <p>
     * The provided filename cannot be null or empty, and its characters are replaced by "_" if different than alphanumeric (case insensitive) and
     * [_,.].
     * </p>
     *
     * @param filename the filename.
     * @return the encoded filename.
     */
    public static String encodeFilename(@NonNull final String filename) {
        Validate.notEmpty(filename);

        return filename.replaceAll("[^a-zA-Z0-9\\._]", "_");
    }
}
