/*
 * Decompiled with CFR 0.152.
 */
package com.crabshue.commons.exceptions.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ExceptionMessageUtils {
    private static final String VALUE_SEPARATOR = ", ";

    protected ExceptionMessageUtils() {
    }

    public static <T> String printList(Collection<T> collection, Function<T, String> printValueFunction) {
        return collection.stream().filter(Objects::nonNull).map(printValueFunction).collect(Collectors.joining(VALUE_SEPARATOR));
    }

    public static <T> String printValues(Function<T, String> printValueFunction, T ... collection) {
        return Arrays.stream(collection).filter(Objects::nonNull).map(printValueFunction).collect(Collectors.joining(VALUE_SEPARATOR));
    }

    public static <T, V> String printMap(Map<T, V> map, Function<T, String> printKey, Function<V, String> printValue) {
        return map.keySet().stream().filter(Objects::nonNull).map(k -> "(" + (String)printKey.apply(k) + ":" + (Objects.isNull(map.get(k)) ? "" : (String)printValue.apply(map.get(k))) + ")").collect(Collectors.joining(VALUE_SEPARATOR));
    }
}

