package com.crabshue.commons.exceptions;

import com.crabshue.commons.exceptions.context.ErrorType;

/**
 * Exception used to raise validation errors.
 */
public class ValidationException extends AbstractException {

    protected ValidationException() {
    }

    /**
     * @see AbstractException#AbstractException(ErrorType)
     */
    public ValidationException(final ErrorType errorType) {
        super(errorType);
    }


    /**
     * @see AbstractException#AbstractException(ErrorType, Throwable)
     */
    public ValidationException(final ErrorType errorType, final Throwable cause) {
        super(errorType, cause);
    }


    /**
     * @see AbstractException#AbstractException(ErrorType, String)
     */
    public ValidationException(final ErrorType errorType, final String message) {
        super(errorType, message);
    }


    /**
     * @see AbstractException#AbstractException(ErrorType, String, Throwable)
     */
    public ValidationException(final ErrorType errorType, final String message, final Throwable cause) {
        super(errorType, message, cause);
    }
}
