/*
 * Decompiled with CFR 0.152.
 */
package com.crabshue.commons.exceptions.utils;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionUtils.class);
    private static final int MESSAGE_MAX_LENGTH = 4000;

    public static String buildMessageFromThrowable(Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        try {
            String message = throwable.getMessage();
            sb.append(message);
            sb.append("\n");
            if (throwable.getCause() != null) {
                String causeMessage = ExceptionUtils.buildMessageFromThrowable(throwable.getCause());
                sb.append(causeMessage);
            }
        }
        catch (Exception e) {
            logger.error("Cannot read exception ", (Throwable)e);
            sb.append("something went wrong");
        }
        return StringUtils.abbreviate((String)StringUtils.removeEnd((String)sb.toString(), (String)"\n"), (int)4000);
    }

    public static void removeStackTraces(Throwable throwable) {
        throwable.setStackTrace(new StackTraceElement[0]);
        if (throwable.getCause() != null) {
            ExceptionUtils.removeStackTraces(throwable.getCause());
        }
    }
}

