/*
 * Decompiled with CFR 0.152.
 */
package io.xjar.jar;

import io.xjar.XConstants;
import io.xjar.XDecryptor;
import io.xjar.XEntryDecryptor;
import io.xjar.XEntryFilter;
import io.xjar.XKit;
import io.xjar.XUnclosedInputStream;
import io.xjar.XUnclosedOutputStream;
import io.xjar.jar.XJarAllEntryFilter;
import io.xjar.key.XKey;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;

public class XJarDecryptor
extends XEntryDecryptor<JarArchiveEntry>
implements XDecryptor,
XConstants {
    private final int level;

    public XJarDecryptor(XDecryptor xDecryptor) {
        this(xDecryptor, new XJarAllEntryFilter());
    }

    public XJarDecryptor(XDecryptor xDecryptor, XEntryFilter<JarArchiveEntry> filter) {
        this(xDecryptor, -1, filter);
    }

    public XJarDecryptor(XDecryptor xDecryptor, int level) {
        this(xDecryptor, level, new XJarAllEntryFilter());
    }

    public XJarDecryptor(XDecryptor xDecryptor, int level, XEntryFilter<JarArchiveEntry> filter) {
        super(xDecryptor, filter);
        this.level = level;
    }

    @Override
    public void decrypt(XKey key, File src, File dest) throws IOException {
        try (FileInputStream fis = new FileInputStream(src);
             FileOutputStream fos = new FileOutputStream(dest);){
            this.decrypt(key, fis, fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrypt(XKey key, InputStream in, OutputStream out) throws IOException {
        JarArchiveInputStream zis = null;
        JarArchiveOutputStream zos = null;
        try {
            JarArchiveEntry entry;
            zis = new JarArchiveInputStream(in);
            zos = new JarArchiveOutputStream(out);
            zos.setLevel(this.level);
            XUnclosedInputStream nis = new XUnclosedInputStream((InputStream)zis);
            XUnclosedOutputStream nos = new XUnclosedOutputStream((OutputStream)zos);
            while ((entry = zis.getNextJarEntry()) != null) {
                JarArchiveEntry jarArchiveEntry;
                if (entry.getName().startsWith(XJAR_SRC_DIR) || entry.getName().endsWith("XJAR-INF/") || entry.getName().endsWith("XJAR-INF/INDEXES.IDX")) continue;
                if (entry.isDirectory()) {
                    jarArchiveEntry = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry);
                } else if (entry.getName().equals("META-INF/MANIFEST.MF")) {
                    Manifest manifest = new Manifest(nis);
                    Attributes attributes = manifest.getMainAttributes();
                    String mainClass = attributes.getValue("Jar-Main-Class");
                    if (mainClass != null) {
                        attributes.putValue("Main-Class", mainClass);
                        attributes.remove(new Attributes.Name("Jar-Main-Class"));
                    }
                    JarArchiveEntry jarArchiveEntry2 = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry2.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry2);
                    manifest.write(nos);
                } else {
                    jarArchiveEntry = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry);
                    boolean filtered = this.filtrate(entry);
                    XDecryptor decryptor = filtered ? this.xDecryptor : this.xNopDecryptor;
                    try (OutputStream eos = decryptor.decrypt(key, nos);){
                        XKit.transfer((InputStream)nis, eos);
                    }
                }
                zos.closeArchiveEntry();
            }
            zos.finish();
        }
        catch (Throwable throwable) {
            XKit.close(zis);
            XKit.close(zos);
            throw throwable;
        }
        XKit.close((Closeable)zis);
        XKit.close((Closeable)zos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean predicate(InputStream jar) throws IOException {
        boolean bl;
        JarArchiveInputStream zis = null;
        try {
            JarArchiveEntry entry;
            zis = new JarArchiveInputStream(jar);
            while ((entry = zis.getNextJarEntry()) != null) {
                if (entry.getName().startsWith(XJAR_SRC_DIR) || entry.getName().endsWith("XJAR-INF/") || entry.getName().endsWith("XJAR-INF/INDEXES.IDX") || entry.isDirectory() || entry.getName().equals("META-INF/MANIFEST.MF") || !this.filtrate(entry)) continue;
                bl = true;
            }
        }
        catch (Throwable throwable) {
            XKit.close(zis);
            throw throwable;
        }
        {
            XKit.close((Closeable)zis);
            return bl;
        }
        boolean bl2 = false;
        XKit.close((Closeable)zis);
        return bl2;
    }
}

