/*
 * Decompiled with CFR 0.152.
 */
package io.xjar.boot;

import io.xjar.XConstants;
import io.xjar.XEncryptor;
import io.xjar.XEntryEncryptor;
import io.xjar.XEntryFilter;
import io.xjar.XGo;
import io.xjar.XInjector;
import io.xjar.XKit;
import io.xjar.XUnclosedInputStream;
import io.xjar.XUnclosedOutputStream;
import io.xjar.boot.XBootJarArchiveEntry;
import io.xjar.jar.XJarAllEntryFilter;
import io.xjar.jar.XJarEncryptor;
import io.xjar.key.XKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;

public class XBootEncryptor
extends XEntryEncryptor<JarArchiveEntry>
implements XEncryptor,
XConstants {
    private final Map<String, String> map = new HashMap<String, String>();
    private final int level;

    public XBootEncryptor(XEncryptor xEncryptor) {
        this(xEncryptor, new XJarAllEntryFilter());
    }

    public XBootEncryptor(XEncryptor xEncryptor, XEntryFilter<JarArchiveEntry> filter) {
        this(xEncryptor, -1, filter);
    }

    public XBootEncryptor(XEncryptor xEncryptor, int level) {
        this(xEncryptor, level, new XJarAllEntryFilter());
    }

    public XBootEncryptor(XEncryptor xEncryptor, int level, XEntryFilter<JarArchiveEntry> filter) {
        super(xEncryptor, filter);
        String jarLauncher = "org.springframework.boot.loader.JarLauncher";
        String warLauncher = "org.springframework.boot.loader.WarLauncher";
        String extLauncher = "org.springframework.boot.loader.PropertiesLauncher";
        this.map.put("org.springframework.boot.loader.JarLauncher", "io.xjar.boot.XJarLauncher");
        this.map.put("org.springframework.boot.loader.WarLauncher", "io.xjar.boot.XWarLauncher");
        this.map.put("org.springframework.boot.loader.PropertiesLauncher", "io.xjar.boot.XExtLauncher");
        this.level = level;
    }

    @Override
    public void encrypt(XKey key, File src, File dest) throws IOException {
        try (FileInputStream fis = new FileInputStream(src);
             FileOutputStream fos = new FileOutputStream(dest);){
            this.encrypt(key, fis, fos);
            XGo.make(dest, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encrypt(XKey key, InputStream in, OutputStream out) throws IOException {
        JarArchiveInputStream zis = null;
        JarArchiveOutputStream zos = null;
        LinkedHashSet<String> indexes = new LinkedHashSet<String>();
        try {
            String mainClass;
            JarArchiveEntry entry;
            zis = new JarArchiveInputStream(in);
            zos = new JarArchiveOutputStream(out);
            zos.setLevel(this.level);
            XUnclosedInputStream nis = new XUnclosedInputStream((InputStream)zis);
            XUnclosedOutputStream nos = new XUnclosedOutputStream((OutputStream)zos);
            XJarEncryptor xJarEncryptor = new XJarEncryptor(this.xEncryptor, this.level, this.filter);
            Manifest manifest = null;
            while ((entry = zis.getNextJarEntry()) != null) {
                JarArchiveEntry jarArchiveEntry;
                if (entry.getName().startsWith(XJAR_SRC_DIR) || entry.getName().endsWith("XJAR-INF/") || entry.getName().endsWith("XJAR-INF/INDEXES.IDX")) continue;
                if (entry.isDirectory()) {
                    jarArchiveEntry = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry);
                } else if (entry.getName().equals("META-INF/MANIFEST.MF")) {
                    manifest = new Manifest(nis);
                    Attributes attributes = manifest.getMainAttributes();
                    String mainClass2 = attributes.getValue("Main-Class");
                    if (mainClass2 != null) {
                        attributes.putValue("Boot-Main-Class", mainClass2);
                        attributes.putValue("Main-Class", this.map.get(mainClass2));
                    }
                    JarArchiveEntry jarArchiveEntry2 = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry2.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry2);
                    manifest.write(nos);
                } else if (entry.getName().startsWith("BOOT-INF/classes/")) {
                    jarArchiveEntry = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry);
                    XBootJarArchiveEntry xBootJarArchiveEntry = new XBootJarArchiveEntry((ZipArchiveEntry)entry);
                    boolean filtered = this.filtrate(xBootJarArchiveEntry);
                    if (filtered) {
                        indexes.add(xBootJarArchiveEntry.getName());
                    }
                    XEncryptor encryptor = filtered ? this.xEncryptor : this.xNopEncryptor;
                    try (OutputStream eos = encryptor.encrypt(key, nos);){
                        XKit.transfer((InputStream)nis, eos);
                    }
                } else if (entry.getName().startsWith("BOOT-INF/lib/")) {
                    byte[] data = XKit.read(nis);
                    ByteArrayInputStream lib = new ByteArrayInputStream(data);
                    boolean need = xJarEncryptor.predicate(lib);
                    lib.reset();
                    if (need) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        CheckedOutputStream cos = new CheckedOutputStream(bos, new CRC32());
                        xJarEncryptor.encrypt(key, lib, cos);
                        JarArchiveEntry jarArchiveEntry3 = new JarArchiveEntry(entry.getName());
                        jarArchiveEntry3.setMethod(0);
                        jarArchiveEntry3.setSize((long)bos.size());
                        jarArchiveEntry3.setTime(entry.getTime());
                        jarArchiveEntry3.setCrc(cos.getChecksum().getValue());
                        zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry3);
                        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                        XKit.transfer((InputStream)bis, nos);
                    } else {
                        JarArchiveEntry jarArchiveEntry4 = new JarArchiveEntry(entry.getName());
                        jarArchiveEntry4.setMethod(0);
                        jarArchiveEntry4.setSize(entry.getSize());
                        jarArchiveEntry4.setTime(entry.getTime());
                        jarArchiveEntry4.setCrc(entry.getCrc());
                        zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry4);
                        XKit.transfer((InputStream)lib, nos);
                    }
                } else {
                    jarArchiveEntry = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry);
                    XKit.transfer((InputStream)nis, nos);
                }
                zos.closeArchiveEntry();
            }
            if (!indexes.isEmpty()) {
                JarArchiveEntry xjarInfDir = new JarArchiveEntry("BOOT-INF/classes/XJAR-INF/");
                xjarInfDir.setTime(System.currentTimeMillis());
                zos.putArchiveEntry((ArchiveEntry)xjarInfDir);
                zos.closeArchiveEntry();
                JarArchiveEntry xjarInfIdx = new JarArchiveEntry("BOOT-INF/classes/XJAR-INF/INDEXES.IDX");
                xjarInfIdx.setTime(System.currentTimeMillis());
                zos.putArchiveEntry((ArchiveEntry)xjarInfIdx);
                for (String index : indexes) {
                    zos.write(index.getBytes());
                    zos.write(CRLF.getBytes());
                }
                zos.closeArchiveEntry();
            }
            String string = mainClass = manifest != null && manifest.getMainAttributes() != null ? manifest.getMainAttributes().getValue("Main-Class") : null;
            if (mainClass != null) {
                XInjector.inject(zos);
            }
            zos.finish();
        }
        catch (Throwable throwable) {
            XKit.close(zis);
            XKit.close(zos);
            throw throwable;
        }
        XKit.close((Closeable)zis);
        XKit.close((Closeable)zos);
    }
}

