/*
 * Decompiled with CFR 0.152.
 */
package io.xjar.boot;

import io.xjar.XConstants;
import io.xjar.XDecryptor;
import io.xjar.XEncryptor;
import io.xjar.XEntryFilter;
import io.xjar.XFilters;
import io.xjar.XJdkDecryptor;
import io.xjar.XJdkEncryptor;
import io.xjar.XKit;
import io.xjar.boot.XBootDecryptor;
import io.xjar.boot.XBootEncryptor;
import io.xjar.key.XKey;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;

public class XBoot
extends XFilters
implements XConstants {
    public static void encrypt(String src, String dest, XKey xKey) throws Exception {
        XBoot.encrypt(new File(src), new File(dest), xKey);
    }

    public static void encrypt(File src, File dest, XKey xKey) throws Exception {
        XBootEncryptor xBootEncryptor = new XBootEncryptor(new XJdkEncryptor());
        xBootEncryptor.encrypt(xKey, src, dest);
    }

    public static void encrypt(InputStream in, OutputStream out, XKey xKey) throws Exception {
        XBootEncryptor xBootEncryptor = new XBootEncryptor(new XJdkEncryptor());
        xBootEncryptor.encrypt(xKey, in, out);
    }

    public static void encrypt(String src, String dest, XKey xKey, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.encrypt(new File(src), new File(dest), xKey, filter);
    }

    public static void encrypt(File src, File dest, XKey xKey, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBootEncryptor xBootEncryptor = new XBootEncryptor((XEncryptor)new XJdkEncryptor(), filter);
        xBootEncryptor.encrypt(xKey, src, dest);
    }

    public static void encrypt(InputStream in, OutputStream out, XKey xKey, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBootEncryptor xBootEncryptor = new XBootEncryptor((XEncryptor)new XJdkEncryptor(), filter);
        xBootEncryptor.encrypt(xKey, in, out);
    }

    public static void encrypt(String src, String dest, String password) throws Exception {
        XBoot.encrypt(src, dest, XKit.key(password));
    }

    public static void encrypt(File src, File dest, String password) throws Exception {
        XBoot.encrypt(src, dest, XKit.key(password));
    }

    public static void encrypt(InputStream in, OutputStream out, String password) throws Exception {
        XBoot.encrypt(in, out, XKit.key(password));
    }

    public static void encrypt(String src, String dest, String password, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.encrypt(src, dest, XKit.key(password), filter);
    }

    public static void encrypt(File src, File dest, String password, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.encrypt(src, dest, XKit.key(password), filter);
    }

    public static void encrypt(InputStream in, OutputStream out, String password, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.encrypt(in, out, XKit.key(password), filter);
    }

    public static void decrypt(String src, String dest, XKey xKey) throws Exception {
        XBoot.decrypt(new File(src), new File(dest), xKey);
    }

    public static void decrypt(File src, File dest, XKey xKey) throws Exception {
        XBootDecryptor xBootDecryptor = new XBootDecryptor(new XJdkDecryptor());
        xBootDecryptor.decrypt(xKey, src, dest);
    }

    public static void decrypt(InputStream in, OutputStream out, XKey xKey) throws Exception {
        XBootDecryptor xBootDecryptor = new XBootDecryptor(new XJdkDecryptor());
        xBootDecryptor.decrypt(xKey, in, out);
    }

    public static void decrypt(String src, String dest, XKey xKey, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.decrypt(new File(src), new File(dest), xKey, filter);
    }

    public static void decrypt(File src, File dest, XKey xKey, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBootDecryptor xBootDecryptor = new XBootDecryptor((XDecryptor)new XJdkDecryptor(), filter);
        xBootDecryptor.decrypt(xKey, src, dest);
    }

    public static void decrypt(InputStream in, OutputStream out, XKey xKey, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBootDecryptor xBootDecryptor = new XBootDecryptor((XDecryptor)new XJdkDecryptor(), filter);
        xBootDecryptor.decrypt(xKey, in, out);
    }

    public static void decrypt(String src, String dest, String password) throws Exception {
        XBoot.decrypt(src, dest, XKit.key(password));
    }

    public static void decrypt(File src, File dest, String password) throws Exception {
        XBoot.decrypt(src, dest, XKit.key(password));
    }

    public static void decrypt(InputStream in, OutputStream out, String password) throws Exception {
        XBoot.decrypt(in, out, XKit.key(password));
    }

    public static void decrypt(String src, String dest, String password, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.decrypt(src, dest, XKit.key(password), filter);
    }

    public static void decrypt(File src, File dest, String password, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.decrypt(src, dest, XKit.key(password), filter);
    }

    public static void decrypt(InputStream in, OutputStream out, String password, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XBoot.decrypt(in, out, XKit.key(password), filter);
    }
}

