/*
 * Decompiled with CFR 0.152.
 */
package io.xjar;

import io.xjar.XCryptos;
import io.xjar.XEntryFilter;
import io.xjar.XFilters;
import io.xjar.XKit;
import io.xjar.filter.XAllEntryFilter;
import io.xjar.filter.XAnyEntryFilter;
import io.xjar.filter.XMixEntryFilter;
import io.xjar.key.XKey;
import java.io.File;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;

public class XDecryption {
    private File xJar;
    private XKey key;
    private XAnyEntryFilter<JarArchiveEntry> includes = XKit.any();
    private XAllEntryFilter<JarArchiveEntry> excludes = XKit.all();

    public XDecryption from(String xJar) {
        return this.from(new File(xJar));
    }

    public XDecryption from(File xJar) {
        this.xJar = xJar;
        return this;
    }

    public XDecryption use(String password) {
        try {
            this.key = XKit.key(password);
            return this;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public XDecryption use(String algorithm, int keysize, int ivsize, String password) {
        try {
            this.key = XKit.key(algorithm, keysize, ivsize, password);
            return this;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public XDecryption include(String ant) {
        this.includes.mix((XEntryFilter)XFilters.ant(ant));
        return this;
    }

    public XDecryption include(Pattern regex) {
        this.includes.mix((XEntryFilter)XFilters.regex(regex.pattern()));
        return this;
    }

    public XDecryption exclude(String ant) {
        this.excludes.mix(XFilters.not(XFilters.ant(ant)));
        return this;
    }

    public XDecryption exclude(Pattern regex) {
        this.excludes.mix(XFilters.not(XFilters.regex(regex.pattern())));
        return this;
    }

    public void to(String jar) throws Exception {
        this.to(new File(jar));
    }

    public void to(File jar) throws Exception {
        XAllEntryFilter<JarArchiveEntry> filter;
        if (this.xJar == null) {
            throw new IllegalArgumentException("xJar to decrypt is null. [please call from(String xJar) or from(File xJar) before]");
        }
        if (this.key == null) {
            throw new IllegalArgumentException("key to decrypt is null. [please call use(String password) or use(String algorithm, int keysize, int ivsize, String password) before]");
        }
        if (this.includes.size() == 0 && this.excludes.size() == 0) {
            filter = null;
        } else {
            filter = XKit.all();
            if (this.includes.size() > 0) {
                ((XMixEntryFilter)filter).mix(this.includes);
            }
            if (this.excludes.size() > 0) {
                ((XMixEntryFilter)filter).mix(this.excludes);
            }
        }
        XCryptos.decrypt(this.xJar, jar, this.key, filter);
    }
}

