/*
 * Decompiled with CFR 0.152.
 */
package io.xjar.jar;

import io.xjar.XConstants;
import io.xjar.XEncryptor;
import io.xjar.XEntryEncryptor;
import io.xjar.XEntryFilter;
import io.xjar.XGo;
import io.xjar.XInjector;
import io.xjar.XKit;
import io.xjar.XUnclosedInputStream;
import io.xjar.XUnclosedOutputStream;
import io.xjar.jar.XJarAllEntryFilter;
import io.xjar.key.XKey;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;

public class XJarEncryptor
extends XEntryEncryptor<JarArchiveEntry>
implements XEncryptor,
XConstants {
    private final int level;

    public XJarEncryptor(XEncryptor xEncryptor) {
        this(xEncryptor, new XJarAllEntryFilter());
    }

    public XJarEncryptor(XEncryptor xEncryptor, XEntryFilter<JarArchiveEntry> filter) {
        this(xEncryptor, -1, filter);
    }

    public XJarEncryptor(XEncryptor xEncryptor, int level) {
        this(xEncryptor, level, new XJarAllEntryFilter());
    }

    public XJarEncryptor(XEncryptor xEncryptor, int level, XEntryFilter<JarArchiveEntry> filter) {
        super(xEncryptor, filter);
        this.level = level;
    }

    @Override
    public void encrypt(XKey key, File src, File dest) throws IOException {
        try (FileInputStream fis = new FileInputStream(src);
             FileOutputStream fos = new FileOutputStream(dest);){
            this.encrypt(key, fis, fos);
            XGo.make(dest, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encrypt(XKey key, InputStream in, OutputStream out) throws IOException {
        JarArchiveInputStream zis = null;
        JarArchiveOutputStream zos = null;
        LinkedHashSet<String> indexes = new LinkedHashSet<String>();
        try {
            String mainClass;
            JarArchiveEntry entry;
            zis = new JarArchiveInputStream(in);
            zos = new JarArchiveOutputStream(out);
            zos.setLevel(this.level);
            XUnclosedInputStream nis = new XUnclosedInputStream((InputStream)zis);
            XUnclosedOutputStream nos = new XUnclosedOutputStream((OutputStream)zos);
            Manifest manifest = null;
            while ((entry = zis.getNextJarEntry()) != null) {
                JarArchiveEntry jarArchiveEntry;
                if (entry.getName().startsWith(XJAR_SRC_DIR) || entry.getName().endsWith("XJAR-INF/") || entry.getName().endsWith("XJAR-INF/INDEXES.IDX")) continue;
                if (entry.isDirectory()) {
                    jarArchiveEntry = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry);
                } else if (entry.getName().equals("META-INF/MANIFEST.MF")) {
                    manifest = new Manifest(nis);
                    Attributes attributes = manifest.getMainAttributes();
                    String mainClass2 = attributes.getValue("Main-Class");
                    if (mainClass2 != null) {
                        attributes.putValue("Jar-Main-Class", mainClass2);
                        attributes.putValue("Main-Class", "io.xjar.jar.XJarLauncher");
                    }
                    JarArchiveEntry jarArchiveEntry2 = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry2.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry2);
                    manifest.write(nos);
                } else {
                    jarArchiveEntry = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry);
                    boolean filtered = this.filtrate(entry);
                    if (filtered) {
                        indexes.add(entry.getName());
                    }
                    XEncryptor encryptor = filtered ? this.xEncryptor : this.xNopEncryptor;
                    try (OutputStream eos = encryptor.encrypt(key, nos);){
                        XKit.transfer((InputStream)nis, eos);
                    }
                }
                zos.closeArchiveEntry();
            }
            if (!indexes.isEmpty()) {
                JarArchiveEntry xjarInfDir = new JarArchiveEntry("XJAR-INF/");
                xjarInfDir.setTime(System.currentTimeMillis());
                zos.putArchiveEntry((ArchiveEntry)xjarInfDir);
                zos.closeArchiveEntry();
                JarArchiveEntry xjarInfIdx = new JarArchiveEntry("XJAR-INF/INDEXES.IDX");
                xjarInfIdx.setTime(System.currentTimeMillis());
                zos.putArchiveEntry((ArchiveEntry)xjarInfIdx);
                for (String index : indexes) {
                    zos.write(index.getBytes());
                    zos.write(CRLF.getBytes());
                }
                zos.closeArchiveEntry();
            }
            String string = mainClass = manifest != null && manifest.getMainAttributes() != null ? manifest.getMainAttributes().getValue("Main-Class") : null;
            if (mainClass != null) {
                XInjector.inject(zos);
            }
            zos.finish();
        }
        catch (Throwable throwable) {
            XKit.close(zis);
            XKit.close(zos);
            throw throwable;
        }
        XKit.close((Closeable)zis);
        XKit.close((Closeable)zos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean predicate(InputStream jar) throws IOException {
        boolean bl;
        JarArchiveInputStream zis = null;
        try {
            JarArchiveEntry entry;
            zis = new JarArchiveInputStream(jar);
            while ((entry = zis.getNextJarEntry()) != null) {
                if (entry.getName().startsWith(XJAR_SRC_DIR) || entry.getName().endsWith("XJAR-INF/") || entry.getName().endsWith("XJAR-INF/INDEXES.IDX") || entry.isDirectory() || entry.getName().equals("META-INF/MANIFEST.MF") || !this.filtrate(entry)) continue;
                bl = true;
            }
        }
        catch (Throwable throwable) {
            XKit.close(zis);
            throw throwable;
        }
        {
            XKit.close((Closeable)zis);
            return bl;
        }
        boolean bl2 = false;
        XKit.close((Closeable)zis);
        return bl2;
    }
}

