/*
 * Decompiled with CFR 0.152.
 */
package io.xjar.boot;

import io.xjar.XDecryptor;
import io.xjar.XEncryptor;
import io.xjar.XKit;
import io.xjar.boot.XBootURLHandler;
import io.xjar.key.XKey;
import io.xjar.reflection.XReflection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandler;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.Enumeration;
import org.springframework.boot.loader.LaunchedURLClassLoader;

public class XBootClassLoader
extends LaunchedURLClassLoader {
    private final XBootURLHandler xBootURLHandler;
    private final Object urlClassPath;
    private final Method getResource;
    private final Method getCodeSourceURL;
    private final Method getCodeSigners;

    public XBootClassLoader(URL[] urls, ClassLoader parent, XDecryptor xDecryptor, XEncryptor xEncryptor, XKey xKey) throws Exception {
        super(urls, parent);
        this.xBootURLHandler = new XBootURLHandler(xDecryptor, xEncryptor, xKey, (ClassLoader)((Object)this));
        this.urlClassPath = XReflection.field(URLClassLoader.class, "ucp").get((Object)this).value();
        this.getResource = XReflection.method(this.urlClassPath.getClass(), "getResource", String.class).method();
        this.getCodeSourceURL = XReflection.method(this.getResource.getReturnType(), "getCodeSourceURL", new Class[0]).method();
        this.getCodeSigners = XReflection.method(this.getResource.getReturnType(), "getCodeSigners", new Class[0]).method();
    }

    public URL findResource(String name) {
        URL url = super.findResource(name);
        if (url == null) {
            return null;
        }
        try {
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile(), (URLStreamHandler)((Object)this.xBootURLHandler));
        }
        catch (MalformedURLException e) {
            return url;
        }
    }

    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration enumeration = super.findResources(name);
        if (enumeration == null) {
            return null;
        }
        return new XBootEnumeration(enumeration);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassFormatError e) {
            String path = name.replace('.', '/').concat(".class");
            URL url = this.findResource(path);
            if (url == null) {
                throw new ClassNotFoundException(name, e);
            }
            try (InputStream in = url.openStream();){
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                XKit.transfer(in, bos);
                byte[] bytes = bos.toByteArray();
                Object resource = this.getResource.invoke(this.urlClassPath, path);
                URL codeSourceURL = (URL)this.getCodeSourceURL.invoke(resource, new Object[0]);
                CodeSigner[] codeSigners = (CodeSigner[])this.getCodeSigners.invoke(resource, new Object[0]);
                CodeSource codeSource = new CodeSource(codeSourceURL, codeSigners);
                Class clazz = this.defineClass(name, bytes, 0, bytes.length, codeSource);
                return clazz;
            }
            catch (Throwable t) {
                throw new ClassNotFoundException(name, t);
            }
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    private class XBootEnumeration
    implements Enumeration<URL> {
        private final Enumeration<URL> enumeration;

        XBootEnumeration(Enumeration<URL> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasMoreElements() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public URL nextElement() {
            URL url = this.enumeration.nextElement();
            if (url == null) {
                return null;
            }
            try {
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile(), (URLStreamHandler)((Object)XBootClassLoader.this.xBootURLHandler));
            }
            catch (MalformedURLException e) {
                return url;
            }
        }
    }
}

