/*
 * Decompiled with CFR 0.152.
 */
package io.xjar.jar;

import io.xjar.XConstants;
import io.xjar.XDecryptor;
import io.xjar.XEncryptor;
import io.xjar.XEntryFilter;
import io.xjar.XFilters;
import io.xjar.XJdkDecryptor;
import io.xjar.XJdkEncryptor;
import io.xjar.XKit;
import io.xjar.jar.XJarDecryptor;
import io.xjar.jar.XJarEncryptor;
import io.xjar.key.XKey;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;

public class XJar
extends XFilters
implements XConstants {
    public static void encrypt(String src, String dest, XKey xKey) throws Exception {
        XJar.encrypt(new File(src), new File(dest), xKey);
    }

    public static void encrypt(File src, File dest, XKey xKey) throws Exception {
        XJarEncryptor xJarEncryptor = new XJarEncryptor(new XJdkEncryptor());
        xJarEncryptor.encrypt(xKey, src, dest);
    }

    public static void encrypt(InputStream in, OutputStream out, XKey xKey) throws Exception {
        XJarEncryptor xJarEncryptor = new XJarEncryptor(new XJdkEncryptor());
        xJarEncryptor.encrypt(xKey, in, out);
    }

    public static void encrypt(String src, String dest, XKey xKey, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XJar.encrypt(new File(src), new File(dest), xKey, filter);
    }

    public static void encrypt(File src, File dest, XKey xKey, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XJarEncryptor xJarEncryptor = new XJarEncryptor((XEncryptor)new XJdkEncryptor(), filter);
        xJarEncryptor.encrypt(xKey, src, dest);
    }

    public static void encrypt(InputStream in, OutputStream out, XKey xKey, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XJarEncryptor xJarEncryptor = new XJarEncryptor((XEncryptor)new XJdkEncryptor(), filter);
        xJarEncryptor.encrypt(xKey, in, out);
    }

    public static void encrypt(String src, String dest, String password) throws Exception {
        XJar.encrypt(src, dest, XKit.key(password));
    }

    public static void encrypt(File src, File dest, String password) throws Exception {
        XJar.encrypt(src, dest, XKit.key(password));
    }

    public static void encrypt(InputStream in, OutputStream out, String password) throws Exception {
        XJar.encrypt(in, out, XKit.key(password));
    }

    public static void encrypt(String src, String dest, String password, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XJar.encrypt(src, dest, XKit.key(password), filter);
    }

    public static void encrypt(File src, File dest, String password, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XJar.encrypt(src, dest, XKit.key(password), filter);
    }

    public static void encrypt(InputStream in, OutputStream out, String password, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XJar.encrypt(in, out, XKit.key(password), filter);
    }

    public static void decrypt(String src, String dest, XKey xKey) throws Exception {
        XJar.decrypt(new File(src), new File(dest), xKey);
    }

    public static void decrypt(File src, File dest, XKey xKey) throws Exception {
        XJarDecryptor xJarDecryptor = new XJarDecryptor(new XJdkDecryptor());
        xJarDecryptor.decrypt(xKey, src, dest);
    }

    public static void decrypt(InputStream in, OutputStream out, XKey xKey) throws Exception {
        XJarDecryptor xJarDecryptor = new XJarDecryptor(new XJdkDecryptor());
        xJarDecryptor.decrypt(xKey, in, out);
    }

    public static void decrypt(String src, String dest, XKey xKey, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XJar.decrypt(new File(src), new File(dest), xKey, filter);
    }

    public static void decrypt(File src, File dest, XKey xKey, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XJarDecryptor xJarDecryptor = new XJarDecryptor((XDecryptor)new XJdkDecryptor(), filter);
        xJarDecryptor.decrypt(xKey, src, dest);
    }

    public static void decrypt(InputStream in, OutputStream out, XKey xKey, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XJarDecryptor xJarDecryptor = new XJarDecryptor((XDecryptor)new XJdkDecryptor(), filter);
        xJarDecryptor.decrypt(xKey, in, out);
    }

    public static void decrypt(String src, String dest, String password) throws Exception {
        XJar.decrypt(src, dest, XKit.key(password));
    }

    public static void decrypt(File src, File dest, String password) throws Exception {
        XJar.decrypt(src, dest, XKit.key(password));
    }

    public static void decrypt(InputStream in, OutputStream out, String password) throws Exception {
        XJar.decrypt(in, out, XKit.key(password));
    }

    public static void decrypt(String src, String dest, String password, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XJar.decrypt(src, dest, XKit.key(password), filter);
    }

    public static void decrypt(File src, File dest, String password, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XJar.decrypt(src, dest, XKit.key(password), filter);
    }

    public static void decrypt(InputStream in, OutputStream out, String password, XEntryFilter<JarArchiveEntry> filter) throws Exception {
        XJar.decrypt(in, out, XKit.key(password), filter);
    }
}

