/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.webservice;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import net.jradius.exception.RadiusException;
import net.jradius.realm.JRadiusRealm;
import net.jradius.realm.JRadiusRealmManager;
import net.jradius.server.ListenerRequest;
import net.jradius.server.Processor;
import net.jradius.server.TCPListenerRequest;
import net.jradius.webservice.OTPProxyException;
import net.jradius.webservice.OTPProxyRequest;
import net.jradius.webservice.WebServiceListener;

public class OTPProxyProcessor
extends Processor {
    protected void processRequest(ListenerRequest listenerRequest) throws IOException, RadiusException {
        Socket socket = ((TCPListenerRequest)listenerRequest).getSocket();
        try {
            JRadiusRealm realm;
            WebServiceListener wsListener = (WebServiceListener)listenerRequest.getListener();
            socket.setSoTimeout(7000);
            BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            String userName = reader.readLine();
            String realmName = this.realmFromUserName(userName);
            if (realmName == null) {
                this.error(writer, "No realm given");
            }
            if ((realm = JRadiusRealmManager.get((String)realmName)) == null) {
                this.error(writer, "Unrecognized realm: " + realmName);
            }
            OTPProxyRequest request = new OTPProxyRequest(wsListener, userName, realm, socket, reader, writer);
            request.start();
            wsListener.put(request);
        }
        catch (Exception e) {
            socket.close();
            throw new RadiusException(e);
        }
    }

    protected void error(BufferedWriter writer, String e) throws IOException, RadiusException {
        writer.write("error:" + e + "\n");
        writer.flush();
        throw new OTPProxyException(e);
    }

    protected String realmFromUserName(String username) throws OTPProxyException {
        int idx = username.indexOf("/");
        if (idx > 0 || (idx = username.indexOf("\\")) > 0) {
            return username.substring(0, idx);
        }
        idx = username.indexOf("@");
        if (idx > 0) {
            return username.substring(idx + 1);
        }
        return null;
    }
}

