/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.radsec;

import java.io.File;
import java.io.FileInputStream;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.X509KeyManager;
import net.jradius.util.KeyStoreUtil;
import org.springframework.beans.factory.InitializingBean;

public class SimpleKeyManager
implements X509KeyManager,
InitializingBean {
    private String keyFile;
    private String keyFileType;
    private String keyFilePassword;
    private X509KeyManager keyManager;

    public String chooseClientAlias(String[] arg0, Principal[] arg1, Socket arg2) {
        String alias = this.keyManager.chooseClientAlias(arg0, arg1, arg2);
        System.err.println("Client Alias: " + alias);
        return alias;
    }

    public String chooseServerAlias(String arg0, Principal[] arg1, Socket arg2) {
        String alias = this.keyManager.chooseServerAlias(arg0, arg1, arg2);
        System.err.println("Server Alias: " + alias);
        return alias;
    }

    public X509Certificate[] getCertificateChain(String arg0) {
        X509Certificate[] certs;
        for (X509Certificate cert : certs = this.keyManager.getCertificateChain(arg0)) {
            System.err.println(arg0 + " cert: " + cert.getSubjectDN());
        }
        return certs;
    }

    public String[] getClientAliases(String arg0, Principal[] arg1) {
        String[] alias;
        for (String a : alias = this.keyManager.getClientAliases(arg0, arg1)) {
            System.err.println("Server Alias: " + a);
        }
        return alias;
    }

    public PrivateKey getPrivateKey(String arg0) {
        return this.keyManager.getPrivateKey(arg0);
    }

    public String[] getServerAliases(String arg0, Principal[] arg1) {
        String[] alias;
        for (String a : alias = this.keyManager.getServerAliases(arg0, arg1)) {
            System.err.println("Server Alias: " + a);
        }
        return alias;
    }

    public void afterPropertiesSet() throws Exception {
        KeyManager[] keyManagers = KeyStoreUtil.loadKeyManager(this.keyFileType, new FileInputStream(new File(this.keyFile)), this.keyFilePassword);
        if (keyManagers == null || keyManagers.length == 0) {
            throw new RuntimeException("could not initialize RadSec keystore");
        }
        this.keyManager = (X509KeyManager)keyManagers[0];
    }

    public void setKeyFile(String keyFile) {
        this.keyFile = keyFile;
    }

    public void setKeyFileType(String keyFileType) {
        this.keyFileType = keyFileType;
    }

    public void setKeyFilePassword(String keyFilePassword) {
        this.keyFilePassword = keyFilePassword;
    }
}

