/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.radsec;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import net.jradius.exception.RadiusException;
import net.jradius.handler.chain.JRCommand;
import net.jradius.log.RadiusLog;
import net.jradius.packet.RadiusFormat;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.RadiusRequest;
import net.jradius.packet.RadiusResponse;
import net.jradius.radsec.RadSecRequest;
import net.jradius.server.JRadiusRequest;
import net.jradius.server.JRadiusServer;
import net.jradius.server.ListenerRequest;
import net.jradius.server.RadiusProcessor;
import net.jradius.server.config.Configuration;
import net.jradius.util.MessageAuthenticator;

public class RadSecProcessor
extends RadiusProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(ListenerRequest listenerRequest) throws Exception {
        RadSecRequest request = (RadSecRequest)listenerRequest.getRequestEvent();
        try {
            request.setApplicationContext(this.getApplicationContext());
            request.setReturnValue(this.runPacketHandlers((JRadiusRequest)request));
        }
        catch (Throwable th) {
            request.setReturnValue(1);
            RadiusLog.error((String)">>> processRequest(): Error during processing RunPacketHandlers block", (Throwable)th);
        }
        try {
            OutputStream out;
            OutputStream outputStream = out = listenerRequest.getOutputStream();
            synchronized (outputStream) {
                this.writeResponse((JRadiusRequest)request, request.buffer_out, out);
            }
        }
        catch (Throwable e) {
            RadiusLog.error((String)">>> processRequest(): Error during writing response", (Throwable)e);
        }
    }

    public void writeResponse(JRadiusRequest request, ByteBuffer buffer, OutputStream outputStream) throws IOException, RadiusException, InvalidKeyException, NoSuchAlgorithmException {
        if (Configuration.isDebug()) {
            request.printDebugInfo();
        }
        RadiusPacket[] rp = request.getPackets();
        RadiusRequest req = (RadiusRequest)rp[0];
        RadiusResponse res = (RadiusResponse)rp[1];
        String sharedSecret = (String)req.getAttributeValue(1189L);
        RadiusFormat format = RadiusFormat.getInstance();
        MessageAuthenticator.generateResponseMessageAuthenticator((RadiusPacket)req, (RadiusPacket)res, (String)sharedSecret);
        res.generateAuthenticator(req.getAuthenticator(), sharedSecret);
        buffer.clear();
        format.packPacket((RadiusPacket)res, sharedSecret, buffer, true);
        outputStream.write(buffer.array(), 0, buffer.position());
        outputStream.flush();
    }

    protected void logReturnCode(int result, JRCommand handler) {
        switch (result) {
            case 1: 
            case 4: 
            case 6: {
                RadiusLog.error((String)("Error: Packet handler returned " + JRadiusServer.resultCodeToString((int)result) + ". Stopped handling this packet."));
                break;
            }
            case 0: 
            case 3: {
                RadiusLog.info((String)("Packet handler returned " + JRadiusServer.resultCodeToString((int)result) + ". Stopped handling this packet."));
                break;
            }
            default: {
                RadiusLog.debug((String)("Packet handler " + handler.getName() + " returned " + JRadiusServer.resultCodeToString((int)result) + ". Continue handling this packet."));
            }
        }
    }
}

