/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.util;

import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class Latch
extends AbstractQueuedSynchronizer {
    public static final int UNLATCHED = 0;
    public static final int EXCLUSIVE = Integer.MIN_VALUE;
    public static final int SHARED = 1;

    public Latch() {
    }

    public Latch(int initialState) {
        this.setState(initialState);
    }

    public final boolean tryAcquireExclusive() {
        return this.getState() == 0 ? this.compareAndSetState(0, Integer.MIN_VALUE) : false;
    }

    public final boolean tryAcquireExclusiveNanos(long nanosTimeout) throws InterruptedException {
        return this.tryAcquireNanos(0, nanosTimeout);
    }

    public final void acquireExclusive() {
        if (this.getState() != 0 || !this.compareAndSetState(0, Integer.MIN_VALUE)) {
            this.acquire(0);
        }
    }

    public final void acquireExclusiveInterruptibly() throws InterruptedException {
        this.acquireInterruptibly(0);
    }

    public final void downgrade() {
        this.release(1);
    }

    public final void releaseExclusive() {
        this.release(0);
    }

    public final void release(boolean exclusive) {
        if (exclusive) {
            this.release(0);
        } else {
            this.releaseShared(0);
        }
    }

    public final void releaseEither() {
        if (this.getState() < 0) {
            this.release(0);
        } else {
            this.releaseShared(0);
        }
    }

    public final boolean tryAcquireShared() {
        int state;
        while ((state = this.getState()) >= 0) {
            if (!this.compareAndSetState(state, state + 1)) continue;
            return true;
        }
        return false;
    }

    public final boolean tryAcquireSharedNanos(long nanosTimeout) throws InterruptedException {
        return this.tryAcquireSharedNanos(0, nanosTimeout);
    }

    public final void acquireShared() {
        this.acquireShared(0);
    }

    public final void acquireSharedInterruptibly() throws InterruptedException {
        this.acquireSharedInterruptibly(0);
    }

    public final boolean tryUpgrade() {
        return this.getState() == 1 ? this.compareAndSetState(1, Integer.MIN_VALUE) : false;
    }

    public final void releaseShared() {
        this.releaseShared(0);
    }

    @Override
    protected final boolean tryAcquire(int x) {
        return this.getState() == 0 ? this.compareAndSetState(0, Integer.MIN_VALUE) : false;
    }

    @Override
    protected final int tryAcquireShared(int x) {
        int state;
        while ((state = this.getState()) >= 0) {
            if (this.compareAndSetState(state, state + 1)) {
                return 1;
            }
            if (!this.hasQueuedPredecessors()) continue;
            return -1;
        }
        return -1;
    }

    @Override
    protected final boolean tryReleaseShared(int x) {
        int state;
        while (!this.compareAndSetState(state = this.getState(), state - 1)) {
        }
        return state == 1;
    }

    @Override
    protected final boolean tryRelease(int newState) {
        this.setState(newState);
        return true;
    }
}

