/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.util.HashMap;
import java.util.Map;
import org.cojen.tupl.CorruptDatabaseException;
import org.cojen.tupl.io.CauseCloseable;

public class Utils {
    private static volatile boolean cDeleteUnsupported;
    private static Map<Closeable, Thread> cCloseThreads;

    protected Utils() {
    }

    public static int compareUnsigned(byte[] a, byte[] b) {
        return Utils.compareUnsigned(a, 0, a.length, b, 0, b.length);
    }

    public static int compareUnsigned(byte[] a, int aoff, int alen, byte[] b, int boff, int blen) {
        int minLen = Math.min(alen, blen);
        for (int i = 0; i < minLen; ++i) {
            byte ab = a[aoff + i];
            byte bb = b[boff + i];
            if (ab == bb) continue;
            return (ab & 0xFF) - (bb & 0xFF);
        }
        return alen - blen;
    }

    public static boolean increment(byte[] value, int start, int end) {
        while (--end >= start) {
            int n = end;
            value[n] = (byte)(value[n] + 1);
            if (value[n] == 0) continue;
            return true;
        }
        return false;
    }

    public static boolean decrement(byte[] value, int start, int end) {
        while (--end >= start) {
            int n = end;
            value[n] = (byte)(value[n] - 1);
            if (value[n] == -1) continue;
            return true;
        }
        return false;
    }

    public static final void encodeShortBE(byte[] b, int offset, int v) {
        b[offset] = (byte)(v >> 8);
        b[offset + 1] = (byte)v;
    }

    public static final void encodeShortLE(byte[] b, int offset, int v) {
        b[offset] = (byte)v;
        b[offset + 1] = (byte)(v >> 8);
    }

    public static final void encodeIntBE(byte[] b, int offset, int v) {
        b[offset] = (byte)(v >> 24);
        b[offset + 1] = (byte)(v >> 16);
        b[offset + 2] = (byte)(v >> 8);
        b[offset + 3] = (byte)v;
    }

    public static final void encodeIntLE(byte[] b, int offset, int v) {
        b[offset] = (byte)v;
        b[offset + 1] = (byte)(v >> 8);
        b[offset + 2] = (byte)(v >> 16);
        b[offset + 3] = (byte)(v >> 24);
    }

    public static final void encodeInt48BE(byte[] b, int offset, long v) {
        int w = (int)(v >> 32);
        b[offset] = (byte)(w >> 8);
        b[offset + 1] = (byte)w;
        w = (int)v;
        b[offset + 2] = (byte)(w >> 24);
        b[offset + 3] = (byte)(w >> 16);
        b[offset + 4] = (byte)(w >> 8);
        b[offset + 5] = (byte)w;
    }

    public static final void encodeInt48LE(byte[] b, int offset, long v) {
        int w = (int)v;
        b[offset] = (byte)w;
        b[offset + 1] = (byte)(w >> 8);
        b[offset + 2] = (byte)(w >> 16);
        b[offset + 3] = (byte)(w >> 24);
        w = (int)(v >> 32);
        b[offset + 4] = (byte)w;
        b[offset + 5] = (byte)(w >> 8);
    }

    public static final void encodeLongBE(byte[] b, int offset, long v) {
        int w = (int)(v >> 32);
        b[offset] = (byte)(w >> 24);
        b[offset + 1] = (byte)(w >> 16);
        b[offset + 2] = (byte)(w >> 8);
        b[offset + 3] = (byte)w;
        w = (int)v;
        b[offset + 4] = (byte)(w >> 24);
        b[offset + 5] = (byte)(w >> 16);
        b[offset + 6] = (byte)(w >> 8);
        b[offset + 7] = (byte)w;
    }

    public static final void encodeLongLE(byte[] b, int offset, long v) {
        int w = (int)v;
        b[offset] = (byte)w;
        b[offset + 1] = (byte)(w >> 8);
        b[offset + 2] = (byte)(w >> 16);
        b[offset + 3] = (byte)(w >> 24);
        w = (int)(v >> 32);
        b[offset + 4] = (byte)w;
        b[offset + 5] = (byte)(w >> 8);
        b[offset + 6] = (byte)(w >> 16);
        b[offset + 7] = (byte)(w >> 24);
    }

    public static final int decodeUnsignedShortBE(byte[] b, int offset) {
        return (b[offset] & 0xFF) << 8 | b[offset + 1] & 0xFF;
    }

    public static final int decodeUnsignedShortLE(byte[] b, int offset) {
        return b[offset] & 0xFF | (b[offset + 1] & 0xFF) << 8;
    }

    public static final int decodeIntBE(byte[] b, int offset) {
        return b[offset] << 24 | (b[offset + 1] & 0xFF) << 16 | (b[offset + 2] & 0xFF) << 8 | b[offset + 3] & 0xFF;
    }

    public static final int decodeIntLE(byte[] b, int offset) {
        return b[offset] & 0xFF | (b[offset + 1] & 0xFF) << 8 | (b[offset + 2] & 0xFF) << 16 | b[offset + 3] << 24;
    }

    public static final long decodeUnsignedInt48BE(byte[] b, int offset) {
        return (long)((b[offset] & 0xFF) << 8 | b[offset + 1] & 0xFF) << 32 | (long)(b[offset + 2] << 24 | (b[offset + 3] & 0xFF) << 16 | (b[offset + 4] & 0xFF) << 8 | b[offset + 5] & 0xFF) & 0xFFFFFFFFL;
    }

    public static final long decodeUnsignedInt48LE(byte[] b, int offset) {
        return (long)(b[offset] & 0xFF | (b[offset + 1] & 0xFF) << 8 | (b[offset + 2] & 0xFF) << 16 | b[offset + 3] << 24) & 0xFFFFFFFFL | (long)(b[offset + 4] & 0xFF | (b[offset + 5] & 0xFF) << 8) << 32;
    }

    public static final long decodeLongBE(byte[] b, int offset) {
        return (long)(b[offset] << 24 | (b[offset + 1] & 0xFF) << 16 | (b[offset + 2] & 0xFF) << 8 | b[offset + 3] & 0xFF) << 32 | (long)(b[offset + 4] << 24 | (b[offset + 5] & 0xFF) << 16 | (b[offset + 6] & 0xFF) << 8 | b[offset + 7] & 0xFF) & 0xFFFFFFFFL;
    }

    public static final long decodeLongLE(byte[] b, int offset) {
        return (long)(b[offset] & 0xFF | (b[offset + 1] & 0xFF) << 8 | (b[offset + 2] & 0xFF) << 16 | b[offset + 3] << 24) & 0xFFFFFFFFL | (long)(b[offset + 4] & 0xFF | (b[offset + 5] & 0xFF) << 8 | (b[offset + 6] & 0xFF) << 16 | b[offset + 7] << 24) << 32;
    }

    public static void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        if (len > 0) {
            while (true) {
                int amt;
                if ((amt = in.read(b, off, len)) <= 0) {
                    throw new EOFException();
                }
                if ((len -= amt) <= 0) break;
                off += amt;
            }
        }
    }

    public static boolean delete(Buffer bb) {
        if (!cDeleteUnsupported) {
            try {
                Method m = bb.getClass().getMethod("cleaner", new Class[0]);
                if (m != null) {
                    m.setAccessible(true);
                    Object cleaner = m.invoke((Object)bb, new Object[0]);
                    if (cleaner != null && (m = cleaner.getClass().getMethod("clean", new Class[0])) != null) {
                        m.setAccessible(true);
                        m.invoke(cleaner, new Object[0]);
                        return true;
                    }
                }
            }
            catch (Exception e) {
                cDeleteUnsupported = true;
            }
        }
        return false;
    }

    static synchronized void unregister(Closeable resource) {
        if (cCloseThreads != null) {
            cCloseThreads.remove(resource);
            if (cCloseThreads.isEmpty()) {
                cCloseThreads = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static IOException closeOnFailure(Closeable resource, Throwable cause) throws IOException {
        try {
            var4_2 = Utils.class;
            synchronized (Utils.class) {
                if (Utils.cCloseThreads == null) {
                    Utils.cCloseThreads = new HashMap<Closeable, Thread>(4);
                } else {
                    closer = Utils.cCloseThreads.get(resource);
                    if (closer != null) {
                        joinMillis = 0;
                        // ** MonitorExit[var4_2] (shouldn't be in output)
                        ** break block21
                    }
                }
                closer = new Thread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$closeOnFailure$0(java.io.Closeable java.lang.Throwable ), ()V)((Closeable)resource, (Throwable)cause));
                Utils.cCloseThreads.put(resource, closer);
                // ** MonitorExit[var4_2] (shouldn't be in output)
                closer.setDaemon(true);
                closer.start();
                joinMillis = 1000;
            }
        }
        catch (Throwable e2) {
            closer = null;
            joinMillis = 0;
        }
lbl-1000:
        // 3 sources

        {
            if (closer == null) {
                try {
                    Utils.close(resource, cause);
                }
                catch (IOException var4_4) {
                }
                finally {
                    Utils.unregister(resource);
                }
            } else if (joinMillis > 0) {
                try {
                    closer.join(joinMillis);
                }
                catch (InterruptedException var4_5) {
                    // empty catch block
                }
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new CorruptDatabaseException(cause);
        }
    }

    public static IOException closeQuietly(IOException first, Closeable resource) {
        block3: {
            if (resource != null) {
                try {
                    resource.close();
                }
                catch (IOException e) {
                    if (first != null) break block3;
                    return e;
                }
            }
        }
        return first;
    }

    public static IOException closeQuietly(IOException first, Closeable resource, Throwable cause) {
        block3: {
            if (resource != null) {
                try {
                    Utils.close(resource, cause);
                }
                catch (IOException e) {
                    if (first != null) break block3;
                    return e;
                }
            }
        }
        return first;
    }

    public static void close(Closeable resource, Throwable cause) throws IOException {
        if (resource instanceof CauseCloseable) {
            ((CauseCloseable)resource).close(cause);
        } else {
            resource.close();
        }
    }

    public static Throwable rootCause(Throwable e) {
        Throwable cause;
        while ((cause = e.getCause()) != null) {
            e = cause;
        }
        return e;
    }

    public static void uncaught(Throwable e) {
        Thread t = Thread.currentThread();
        t.getUncaughtExceptionHandler().uncaughtException(t, e);
    }

    public static RuntimeException rethrow(Throwable e) {
        Utils.castAndThrow(e);
        return null;
    }

    public static RuntimeException rethrow(Throwable e, Throwable cause) {
        if (cause != null && e != cause && e.getCause() == null) {
            try {
                e.initCause(Utils.rootCause(cause));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Utils.castAndThrow(e);
        return null;
    }

    private static <T extends Throwable> void castAndThrow(Throwable e) throws T {
        throw e;
    }

    private static /* synthetic */ void lambda$closeOnFailure$0(Closeable resource, Throwable cause) {
        try {
            Utils.close(resource, cause);
        }
        catch (IOException iOException) {
        }
        finally {
            Utils.unregister(resource);
        }
    }
}

