/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import java.io.IOException;
import org.cojen.tupl.io.CauseCloseable;

public abstract class PageArray
implements CauseCloseable {
    final int mPageSize;

    protected PageArray(int pageSize) {
        if (pageSize < 1) {
            throw new IllegalArgumentException("Page size must be at least 1: " + pageSize);
        }
        this.mPageSize = pageSize;
    }

    public final int pageSize() {
        return this.mPageSize;
    }

    public abstract boolean isReadOnly();

    public abstract boolean isEmpty() throws IOException;

    public abstract long getPageCount() throws IOException;

    public abstract void setPageCount(long var1) throws IOException;

    public long getPageCountLimit() throws IOException {
        return -1L;
    }

    public void readPage(long index, byte[] dst) throws IOException {
        this.readPage(index, dst, 0, this.mPageSize);
    }

    public abstract void readPage(long var1, byte[] var3, int var4, int var5) throws IOException;

    public void readPage(long index, long dstPtr) throws IOException {
        this.readPage(index, dstPtr, 0, this.mPageSize);
    }

    public void readPage(long index, long dstPtr, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writePage(long index, byte[] src) throws IOException {
        this.writePage(index, src, 0);
    }

    public abstract void writePage(long var1, byte[] var3, int var4) throws IOException;

    public void writePage(long index, long srcPtr) throws IOException {
        this.writePage(index, srcPtr, 0);
    }

    public void writePage(long index, long srcPtr, int offset) throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte[] evictPage(long index, byte[] buf) throws IOException {
        this.writePage(index, buf);
        return buf;
    }

    public long evictPage(long index, long bufPtr) throws IOException {
        this.writePage(index, bufPtr);
        return bufPtr;
    }

    public void cachePage(long index, byte[] src) throws IOException {
        this.cachePage(index, src, 0);
    }

    public void cachePage(long index, byte[] src, int offset) throws IOException {
    }

    public void cachePage(long index, long srcPtr) throws IOException {
        this.cachePage(index, srcPtr, 0);
    }

    public void cachePage(long index, long srcPtr, int offset) throws IOException {
    }

    public void uncachePage(long index) throws IOException {
    }

    public long directPagePointer(long index) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long copyPage(long srcIndex, long dstIndex) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long copyPageFromPointer(long srcPointer, long dstIndex) throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract void sync(boolean var1) throws IOException;

    public void syncPage(long index) throws IOException {
        this.sync(false);
    }

    @Override
    public void close() throws IOException {
        this.close(null);
    }

    @Override
    public abstract void close(Throwable var1) throws IOException;

    public PageArray open() throws IOException {
        return this;
    }
}

