/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.cojen.tupl.DatabaseFullException;
import org.cojen.tupl.io.DirectAccess;
import org.cojen.tupl.io.OpenOption;
import org.cojen.tupl.io.PageArray;
import org.cojen.tupl.io.PosixMappedPageArray;
import org.cojen.tupl.io.WindowsMappedPageArray;

public abstract class MappedPageArray
extends PageArray {
    private static AtomicLongFieldUpdater<MappedPageArray> cMappingPtrUpdater = AtomicLongFieldUpdater.newUpdater(MappedPageArray.class, "mMappingPtr");
    private static AtomicReferenceFieldUpdater<MappedPageArray, Throwable> cCauseUpdater = AtomicReferenceFieldUpdater.newUpdater(MappedPageArray.class, Throwable.class, "mCause");
    private final long mPageCount;
    private final boolean mReadOnly;
    private volatile long mMappingPtr;
    private volatile Throwable mCause;

    public static MappedPageArray open(int pageSize, long pageCount, File file, EnumSet<OpenOption> options) throws IOException {
        if (pageSize < 1 || pageCount < 0L || pageCount > Long.MAX_VALUE / (long)pageSize) {
            throw new IllegalArgumentException();
        }
        if (options == null) {
            options = EnumSet.noneOf(OpenOption.class);
        }
        if (Platform.isWindows()) {
            return new WindowsMappedPageArray(pageSize, pageCount, file, options);
        }
        return new PosixMappedPageArray(pageSize, pageCount, file, options);
    }

    MappedPageArray(int pageSize, long pageCount, EnumSet<OpenOption> options) {
        super(pageSize);
        this.mPageCount = pageCount;
        this.mReadOnly = options.contains((Object)OpenOption.READ_ONLY);
    }

    @Override
    public final boolean isReadOnly() {
        return this.mReadOnly;
    }

    @Override
    public boolean isEmpty() {
        return this.getPageCount() == 0L;
    }

    @Override
    public long getPageCount() {
        return this.mPageCount;
    }

    @Override
    public void setPageCount(long count) {
    }

    @Override
    public long getPageCountLimit() {
        return this.mPageCount;
    }

    @Override
    public void readPage(long index, byte[] buf, int offset, int length) throws IOException {
        this.readCheck(index);
        DirectAccess.ref(this.mappingPtr() + index * (long)this.mPageSize, length).get(buf, offset, length);
    }

    @Override
    public void readPage(long index, long ptr, int offset, int length) throws IOException {
        this.readCheck(index);
        int pageSize = this.mPageSize;
        long srcPtr = this.mappingPtr() + index * (long)pageSize;
        if (srcPtr != (ptr += (long)offset)) {
            ByteBuffer src = DirectAccess.ref(srcPtr, length);
            ByteBuffer dst = DirectAccess.ref2(ptr, length);
            dst.put(src);
        }
    }

    @Override
    public void writePage(long index, byte[] buf, int offset) throws IOException {
        this.writeCheck(index);
        int pageSize = this.mPageSize;
        DirectAccess.ref(this.mappingPtr() + index * (long)pageSize, pageSize).put(buf, offset, pageSize);
    }

    @Override
    public void writePage(long index, long ptr, int offset) throws IOException {
        this.writeCheck(index);
        int pageSize = this.mPageSize;
        long dstPtr = this.mappingPtr() + index * (long)pageSize;
        if (dstPtr != (ptr += (long)offset)) {
            ByteBuffer dst = DirectAccess.ref(dstPtr, pageSize);
            ByteBuffer src = DirectAccess.ref2(ptr, pageSize);
            dst.put(src);
        }
    }

    @Override
    public long directPagePointer(long index) throws IOException {
        this.readCheck(index);
        return this.mappingPtr() + index * (long)this.mPageSize;
    }

    @Override
    public long copyPage(long srcIndex, long dstIndex) throws IOException {
        this.readCheck(srcIndex);
        this.writeCheck(dstIndex);
        int pageSize = this.mPageSize;
        long ptr = this.mappingPtr();
        long dstPtr = ptr + dstIndex * (long)pageSize;
        ByteBuffer dst = DirectAccess.ref(dstPtr, pageSize);
        ByteBuffer src = DirectAccess.ref2(ptr + srcIndex * (long)pageSize, pageSize);
        dst.put(src);
        return dstPtr;
    }

    @Override
    public long copyPageFromPointer(long srcPointer, long dstIndex) throws IOException {
        this.writeCheck(dstIndex);
        int pageSize = this.mPageSize;
        long dstPtr = this.mappingPtr() + dstIndex * (long)pageSize;
        ByteBuffer dst = DirectAccess.ref(dstPtr, pageSize);
        ByteBuffer src = DirectAccess.ref2(srcPointer, pageSize);
        dst.put(src);
        return dstPtr;
    }

    @Override
    public void sync(boolean metadata) throws IOException {
        this.doSync(this.mappingPtr(), metadata);
    }

    @Override
    public void syncPage(long index) throws IOException {
        this.writeCheck(index);
        this.doSyncPage(this.mappingPtr(), index);
    }

    @Override
    public final void close(Throwable cause) throws IOException {
        long ptr;
        do {
            if ((ptr = this.mMappingPtr) == 0L) {
                return;
            }
            cCauseUpdater.compareAndSet(this, null, cause);
        } while (!cMappingPtrUpdater.compareAndSet(this, ptr, 0L));
        this.mCause = cause;
        this.doClose(ptr);
    }

    @Override
    public MappedPageArray open() throws IOException {
        return this.mMappingPtr == 0L ? this.doOpen() : this;
    }

    void setMappingPtr(long ptr) throws IOException {
        while (!cMappingPtrUpdater.compareAndSet(this, 0L, ptr)) {
            if (this.mMappingPtr == 0L) continue;
            throw new IllegalStateException();
        }
    }

    abstract MappedPageArray doOpen() throws IOException;

    abstract void doSync(long var1, boolean var3) throws IOException;

    abstract void doSyncPage(long var1, long var3) throws IOException;

    abstract void doClose(long var1) throws IOException;

    long mappingPtr() throws IOException {
        long mappingPtr = this.mMappingPtr;
        if (mappingPtr == 0L) {
            ClosedChannelException cce = new ClosedChannelException();
            cce.initCause(this.mCause);
            throw cce;
        }
        return mappingPtr;
    }

    private void readCheck(long index) throws IOException {
        if (index < 0L) {
            throw new IOException("Negative page index: " + index);
        }
        if (index >= this.mPageCount) {
            throw new IOException("Page index too high: " + index + " > " + this.mPageCount);
        }
    }

    private void writeCheck(long index) throws IOException {
        if (index < 0L) {
            throw new IOException("Negative page index: " + index);
        }
        if (index >= this.mPageCount) {
            throw new DatabaseFullException("Mapped file length limit reached: " + this.mPageCount * (long)this.mPageSize);
        }
    }
}

