/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.EnumSet;
import org.cojen.tupl.io.AbstractFileIO;
import org.cojen.tupl.io.DirectAccess;
import org.cojen.tupl.io.Mapping;
import org.cojen.tupl.io.OpenOption;
import org.cojen.tupl.io.Utils;

final class JavaFileIO
extends AbstractFileIO {
    private final File mFile;
    private final String mMode;
    private final FileAccess[] mFilePool;
    private int mFilePoolTop;

    JavaFileIO(File file, EnumSet<OpenOption> options, int openFileCount) throws IOException {
        this(file, options, openFileCount, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JavaFileIO(File file, EnumSet<OpenOption> options, int openFileCount, boolean allowMap) throws IOException {
        super(options);
        String mode;
        if (options.contains((Object)OpenOption.NON_DURABLE)) {
            throw new UnsupportedOperationException("Unsupported options: " + options);
        }
        this.mFile = file;
        if (this.isReadOnly()) {
            mode = "r";
        } else {
            if (!options.contains((Object)OpenOption.CREATE) && !file.exists()) {
                throw new FileNotFoundException(file.getPath());
            }
            mode = options.contains((Object)OpenOption.SYNC_IO) ? "rwd" : "rw";
        }
        this.mMode = mode;
        if (openFileCount < 1) {
            openFileCount = 1;
        }
        this.mFilePool = new FileAccess[openFileCount];
        try {
            FileAccess[] fileAccessArray = this.mFilePool;
            synchronized (this.mFilePool) {
                for (int i = 0; i < openFileCount; ++i) {
                    this.mFilePool[i] = JavaFileIO.openRaf(file, mode);
                }
                // ** MonitorExit[var6_6] (shouldn't be in output)
            }
        }
        catch (Throwable e) {
            throw Utils.closeOnFailure(this, e);
        }
        {
            if (allowMap && options.contains((Object)OpenOption.MAPPED)) {
                this.map();
            }
            if (options.contains((Object)OpenOption.CREATE)) {
                JavaFileIO.dirSync(file);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long doLength() throws IOException {
        RandomAccessFile file = this.accessFile();
        try {
            long l = file.length();
            return l;
        }
        finally {
            this.yieldFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSetLength(long length) throws IOException {
        RandomAccessFile file = this.accessFile();
        try {
            file.setLength(length);
        }
        finally {
            this.yieldFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRead(long pos, byte[] buf, int offset, int length) throws IOException {
        try {
            RandomAccessFile file = this.accessFile();
            try {
                file.seek(pos);
                file.readFully(buf, offset, length);
            }
            finally {
                this.yieldFile(file);
            }
        }
        catch (EOFException e) {
            throw new EOFException("Attempt to read past end of file: " + pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRead(long pos, long ptr, int length) throws IOException {
        RandomAccessFile file = this.accessFile();
        try {
            ByteBuffer bb = DirectAccess.ref(ptr, length);
            try {
                FileChannel channel = file.getChannel();
                while (true) {
                    int amt;
                    if ((amt = channel.read(bb, pos)) < 0) {
                        throw new EOFException("Attempt to read past end of file: " + pos);
                    }
                    if ((length -= amt) <= 0) {
                        break;
                    }
                    pos += (long)amt;
                }
            }
            finally {
                DirectAccess.unref(bb);
            }
        }
        finally {
            this.yieldFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWrite(long pos, byte[] buf, int offset, int length) throws IOException {
        RandomAccessFile file = this.accessFile();
        try {
            file.seek(pos);
            file.write(buf, offset, length);
        }
        finally {
            this.yieldFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWrite(long pos, long ptr, int length) throws IOException {
        RandomAccessFile file = this.accessFile();
        try {
            ByteBuffer bb = DirectAccess.ref(ptr, length);
            try {
                int amt;
                FileChannel channel = file.getChannel();
                while ((length -= (amt = channel.write(bb, pos))) > 0) {
                    pos += (long)amt;
                }
            }
            finally {
                DirectAccess.unref(bb);
            }
        }
        finally {
            this.yieldFile(file);
        }
    }

    @Override
    protected Mapping openMapping(boolean readOnly, long pos, int size) throws IOException {
        return Mapping.open(this.mFile, readOnly, pos, size);
    }

    @Override
    protected void reopen() throws IOException {
        int i;
        IOException ex = null;
        for (i = 0; i < this.mFilePool.length; ++i) {
            try {
                this.accessFile().close();
                continue;
            }
            catch (IOException e) {
                if (ex != null) continue;
                ex = e;
            }
        }
        for (i = 0; i < this.mFilePool.length; ++i) {
            try {
                this.yieldFile(JavaFileIO.openRaf(this.mFile, this.mMode));
                continue;
            }
            catch (IOException e) {
                if (ex != null) continue;
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    @Override
    protected void doSync(boolean metadata) throws IOException {
        RandomAccessFile file = this.accessFile();
        try {
            file.getChannel().force(metadata);
        }
        finally {
            this.yieldFile(file);
        }
    }

    @Override
    public void close() throws IOException {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Throwable cause) throws IOException {
        FileAccess[] pool;
        if (cause != null && this.mCause == null) {
            this.mCause = cause;
        }
        IOException ex = null;
        try {
            this.unmap(false);
        }
        catch (IOException e) {
            ex = e;
        }
        FileAccess[] fileAccessArray = pool = this.mFilePool;
        synchronized (pool) {
            for (FileAccess file : pool) {
                ex = Utils.closeQuietly(ex, file, cause);
            }
            // ** MonitorExit[var4_5] (shouldn't be in output)
            if (ex != null) {
                throw ex;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccessFile accessFile() throws InterruptedIOException {
        FileAccess[] pool;
        FileAccess[] fileAccessArray = pool = this.mFilePool;
        synchronized (pool) {
            int top;
            while ((top = this.mFilePoolTop) == pool.length) {
                try {
                    pool.wait();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
            FileAccess file = pool[top];
            this.mFilePoolTop = top + 1;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void yieldFile(RandomAccessFile file) {
        FileAccess[] pool;
        FileAccess[] fileAccessArray = pool = this.mFilePool;
        synchronized (pool) {
            pool[--this.mFilePoolTop] = file;
            pool.notify();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    static FileAccess openRaf(File file, String mode) throws IOException {
        try {
            return new FileAccess(file, mode);
        }
        catch (FileNotFoundException e) {
            String message = null;
            if (file.isDirectory()) {
                message = "File is a directory";
            } else if (!file.isFile()) {
                message = "Not a normal file";
            } else if ("r".equals(mode)) {
                if (!file.exists()) {
                    message = "File does not exist";
                } else if (!file.canRead()) {
                    message = "File cannot be read";
                }
            } else if (!file.canRead()) {
                message = !file.canWrite() ? "File cannot be read or written" : "File cannot be read";
            } else if (!file.canWrite()) {
                message = "File cannot be written";
            }
            if (message == null) {
                throw e;
            }
            String path = file.getPath();
            String originalMessage = e.getMessage();
            message = originalMessage.indexOf(path) < 0 ? message + ": " + file.getPath() + ' ' + originalMessage : message + ": " + originalMessage;
            throw new FileNotFoundException(message);
        }
    }

    static class FileAccess
    extends RandomAccessFile {
        private long mPosition;

        FileAccess(File file, String mode) throws IOException {
            super(file, mode);
            this.seek(0L);
        }

        @Override
        public void seek(long pos) throws IOException {
            if (pos != this.mPosition) {
                super.seek(pos);
                this.mPosition = pos;
            }
        }

        @Override
        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        @Override
        public int read(byte[] buf, int offset, int length) throws IOException {
            int amt = super.read(buf, offset, length);
            if (amt > 0) {
                this.mPosition += (long)amt;
            }
            return amt;
        }

        @Override
        public void write(byte[] buf) throws IOException {
            this.write(buf, 0, buf.length);
        }

        @Override
        public void write(byte[] buf, int offset, int length) throws IOException {
            super.write(buf, offset, length);
            this.mPosition += (long)length;
        }
    }
}

