/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.cojen.tupl.io.DirectAccess;
import org.cojen.tupl.io.FileIO;
import org.cojen.tupl.io.Mapping;
import org.cojen.tupl.io.OpenOption;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.util.Latch;

abstract class AbstractFileIO
extends FileIO {
    private static final int MAPPING_SHIFT = 30;
    private static final int MAPPING_SIZE = 0x40000000;
    private static final long SYNC_YIELD_THRESHOLD_NANOS = 10000000000L;
    private static final AtomicIntegerFieldUpdater<AbstractFileIO> cSyncCountUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractFileIO.class, "mSyncCount");
    private final boolean mReadOnly;
    private final Latch mRemapLatch;
    private final Latch mMappingLatch;
    private Mapping[] mMappings;
    private int mLastMappingSize;
    private final Latch mSyncLatch;
    private volatile int mSyncCount;
    private volatile long mSyncStartNanos;
    protected volatile Throwable mCause;

    AbstractFileIO(EnumSet<OpenOption> options) {
        this.mReadOnly = options.contains((Object)OpenOption.READ_ONLY);
        this.mRemapLatch = new Latch();
        this.mMappingLatch = new Latch();
        this.mSyncLatch = new Latch();
    }

    @Override
    public final boolean isReadOnly() {
        return this.mReadOnly;
    }

    @Override
    public final long length() throws IOException {
        this.mMappingLatch.acquireShared();
        try {
            long l = this.doLength();
            return l;
        }
        catch (IOException e) {
            throw Utils.rethrow(e, this.mCause);
        }
        finally {
            this.mMappingLatch.releaseShared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void setLength(long length) throws IOException {
        this.mRemapLatch.acquireExclusive();
        try {
            boolean remap;
            boolean bl = remap = this.mMappings != null && length < this.length();
            if (remap) {
                this.doUnmap(true);
            }
            try {
                this.doSetLength(length);
                if (!remap) return;
            }
            catch (IOException iOException) {
                if (!remap) return;
                this.doMap(true);
                return;
                catch (Throwable throwable) {
                    if (!remap) throw throwable;
                    this.doMap(true);
                    throw throwable;
                }
            }
            this.doMap(true);
            return;
        }
        finally {
            this.mRemapLatch.releaseExclusive();
        }
    }

    @Override
    public final void read(long pos, byte[] buf, int offset, int length) throws IOException {
        this.access(true, pos, buf, offset, length);
    }

    @Override
    public final void read(long pos, long ptr, int offset, int length) throws IOException {
        this.access(true, pos, ptr + (long)offset, length);
    }

    @Override
    public final void write(long pos, byte[] buf, int offset, int length) throws IOException {
        this.access(false, pos, buf, offset, length);
    }

    @Override
    public final void write(long pos, long ptr, int offset, int length) throws IOException {
        this.access(false, pos, ptr + (long)offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void access(boolean read, long pos, byte[] buf, int offset, int length) throws IOException {
        this.syncWait();
        try {
            block17: {
                this.mMappingLatch.acquireShared();
                try {
                    int mlen;
                    int mi;
                    Mapping[] mappings = this.mMappings;
                    if (mappings == null) break block17;
                    while ((mi = (int)(pos >> 30)) < (mlen = mappings.length)) {
                        int mavail;
                        Mapping mapping = mappings[mi];
                        int mpos = (int)(pos & 0x3FFFFFFFL);
                        if (mi == mlen - 1) {
                            mavail = this.mLastMappingSize - mpos;
                            if (mavail <= 0) {
                                break;
                            }
                        } else {
                            mavail = 0x40000000 - mpos;
                        }
                        if (mavail > length) {
                            mavail = length;
                        }
                        if (read) {
                            mapping.read(mpos, buf, offset, mavail);
                        } else {
                            mapping.write(mpos, buf, offset, mavail);
                        }
                        if ((length -= mavail) <= 0) {
                            return;
                        }
                        pos += (long)mavail;
                        offset += mavail;
                    }
                }
                finally {
                    this.mMappingLatch.releaseShared();
                }
            }
            if (read) {
                this.doRead(pos, buf, offset, length);
            } else {
                this.doWrite(pos, buf, offset, length);
            }
        }
        catch (IOException e) {
            throw Utils.rethrow(e, this.mCause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void access(boolean read, long pos, long ptr, int length) throws IOException {
        if (length <= 0) {
            return;
        }
        this.syncWait();
        try {
            block22: {
                this.mMappingLatch.acquireShared();
                try {
                    Mapping[] mappings = this.mMappings;
                    if (mappings == null) break block22;
                    ByteBuffer bb = null;
                    while (true) {
                        int mavail;
                        block23: {
                            block24: {
                                int mi = (int)(pos >> 30);
                                int mlen = mappings.length;
                                if (mi >= mlen) break;
                                Mapping mapping = mappings[mi];
                                int mpos = (int)(pos & 0x3FFFFFFFL);
                                if (mi == mlen - 1) {
                                    mavail = this.mLastMappingSize - mpos;
                                    if (mavail <= 0) {
                                        break;
                                    }
                                } else {
                                    mavail = 0x40000000 - mpos;
                                }
                                if (mavail > length) {
                                    mavail = length;
                                }
                                if (bb == null) {
                                    bb = DirectAccess.ref(ptr, length);
                                }
                                if (read) {
                                    mapping.read(mpos, bb);
                                } else {
                                    mapping.write(mpos, bb);
                                }
                                if (bb.hasRemaining()) break block23;
                                if (bb == null) break block24;
                                DirectAccess.unref(bb);
                            }
                            return;
                        }
                        pos += (long)mavail;
                        continue;
                        break;
                    }
                    if (bb != null) {
                        DirectAccess.unref(bb);
                    }
                    break block22;
                    catch (Throwable throwable) {
                        if (bb != null) {
                            DirectAccess.unref(bb);
                        }
                        throw throwable;
                    }
                }
                finally {
                    this.mMappingLatch.releaseShared();
                }
            }
            if (read) {
                this.doRead(pos, ptr, length);
            } else {
                this.doWrite(pos, ptr, length);
            }
        }
        catch (IOException e) {
            throw Utils.rethrow(e, this.mCause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void sync(boolean metadata) throws IOException {
        if (this.mReadOnly) {
            return;
        }
        int count = cSyncCountUpdater.getAndIncrement(this);
        try {
            if (count == 0) {
                this.mSyncStartNanos = System.nanoTime();
            }
            this.mSyncLatch.acquireShared();
            try {
                this.mMappingLatch.acquireShared();
                try {
                    Mapping[] mappings = this.mMappings;
                    if (mappings != null) {
                        for (Mapping m : mappings) {
                            m.sync(false);
                        }
                    }
                }
                finally {
                    this.mMappingLatch.releaseShared();
                }
                this.doSync(metadata);
            }
            catch (IOException e) {
                throw Utils.rethrow(e, this.mCause);
            }
            finally {
                this.mSyncLatch.releaseShared();
            }
        }
        finally {
            cSyncCountUpdater.decrementAndGet(this);
        }
    }

    @Override
    public final void map() throws IOException {
        this.mRemapLatch.acquireExclusive();
        try {
            this.doMap(false);
        }
        finally {
            this.mRemapLatch.releaseExclusive();
        }
    }

    @Override
    public final void remap() throws IOException {
        this.mRemapLatch.acquireExclusive();
        try {
            this.doMap(true);
        }
        finally {
            this.mRemapLatch.releaseExclusive();
        }
    }

    @Override
    public final void unmap() throws IOException {
        this.unmap(true);
    }

    protected void unmap(boolean reopen) throws IOException {
        this.mRemapLatch.acquireExclusive();
        try {
            this.doUnmap(reopen);
        }
        finally {
            this.mRemapLatch.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUnmap(boolean reopen) throws IOException {
        this.mMappingLatch.acquireExclusive();
        try {
            IOException ex;
            block10: {
                Mapping[] mappings = this.mMappings;
                if (mappings == null) {
                    return;
                }
                this.mMappings = null;
                this.mLastMappingSize = 0;
                ex = null;
                for (Mapping m : mappings) {
                    ex = Utils.closeQuietly(ex, m);
                }
                if (reopen) {
                    try {
                        this.reopen();
                    }
                    catch (IOException e) {
                        if (ex != null) break block10;
                        ex = e;
                    }
                }
            }
            if (ex != null) {
                throw ex;
            }
        }
        finally {
            this.mMappingLatch.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMap(boolean remap) throws IOException {
        int newLastSize;
        int oldMappingDiscardPos;
        Mapping[] newMappings;
        Mapping[] oldMappings;
        this.mMappingLatch.acquireShared();
        try {
            long count;
            oldMappings = this.mMappings;
            if (oldMappings == null && remap) {
                return;
            }
            long length = this.length();
            if (oldMappings != null) {
                long oldMappedLength;
                long l = oldMappedLength = oldMappings.length == 0 ? 0L : (long)(oldMappings.length - 1) * 0x40000000L + (long)this.mLastMappingSize;
                if (length == oldMappedLength) {
                    return;
                }
            }
            if ((count = (length + 0x3FFFFFFFL) / 0x40000000L) > Integer.MAX_VALUE) {
                throw new IOException("Mapping is too large");
            }
            try {
                newMappings = new Mapping[(int)count];
            }
            catch (OutOfMemoryError e) {
                throw new IOException("Mapping is too large");
            }
            oldMappings = this.mMappings;
            oldMappingDiscardPos = 0;
            int i = 0;
            long pos = 0L;
            if (oldMappings != null && oldMappings.length > 0) {
                i = oldMappings.length;
                if (this.mLastMappingSize != 0x40000000) {
                    oldMappingDiscardPos = --i;
                }
                System.arraycopy(oldMappings, 0, newMappings, 0, i);
                pos = (long)i * 0x40000000L;
            }
            while ((long)i < count - 1L) {
                newMappings[i++] = this.openMapping(this.mReadOnly, pos, 0x40000000);
                pos += 0x40000000L;
            }
            if (count == 0L) {
                newLastSize = 0;
            } else {
                newLastSize = (int)(0x40000000L - (count * 0x40000000L - length));
                newMappings[i] = this.openMapping(this.mReadOnly, pos, newLastSize);
            }
        }
        finally {
            this.mMappingLatch.releaseShared();
        }
        this.mMappingLatch.acquireExclusive();
        this.mMappings = newMappings;
        this.mLastMappingSize = newLastSize;
        this.mMappingLatch.releaseExclusive();
        if (oldMappings != null) {
            IOException ex = null;
            while (oldMappingDiscardPos < oldMappings.length) {
                ex = Utils.closeQuietly(ex, oldMappings[oldMappingDiscardPos++]);
            }
            if (ex != null) {
                throw ex;
            }
        }
    }

    protected void syncWait() throws InterruptedIOException {
        long syncTimeNanos;
        if (this.mSyncCount != 0 && (syncTimeNanos = System.nanoTime() - this.mSyncStartNanos) > 10000000000L) {
            long sleepNanos = syncTimeNanos / 1000L;
            try {
                if (this.mSyncLatch.tryAcquireExclusiveNanos(sleepNanos)) {
                    this.mSyncLatch.releaseExclusive();
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }
    }

    protected abstract long doLength() throws IOException;

    protected abstract void doSetLength(long var1) throws IOException;

    protected abstract void doRead(long var1, byte[] var3, int var4, int var5) throws IOException;

    protected abstract void doRead(long var1, long var3, int var5) throws IOException;

    protected abstract void doWrite(long var1, byte[] var3, int var4, int var5) throws IOException;

    protected abstract void doWrite(long var1, long var3, int var5) throws IOException;

    protected abstract Mapping openMapping(boolean var1, long var2, int var4) throws IOException;

    protected abstract void reopen() throws IOException;

    protected abstract void doSync(boolean var1) throws IOException;
}

