/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.Index;
import org.cojen.tupl.LHashTable;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.RedoVisitor;
import org.cojen.tupl.Transaction;
import org.cojen.tupl._LocalDatabase;
import org.cojen.tupl._LocalTransaction;
import org.cojen.tupl.ext.TransactionHandler;

final class _RedoLogApplier
implements RedoVisitor {
    private final _LocalDatabase mDatabase;
    private final LHashTable.Obj<_LocalTransaction> mTransactions;
    private final LHashTable.Obj<Index> mIndexes;
    long mHighestTxnId;

    _RedoLogApplier(_LocalDatabase db, LHashTable.Obj<_LocalTransaction> txns) {
        this.mDatabase = db;
        this.mTransactions = txns;
        this.mIndexes = new LHashTable.Obj(16);
    }

    @Override
    public boolean timestamp(long timestamp) {
        return true;
    }

    @Override
    public boolean shutdown(long timestamp) {
        return true;
    }

    @Override
    public boolean close(long timestamp) {
        return true;
    }

    @Override
    public boolean endFile(long timestamp) {
        return true;
    }

    @Override
    public boolean reset() {
        return true;
    }

    @Override
    public boolean store(long indexId, byte[] key, byte[] value) throws IOException {
        return this.storeNoLock(indexId, key, value);
    }

    @Override
    public boolean storeNoLock(long indexId, byte[] key, byte[] value) throws IOException {
        Index ix = this.openIndex(indexId);
        if (ix != null) {
            ix.store(Transaction.BOGUS, key, value);
        }
        return true;
    }

    @Override
    public boolean renameIndex(long txnId, long indexId, byte[] newName) throws IOException {
        this.checkHighest(txnId);
        Index ix = this.openIndex(indexId);
        if (ix != null) {
            this.mDatabase.renameIndex(ix, newName, txnId);
        }
        return true;
    }

    @Override
    public boolean deleteIndex(long txnId, long indexId) throws IOException {
        this.checkHighest(txnId);
        return true;
    }

    @Override
    public boolean txnEnter(long txnId) throws IOException {
        _LocalTransaction txn = this.txn(txnId);
        if (txn == null) {
            txn = new _LocalTransaction(this.mDatabase, txnId, LockMode.UPGRADABLE_READ, 0L);
            ((LHashTable.ObjEntry)this.mTransactions.insert((long)txnId)).value = txn;
        } else {
            txn.enter();
        }
        return true;
    }

    @Override
    public boolean txnRollback(long txnId) throws IOException {
        _LocalTransaction txn = this.txn(txnId);
        if (txn != null) {
            txn.exit();
        }
        return true;
    }

    @Override
    public boolean txnRollbackFinal(long txnId) throws IOException {
        this.checkHighest(txnId);
        Transaction txn = this.mTransactions.removeValue(txnId);
        if (txn != null) {
            txn.reset();
        }
        return true;
    }

    @Override
    public boolean txnCommit(long txnId) throws IOException {
        _LocalTransaction txn = this.txn(txnId);
        if (txn != null) {
            txn.commit();
            txn.exit();
        }
        return true;
    }

    @Override
    public boolean txnCommitFinal(long txnId) throws IOException {
        this.checkHighest(txnId);
        _LocalTransaction txn = this.mTransactions.removeValue(txnId);
        if (txn != null) {
            txn.commitAll();
        }
        return true;
    }

    @Override
    public boolean txnStore(long txnId, long indexId, byte[] key, byte[] value) throws IOException {
        Index ix;
        _LocalTransaction txn = this.txn(txnId);
        if (txn != null && (ix = this.openIndex(indexId)) != null) {
            ix.store(txn, key, value);
        }
        return true;
    }

    @Override
    public boolean txnStoreCommitFinal(long txnId, long indexId, byte[] key, byte[] value) throws IOException {
        this.txnStore(txnId, indexId, key, value);
        return this.txnCommitFinal(txnId);
    }

    @Override
    public boolean txnCustom(long txnId, byte[] message) throws IOException {
        _LocalTransaction txn = this.txn(txnId);
        if (txn != null) {
            _LocalDatabase db = this.mDatabase;
            TransactionHandler handler = db.mCustomTxnHandler;
            if (handler == null) {
                throw new DatabaseException("Custom transaction handler is not installed");
            }
            handler.redo(db, txn, message);
        }
        return true;
    }

    @Override
    public boolean txnCustomLock(long txnId, byte[] message, long indexId, byte[] key) throws IOException {
        _LocalTransaction txn = this.txn(txnId);
        if (txn != null) {
            _LocalDatabase db = this.mDatabase;
            TransactionHandler handler = db.mCustomTxnHandler;
            if (handler == null) {
                throw new DatabaseException("Custom transaction handler is not installed");
            }
            txn.lockExclusive(indexId, key);
            handler.redo(db, txn, message, indexId, key);
        }
        return true;
    }

    private _LocalTransaction txn(long txnId) {
        this.checkHighest(txnId);
        return this.mTransactions.getValue(txnId);
    }

    private void checkHighest(long txnId) {
        if (txnId > this.mHighestTxnId) {
            this.mHighestTxnId = txnId;
        }
    }

    private Index openIndex(long indexId) throws IOException {
        LHashTable.ObjEntry entry = (LHashTable.ObjEntry)this.mIndexes.get(indexId);
        if (entry != null) {
            return (Index)entry.value;
        }
        Index ix = this.mDatabase.anyIndexById(indexId);
        if (ix != null) {
            ((LHashTable.ObjEntry)this.mIndexes.insert((long)indexId)).value = ix;
        }
        return ix;
    }
}

