/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import org.cojen.tupl.EventListener;
import org.cojen.tupl.EventType;
import org.cojen.tupl.Utils;
import org.cojen.tupl._LocalDatabase;
import org.cojen.tupl._PendingTxn;
import org.cojen.tupl._ReplRedoWriter;

final class _PendingTxnWaiter
extends Thread {
    private static final int TIMEOUT_MILLIS = 60000;
    static final int PENDING = 1;
    static final int DO_COMMIT = 2;
    static final int DO_ROLLBACK = 3;
    static final int EXITED = 4;
    private final _ReplRedoWriter mWriter;
    private _PendingTxn mBehind;
    private _PendingTxn mAhead;
    private long mFlipPos = -1L;
    private boolean mExited;

    _PendingTxnWaiter(_ReplRedoWriter writer) {
        this.mWriter = writer;
    }

    synchronized int add(_PendingTxn pending) {
        long flipPos = this.mFlipPos;
        if (flipPos >= 0L) {
            return pending.mCommitPos <= flipPos ? 2 : 3;
        }
        if (this.mExited) {
            return 4;
        }
        _PendingTxn behind = this.mBehind;
        if (behind == null) {
            this.mBehind = pending;
            this.notify();
        } else {
            long commitPos = pending.mCommitPos;
            if (commitPos <= behind.mCommitPos) {
                pending.mPrev = behind.mPrev;
                behind.mPrev = pending;
            } else {
                _PendingTxn ahead = this.mAhead;
                if (ahead != null && commitPos <= ahead.mCommitPos) {
                    pending.mPrev = ahead.mPrev;
                    ahead.mPrev = pending;
                } else {
                    pending.mPrev = ahead;
                    this.mAhead = pending;
                }
            }
        }
        return 1;
    }

    synchronized void flipped(long commitPos) {
        if (commitPos < 0L) {
            throw new IllegalArgumentException();
        }
        this.mFlipPos = commitPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishAll() {
        _PendingTxn ahead;
        _PendingTxn behind;
        long commitPos;
        _PendingTxnWaiter _PendingTxnWaiter2 = this;
        synchronized (_PendingTxnWaiter2) {
            commitPos = this.mFlipPos;
            if (commitPos < 0L) {
                throw new IllegalStateException();
            }
            behind = this.mBehind;
            this.mBehind = null;
            ahead = this.mAhead;
            this.mAhead = null;
            this.notify();
        }
        _LocalDatabase db = this.mWriter.mEngine.mDatabase;
        _PendingTxnWaiter.finishAll(behind, db, commitPos);
        _PendingTxnWaiter.finishAll(ahead, db, commitPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (Throwable e) {
            _PendingTxnWaiter _PendingTxnWaiter2 = this;
            synchronized (_PendingTxnWaiter2) {
                this.mExited = true;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() {
        while (true) {
            _PendingTxn behind;
            _PendingTxnWaiter _PendingTxnWaiter2 = this;
            synchronized (_PendingTxnWaiter2) {
                behind = this.mBehind;
                if (behind == null) {
                    try {
                        this.wait(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    behind = this.mBehind;
                    if (behind == null) {
                        this.mExited = true;
                        return;
                    }
                }
            }
            if (!this.mWriter.confirm(behind.mTxnId, behind.mCommitPos)) {
                return;
            }
            _PendingTxnWaiter2 = this;
            synchronized (_PendingTxnWaiter2) {
                if (this.mBehind == null) {
                    this.mExited = true;
                    return;
                }
                this.mBehind = this.mAhead;
                this.mAhead = null;
            }
            _LocalDatabase db = this.mWriter.mEngine.mDatabase;
            do {
                try {
                    behind.commit(db);
                }
                catch (IOException e) {
                    _PendingTxnWaiter.uncaught(db, e);
                }
            } while ((behind = behind.mPrev) != null);
        }
    }

    private static void finishAll(_PendingTxn pending, _LocalDatabase db, long commitPos) {
        while (pending != null) {
            try {
                if (pending.mCommitPos <= commitPos) {
                    pending.commit(db);
                } else {
                    pending.rollback(db);
                }
            }
            catch (IOException e) {
                _PendingTxnWaiter.uncaught(db, e);
            }
            pending = pending.mPrev;
        }
    }

    private static void uncaught(_LocalDatabase db, Throwable e) {
        EventListener listener = db.mEventListener;
        if (listener != null) {
            listener.notify(EventType.REPLICATION_PANIC, "Unexpected transaction exception: %1$s", e);
        } else {
            Utils.uncaught(e);
        }
    }
}

