/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import org.cojen.tupl.DirectPageOps;
import org.cojen.tupl.util.Latch;
import org.cojen.tupl.util.LatchCondition;

final class _PagePool
extends Latch {
    private final transient LatchCondition mQueue = new LatchCondition();
    private final long[] mPool;
    private int mPos;

    _PagePool(int pageSize, int poolSize) {
        long[] pool = DirectPageOps.p_allocArray(poolSize);
        for (int i = 0; i < poolSize; ++i) {
            pool[i] = DirectPageOps.p_calloc(pageSize);
        }
        this.mPool = pool;
        this.mPos = poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long remove() {
        this.acquireExclusive();
        try {
            int pos;
            while ((pos = this.mPos) == 0) {
                this.mQueue.await(this, -1L, 0L);
            }
            this.mPos = pos - 1;
            long l = this.mPool[this.mPos];
            return l;
        }
        finally {
            this.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(long page) {
        this.acquireExclusive();
        try {
            int pos = this.mPos;
            this.mPool[pos] = page;
            this.mPos = pos + 1;
            this.mQueue.signal();
        }
        finally {
            this.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete() {
        this.acquireExclusive();
        try {
            for (int i = 0; i < this.mPos; ++i) {
                long page = this.mPool[i];
                this.mPool[i] = DirectPageOps.p_null();
                DirectPageOps.p_delete(page);
            }
        }
        finally {
            this.releaseExclusive();
        }
    }
}

