/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.DatabaseFullException;
import org.cojen.tupl.DirectPageOps;
import org.cojen.tupl.PageCache;
import org.cojen.tupl.Utils;
import org.cojen.tupl._LocalDatabase;
import org.cojen.tupl._Node;
import org.cojen.tupl._PageDb;

final class _NonPageDb
extends _PageDb {
    private final int mPageSize;
    private final PageCache mCache;
    private long mAllocId;

    _NonPageDb(int pageSize, PageCache cache) {
        this.mPageSize = pageSize;
        this.mCache = cache;
        this.mAllocId = 1L;
    }

    @Override
    void delete() {
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    @Override
    public int allocMode() {
        return 2;
    }

    @Override
    public _Node allocLatchedNode(_LocalDatabase db, int mode) throws IOException {
        _Node node = db.allocLatchedNode(Utils.randomSeed(), mode);
        long nodeId = node.mId;
        nodeId = nodeId < 0L ? -nodeId : this.allocPage();
        node.mId = nodeId;
        return node;
    }

    @Override
    public int pageSize() {
        return this.mPageSize;
    }

    @Override
    public long pageCount() {
        return 0L;
    }

    @Override
    public void pageLimit(long limit) {
    }

    @Override
    public long pageLimit() {
        return -1L;
    }

    @Override
    public void pageLimitOverride(long limit) {
    }

    @Override
    public _PageDb.Stats stats() {
        return new _PageDb.Stats();
    }

    @Override
    public BitSet tracePages() throws IOException {
        return new BitSet();
    }

    @Override
    public void readPage(long id, long page) throws IOException {
        PageCache cache = this.mCache;
        if (cache == null || !cache.remove(id, page, 0, this.pageSize())) {
            _NonPageDb.fail(false);
        }
    }

    @Override
    public synchronized long allocPage() throws IOException {
        long id = this.mAllocId + 1L;
        if (id > 0xFFFFFFFFFFFFL) {
            throw new DatabaseFullException();
        }
        this.mAllocId = id;
        return id;
    }

    @Override
    public void writePage(long id, long page) throws IOException {
        PageCache cache = this.mCache;
        if (cache == null || !cache.add(id, page, 0, false)) {
            _NonPageDb.fail(true);
        }
    }

    @Override
    public long evictPage(long id, long page) throws IOException {
        this.writePage(id, page);
        return page;
    }

    @Override
    public void cachePage(long id, long page) throws IOException {
        PageCache cache = this.mCache;
        if (cache != null && !cache.add(id, page, 0, false)) {
            _NonPageDb.fail(false);
        }
    }

    @Override
    public void uncachePage(long id) throws IOException {
        PageCache cache = this.mCache;
        if (cache != null) {
            cache.remove(id, DirectPageOps.p_null(), 0, 0);
        }
    }

    @Override
    public void deletePage(long id) throws IOException {
        this.uncachePage(id);
    }

    @Override
    public void recyclePage(long id) throws IOException {
        this.uncachePage(id);
    }

    @Override
    public long allocatePages(long pageCount) throws IOException {
        return 0L;
    }

    @Override
    public boolean compactionStart(long targetPageCount) throws IOException {
        return false;
    }

    @Override
    public boolean compactionScanFreeList() throws IOException {
        return false;
    }

    @Override
    public boolean compactionVerify() throws IOException {
        return false;
    }

    @Override
    public boolean compactionEnd() throws IOException {
        return false;
    }

    @Override
    public boolean truncatePages() throws IOException {
        return false;
    }

    @Override
    public int extraCommitDataOffset() {
        return 0;
    }

    @Override
    public void commit(boolean resume, long header, _PageDb.CommitCallback callback) throws IOException {
        throw new DatabaseException("Cannot commit to a non-durable database");
    }

    @Override
    public void readExtraCommitData(byte[] extra) throws IOException {
        Arrays.fill(extra, (byte)0);
    }

    @Override
    public void close() {
        if (this.mCache != null) {
            this.mCache.close();
        }
    }

    @Override
    public void close(Throwable cause) {
        this.close();
    }

    private static void fail(boolean forWrite) throws DatabaseException {
        if (forWrite) {
            throw new DatabaseFullException();
        }
        throw new DatabaseException("Cannot read from a non-durable database");
    }
}

