/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.util.LinkedHashSet;
import java.util.Set;
import org.cojen.tupl.DeadlockSet;
import org.cojen.tupl._Lock;
import org.cojen.tupl._LockOwner;
import org.cojen.tupl._Locker;

final class _DeadlockDetector {
    private final _Locker mOrigin;
    private final Set<_LockOwner> mLockers;
    final Set<_Lock> mLocks;
    boolean mGuilty;

    _DeadlockDetector(_Locker locker) {
        this.mOrigin = locker;
        this.mLockers = new LinkedHashSet<_LockOwner>();
        this.mLocks = new LinkedHashSet<_Lock>();
    }

    DeadlockSet newDeadlockSet() {
        int size = this.mLocks.size();
        long[] indexIds = new long[size];
        byte[][] keys = new byte[size][];
        int i = 0;
        for (_Lock lock : this.mLocks) {
            indexIds[i] = lock.mIndexId;
            byte[] key = lock.mKey;
            if (key != null) {
                key = (byte[])key.clone();
            }
            keys[i] = key;
            ++i;
        }
        return new DeadlockSet(indexIds, keys);
    }

    boolean scan() {
        return this.scan(this.mOrigin);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean scan(_LockOwner locker) {
        boolean found = false;
        _Lock lock;
        block0: while ((lock = locker.mWaitingFor) != null) {
            this.mLocks.add(lock);
            if (this.mLockers.isEmpty()) {
                this.mLockers.add(locker);
            } else {
                this.mGuilty |= this.mOrigin == locker;
                if (!this.mLockers.add(locker)) {
                    return true;
                }
            }
            _LockOwner owner = lock.mOwner;
            Object shared = lock.mSharedLockOwnersObj;
            if (owner != null && owner != locker) {
                if (shared == null) {
                    locker = owner;
                    continue;
                }
                found |= this.scan(owner);
            }
            if (shared == null) return found;
            if (shared instanceof _Locker) {
                locker = (_Locker)shared;
                continue;
            }
            if (!(shared instanceof _Lock.LockOwnerHTEntry[])) {
                return found;
            }
            _Lock.LockOwnerHTEntry[] entries = (_Lock.LockOwnerHTEntry[])shared;
            int i = entries.length;
            block1: while (true) {
                if (--i < 0) return found;
                _Lock.LockOwnerHTEntry e = entries[i];
                while (true) {
                    if (e == null) continue block1;
                    _Lock.LockOwnerHTEntry next = e.mNext;
                    if (i == 0 && next == null) {
                        locker = e.mOwner;
                        continue block0;
                    }
                    found |= this.scan(e.mOwner);
                    e = next;
                }
                break;
            }
            break;
        }
        return found;
    }
}

