/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.cojen.tupl._Node;

final class _CursorFrame
extends AtomicReference<_CursorFrame> {
    private static final int SPIN_LIMIT = Runtime.getRuntime().availableProcessors();
    private static final _CursorFrame REBIND_FRAME = new _CursorFrame();
    static final AtomicReferenceFieldUpdater<_Node, _CursorFrame> cLastUpdater = AtomicReferenceFieldUpdater.newUpdater(_Node.class, _CursorFrame.class, "mLastCursorFrame");
    volatile _CursorFrame mPrevCousin;
    _Node mNode;
    int mNodePos;
    _CursorFrame mParentFrame;
    byte[] mNotFoundKey;

    _CursorFrame() {
    }

    _CursorFrame(_CursorFrame parentFrame) {
        this.mParentFrame = parentFrame;
    }

    _Node acquireShared() {
        _Node node = this.mNode;
        while (true) {
            node.acquireShared();
            _Node actualNode = this.mNode;
            if (actualNode == node) {
                return actualNode;
            }
            node.releaseShared();
            node = actualNode;
        }
    }

    _Node tryAcquireShared() {
        _Node node = this.mNode;
        while (node.tryAcquireShared()) {
            _Node actualNode = this.mNode;
            if (actualNode == node) {
                return actualNode;
            }
            node.releaseShared();
            node = actualNode;
        }
        return null;
    }

    _Node acquireExclusive() {
        _Node node = this.mNode;
        while (true) {
            node.acquireExclusive();
            _Node actualNode = this.mNode;
            if (actualNode == node) {
                return actualNode;
            }
            node.releaseExclusive();
            node = actualNode;
        }
    }

    _Node tryAcquireExclusive() {
        _Node node = this.mNode;
        while (node.tryAcquireExclusive()) {
            _Node actualNode = this.mNode;
            if (actualNode == node) {
                return actualNode;
            }
            node.releaseExclusive();
            node = actualNode;
        }
        return null;
    }

    void adjustParentPosition(int amount) {
        _CursorFrame parent = this.mParentFrame;
        if (parent != null) {
            parent.mNodePos += amount;
        }
    }

    void bind(_Node node, int nodePos) {
        this.mNode = node;
        this.mNodePos = nodePos;
        this.set(this);
        int trials = 0;
        while (true) {
            _CursorFrame last;
            this.mPrevCousin = last = node.mLastCursorFrame;
            if (last == null) {
                if (cLastUpdater.compareAndSet(node, null, this)) {
                    return;
                }
            } else if (last.get() == last && last.compareAndSet(last, this)) {
                while (node.mLastCursorFrame != last) {
                }
                node.mLastCursorFrame = this;
                return;
            }
            if (++trials < SPIN_LIMIT) continue;
            Thread.yield();
            trials = 0;
        }
    }

    void bindOrReposition(_Node node, int nodePos) {
        if (this.mNode == null) {
            this.bind(node, nodePos);
        } else if (this.mNode == node) {
            this.mNodePos = nodePos;
        } else {
            throw new IllegalStateException();
        }
    }

    void rebind(_Node node, int nodePos) {
        if (this.unbind(REBIND_FRAME)) {
            this.bind(node, nodePos);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean unbind(_CursorFrame to) {
        int trials = 0;
        _CursorFrame n;
        while ((n = (_CursorFrame)this.get()) != null) {
            if (n == this) {
                _Node node = this.mNode;
                if (node != null && node.mLastCursorFrame == this && this.compareAndSet(n, to)) {
                    if (node != this.mNode || node.mLastCursorFrame != this) {
                        this.set(n);
                    } else {
                        _CursorFrame p;
                        while (!((p = this.mPrevCousin) == null || p.get() == this && p.compareAndSet(this, p))) {
                        }
                        node.mLastCursorFrame = p;
                        return true;
                    }
                }
            } else if (n.mPrevCousin == this && this.compareAndSet(n, to)) {
                _CursorFrame p;
                while (!((p = this.mPrevCousin) == null || p.get() == this && p.compareAndSet(this, n))) {
                }
                n.mPrevCousin = p;
                return true;
            }
            if (++trials < SPIN_LIMIT) continue;
            Thread.yield();
            trials = 0;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    _CursorFrame tryLock(_CursorFrame lock) {
        int trials = 0;
        _CursorFrame n;
        while ((n = (_CursorFrame)this.get()) != null) {
            if (n == this) {
                _Node node = this.mNode;
                if (node != null && node.mLastCursorFrame == this && this.compareAndSet(n, lock)) {
                    if (node == this.mNode && node.mLastCursorFrame == this) return n;
                    this.set(n);
                }
            } else if (n.mPrevCousin == this && this.compareAndSet(n, lock)) {
                return n;
            }
            if (++trials < SPIN_LIMIT) continue;
            Thread.yield();
            trials = 0;
        }
        return null;
    }

    _CursorFrame tryLockPrevious(_CursorFrame lock) {
        _CursorFrame p;
        while (!((p = this.mPrevCousin) == null || p.get() == this && p.compareAndSet(this, lock))) {
        }
        return p;
    }

    void unlock(_CursorFrame n) {
        this.set(n);
    }

    _CursorFrame peek() {
        return this.mParentFrame;
    }

    _CursorFrame pop() {
        this.unbind(null);
        _CursorFrame parent = this.mParentFrame;
        this.mNode = null;
        this.mParentFrame = null;
        this.mNotFoundKey = null;
        return parent;
    }

    void popv() {
        this.unbind(null);
        this.mNode = null;
        this.mParentFrame = null;
        this.mNotFoundKey = null;
    }

    static void popAll(_CursorFrame frame) {
        while ((frame = frame.mNode == null ? frame.mParentFrame : frame.pop()) != null) {
        }
    }

    void copyInto(_CursorFrame dest) {
        _Node node = this.acquireShared();
        _CursorFrame parent = this.mParentFrame;
        if (parent != null) {
            node.releaseShared();
            _CursorFrame parentCopy = new _CursorFrame();
            while (true) {
                if (parent != null) {
                    parent.copyInto(parentCopy);
                }
                node = this.acquireShared();
                _CursorFrame actualParent = this.mParentFrame;
                if (actualParent == parent) {
                    if (parent == null) break;
                    dest.mParentFrame = parentCopy;
                    break;
                }
                node.releaseShared();
                _CursorFrame.popAll(parentCopy);
                parent = actualParent;
            }
        }
        dest.mNotFoundKey = this.mNotFoundKey;
        dest.bind(node, this.mNodePos);
        node.releaseShared();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode());
    }
}

