/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import org.cojen.tupl.BoundedView;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.ReverseView;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.TransformedView;
import org.cojen.tupl.Transformer;
import org.cojen.tupl.UnmodifiableView;
import org.cojen.tupl.ViewConstraintException;
import org.cojen.tupl.ViewUtils;

public interface View {
    public Ordering getOrdering();

    public Cursor newCursor(Transaction var1);

    default public long count(byte[] lowKey, byte[] highKey) throws IOException {
        return ViewUtils.count(this, false, lowKey, highKey);
    }

    public byte[] load(Transaction var1, byte[] var2) throws IOException;

    public void store(Transaction var1, byte[] var2, byte[] var3) throws IOException;

    public byte[] exchange(Transaction var1, byte[] var2, byte[] var3) throws IOException;

    default public boolean insert(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.update(txn, key, null, value);
    }

    public boolean replace(Transaction var1, byte[] var2, byte[] var3) throws IOException;

    public boolean update(Transaction var1, byte[] var2, byte[] var3, byte[] var4) throws IOException;

    default public boolean delete(Transaction txn, byte[] key) throws IOException {
        return this.replace(txn, key, null);
    }

    default public boolean remove(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.update(txn, key, value, null);
    }

    public LockResult lockShared(Transaction var1, byte[] var2) throws LockFailureException, ViewConstraintException;

    public LockResult lockUpgradable(Transaction var1, byte[] var2) throws LockFailureException, ViewConstraintException;

    public LockResult lockExclusive(Transaction var1, byte[] var2) throws LockFailureException, ViewConstraintException;

    public LockResult lockCheck(Transaction var1, byte[] var2) throws ViewConstraintException;

    default public View viewGe(byte[] key) {
        return BoundedView.viewGe(ViewUtils.checkOrdering(this), key);
    }

    default public View viewGt(byte[] key) {
        return BoundedView.viewGt(ViewUtils.checkOrdering(this), key);
    }

    default public View viewLe(byte[] key) {
        return BoundedView.viewLe(ViewUtils.checkOrdering(this), key);
    }

    default public View viewLt(byte[] key) {
        return BoundedView.viewLt(ViewUtils.checkOrdering(this), key);
    }

    default public View viewPrefix(byte[] prefix, int trim) {
        return BoundedView.viewPrefix(ViewUtils.checkOrdering(this), prefix, trim);
    }

    default public View viewTransformed(Transformer transformer) {
        return TransformedView.apply(this, transformer);
    }

    default public View viewReverse() {
        return new ReverseView(this);
    }

    default public View viewUnmodifiable() {
        return UnmodifiableView.apply(this);
    }

    public boolean isUnmodifiable();
}

