/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import org.cojen.tupl.LocalTransaction;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.TreeCursor;
import org.cojen.tupl.TxnTree;

final class TxnTreeCursor
extends TreeCursor {
    TxnTreeCursor(TxnTree tree, Transaction txn) {
        super(tree, txn);
    }

    TxnTreeCursor(TxnTree tree) {
        super(tree);
    }

    @Override
    public final void store(byte[] value) throws IOException {
        block8: {
            byte[] key = this.mKey;
            if (key == null) {
                throw new IllegalStateException("Cursor position is undefined");
            }
            try {
                LocalTransaction txn = this.mTxn;
                if (txn == null) {
                    txn = this.mTree.mDatabase.newAlwaysRedoTransaction();
                    try {
                        if (txn.lockMode() != LockMode.UNSAFE) {
                            txn.lockExclusive(this.mTree.mId, key, this.keyHash());
                        }
                        this.store(txn, this.leafExclusive(), value);
                        txn.commit();
                        break block8;
                    }
                    catch (Throwable e) {
                        txn.reset();
                        throw e;
                    }
                }
                if (txn.lockMode() != LockMode.UNSAFE) {
                    txn.lockExclusive(this.mTree.mId, key, this.keyHash());
                }
                this.store(txn, this.leafExclusive(), value);
            }
            catch (Throwable e) {
                throw this.handleException(e, false);
            }
        }
    }

    @Override
    public final void commit(byte[] value) throws IOException {
        block6: {
            byte[] key = this.mKey;
            if (key == null) {
                throw new IllegalStateException("Cursor position is undefined");
            }
            try {
                LocalTransaction txn = this.mTxn;
                if (txn == null) {
                    txn = this.mTree.mDatabase.newAlwaysRedoTransaction();
                    try {
                        this.doCommit(txn, key, value);
                        break block6;
                    }
                    catch (Throwable e) {
                        txn.reset();
                        throw e;
                    }
                }
                this.doCommit(txn, key, value);
            }
            catch (Throwable e) {
                throw this.handleException(e, false);
            }
        }
    }
}

