/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.cojen.tupl.CommitLock;
import org.cojen.tupl.CompactionObserver;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.CursorFrame;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.DeadlockException;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.Index;
import org.cojen.tupl.LocalDatabase;
import org.cojen.tupl.LocalTransaction;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockManager;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Locker;
import org.cojen.tupl.Node;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.PageOps;
import org.cojen.tupl.Split;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Tree;
import org.cojen.tupl.TreeValueStream;
import org.cojen.tupl.Utils;
import org.cojen.tupl.VerificationObserver;
import org.cojen.tupl.io.CauseCloseable;

class TreeCursor
implements CauseCloseable,
Cursor {
    private static final int LIMIT_LE = 1;
    private static final int LIMIT_LT = 2;
    private static final int LIMIT_GE = -1;
    private static final int LIMIT_GT = -2;
    final Tree mTree;
    LocalTransaction mTxn;
    private CursorFrame mLeaf;
    byte[] mKey;
    byte[] mValue;
    boolean mKeyOnly;
    private int mKeyHash;
    private static final int VARIANT_REGULAR = 0;
    private static final int VARIANT_RETAIN = 1;
    private static final int VARIANT_NO_LOCK = 2;
    private static final int VARIANT_CHECK = 3;
    static final byte[] MODIFY_INSERT = new byte[0];
    static final byte[] MODIFY_REPLACE = new byte[0];

    TreeCursor(Tree tree, Transaction txn) {
        this.mTxn = tree.check(txn);
        this.mTree = tree;
    }

    TreeCursor(Tree tree) {
        this.mTree = tree;
    }

    @Override
    public final Ordering getOrdering() {
        return Ordering.ASCENDING;
    }

    @Override
    public final Transaction link(Transaction txn) {
        LocalTransaction old = this.mTxn;
        this.mTxn = this.mTree.check(txn);
        return old;
    }

    @Override
    public final Transaction link() {
        return this.mTxn;
    }

    @Override
    public final byte[] key() {
        return this.mKey;
    }

    @Override
    public final byte[] value() {
        return this.mValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void valueStats(long[] stats) throws IOException {
        stats[0] = -1L;
        stats[1] = 0L;
        if (this.mValue != null && this.mValue != Cursor.NOT_LOADED) {
            stats[0] = this.mValue.length;
            stats[1] = 0L;
            return;
        }
        CursorFrame frame = this.leafSharedNotSplit();
        Node node = frame.mNode;
        try {
            int pos = frame.mNodePos;
            if (pos >= 0) {
                node.retrieveLeafValueStats(pos, stats);
            }
        }
        finally {
            node.releaseShared();
        }
    }

    @Override
    public final boolean autoload(boolean mode) {
        boolean old = this.mKeyOnly;
        this.mKeyOnly = !mode;
        return !old;
    }

    @Override
    public final boolean autoload() {
        return !this.mKeyOnly;
    }

    @Override
    public final int compareKeyTo(byte[] rkey) {
        byte[] lkey = this.mKey;
        return Utils.compareUnsigned(lkey, 0, lkey.length, rkey, 0, rkey.length);
    }

    @Override
    public final int compareKeyTo(byte[] rkey, int offset, int length) {
        byte[] lkey = this.mKey;
        return Utils.compareUnsigned(lkey, 0, lkey.length, rkey, offset, length);
    }

    protected final int keyHash() {
        int hash = this.mKeyHash;
        if (hash == 0) {
            this.mKeyHash = hash = LockManager.hash(this.mTree.mId, this.mKey);
        }
        return hash;
    }

    @Override
    public final LockResult first() throws IOException {
        this.reset();
        if (!this.toFirst(this.latchRootNode(), new CursorFrame())) {
            return LockResult.UNOWNED;
        }
        LocalTransaction txn = this.mTxn;
        LockResult result = this.tryCopyCurrent(txn);
        if (result != null ? this.mKey == null || this.mValue != null : (result = this.lockAndCopyIfExists(txn)) != null) {
            return result;
        }
        return this.next();
    }

    private boolean toFirst(Node node, CursorFrame frame) throws IOException {
        try {
            while (true) {
                frame.bind(node, 0);
                if (node.mSplit != null) {
                    node = this.finishSplitShared(frame, node);
                }
                if (node.isLeaf()) {
                    this.mLeaf = frame;
                    return node.hasKeys() ? true : this.toNext(frame);
                }
                node = this.latchToChild(node, 0);
                frame = new CursorFrame(frame);
            }
        }
        catch (Throwable e) {
            throw this.cleanup(e, frame);
        }
    }

    private final void toFirstNode(Node node, CursorFrame frame) throws IOException {
        try {
            while (true) {
                frame.bind(node, 0);
                if (node.mSplit != null) {
                    node = this.finishSplitShared(frame, node);
                }
                if (node.isLeaf()) {
                    this.mLeaf = frame;
                    return;
                }
                node = this.latchToChild(node, 0);
                frame = new CursorFrame(frame);
            }
        }
        catch (Throwable e) {
            throw this.cleanup(e, frame);
        }
    }

    @Override
    public final LockResult last() throws IOException {
        this.reset();
        if (!this.toLast(this.latchRootNode(), new CursorFrame())) {
            return LockResult.UNOWNED;
        }
        LocalTransaction txn = this.mTxn;
        LockResult result = this.tryCopyCurrent(txn);
        if (result != null ? this.mKey == null || this.mValue != null : (result = this.lockAndCopyIfExists(txn)) != null) {
            return result;
        }
        return this.previous();
    }

    private boolean toLast(Node node, CursorFrame frame) throws IOException {
        try {
            while (true) {
                Split split;
                if ((split = node.mSplit) != null) {
                    frame.bind(node, split.highestPos(node));
                    node = this.finishSplitShared(frame, node);
                }
                if (node.isLeaf()) {
                    int pos = node.highestLeafPos();
                    this.mLeaf = frame;
                    if (pos < 0) {
                        frame.bindOrReposition(node, 0);
                        return this.toPrevious(frame);
                    }
                    frame.bindOrReposition(node, pos);
                    return true;
                }
                int childPos = node.highestInternalPos();
                frame.bindOrReposition(node, childPos);
                node = this.latchToChild(node, childPos);
                frame = new CursorFrame(frame);
            }
        }
        catch (Throwable e) {
            throw this.cleanup(e, frame);
        }
    }

    @Override
    public final LockResult skip(long amount) throws IOException {
        if (amount == 0L) {
            byte[] key;
            LocalTransaction txn = this.mTxn;
            if (txn != null && txn != Transaction.BOGUS && (key = this.mKey) != null) {
                return txn.mManager.check(txn, this.mTree.mId, key, this.keyHash());
            }
            return LockResult.UNOWNED;
        }
        try {
            CursorFrame frame = this.leafSharedNotSplit();
            if (amount > 0L) {
                if (amount > 1L && (frame = this.skipNextGap(frame, amount - 1L, null)) == null) {
                    return LockResult.UNOWNED;
                }
                return this.next(this.mTxn, frame);
            }
            if (amount < -1L && (frame = this.skipPreviousGap(frame, -1L - amount, null)) == null) {
                return LockResult.UNOWNED;
            }
            return this.previous(this.mTxn, frame);
        }
        catch (Throwable e) {
            throw this.handleException(e, false);
        }
    }

    @Override
    public final LockResult skip(long amount, byte[] limitKey, boolean inclusive) throws IOException {
        if (amount == 0L || limitKey == null) {
            return this.skip(amount);
        }
        try {
            CursorFrame frame = this.leafSharedNotSplit();
            if (amount > 0L) {
                if (amount > 1L && (frame = this.skipNextGap(frame, amount - 1L, limitKey)) == null) {
                    return LockResult.UNOWNED;
                }
                return this.nextCmp(limitKey, inclusive ? 1 : 2, frame);
            }
            if (amount < -1L && (frame = this.skipPreviousGap(frame, -1L - amount, limitKey)) == null) {
                return LockResult.UNOWNED;
            }
            return this.previousCmp(limitKey, inclusive ? -1 : -2, frame);
        }
        catch (Throwable e) {
            throw this.handleException(e, false);
        }
    }

    @Override
    public final LockResult next() throws IOException {
        return this.next(this.mTxn, this.leafSharedNotSplit());
    }

    @Override
    public final LockResult nextLe(byte[] limitKey) throws IOException {
        return this.nextCmp(limitKey, 1);
    }

    @Override
    public final LockResult nextLt(byte[] limitKey) throws IOException {
        return this.nextCmp(limitKey, 2);
    }

    private LockResult nextCmp(byte[] limitKey, int limitMode) throws IOException {
        if (limitKey == null) {
            throw new NullPointerException("Key is null");
        }
        return this.nextCmp(limitKey, limitMode, this.leafSharedNotSplit());
    }

    private LockResult nextCmp(byte[] limitKey, int limitMode, CursorFrame frame) throws IOException {
        LocalTransaction txn = this.mTxn;
        while (this.toNext(frame)) {
            LockResult result = this.tryCopyCurrentCmp(txn, limitKey, limitMode);
            if (result != null ? this.mKey == null || this.mValue != null : (result = this.lockAndCopyIfExists(txn)) != null) {
                return result;
            }
            frame = this.leafSharedNotSplit();
        }
        return LockResult.UNOWNED;
    }

    private LockResult next(LocalTransaction txn, CursorFrame frame) throws IOException {
        while (this.toNext(frame)) {
            LockResult result = this.tryCopyCurrent(txn);
            if (result != null ? this.mKey == null || this.mValue != null : (result = this.lockAndCopyIfExists(txn)) != null) {
                return result;
            }
            frame = this.leafSharedNotSplit();
        }
        return LockResult.UNOWNED;
    }

    private boolean toNext(CursorFrame frame) throws IOException {
        Node node;
        block11: {
            int pos;
            block12: {
                block10: {
                    node = frame.mNode;
                    pos = frame.mNodePos;
                    if (pos >= 0) break block10;
                    if ((pos = -3 - pos) >= node.highestLeafPos()) break block11;
                    frame.mNotFoundKey = null;
                    break block12;
                }
                if (pos >= node.highestLeafPos()) break block11;
            }
            frame.mNodePos = pos + 2;
            return true;
        }
        while (true) {
            int parentPos;
            Node parentNode;
            CursorFrame parentFrame;
            block16: {
                block18: {
                    int pos;
                    block19: {
                        block17: {
                            block15: {
                                block14: {
                                    block13: {
                                        if ((parentFrame = frame.peek()) == null) {
                                            node.releaseShared();
                                            frame.popv();
                                            this.mLeaf = null;
                                            this.mKey = null;
                                            this.mKeyHash = 0;
                                            this.mValue = null;
                                            return false;
                                        }
                                        parentNode = parentFrame.tryAcquireShared();
                                        node.releaseShared();
                                        if (parentNode != null) break block13;
                                        parentNode = parentFrame.acquireShared();
                                        if (parentNode.mSplit != null) break block14;
                                        break block15;
                                    }
                                    if (parentNode.mSplit != null) break block14;
                                    frame.popv();
                                    parentPos = parentFrame.mNodePos;
                                    break block16;
                                }
                                parentNode = this.finishSplitShared(parentFrame, parentNode);
                            }
                            parentPos = parentFrame.mNodePos;
                            node = this.latchChildRetainParent(parentNode, parentPos);
                            pos = frame.mNodePos;
                            if (pos >= 0) break block17;
                            if ((pos = -3 - pos) >= node.highestLeafPos()) break block18;
                            frame.mNotFoundKey = null;
                            break block19;
                        }
                        if (pos >= node.highestPos()) break block18;
                    }
                    parentNode.releaseShared();
                    frame.mNodePos = pos += 2;
                    if (frame != this.mLeaf) {
                        return this.toFirst(this.latchToChild(node, pos), new CursorFrame(frame));
                    }
                    return true;
                }
                node.releaseShared();
                frame.popv();
            }
            if (parentPos < parentNode.highestInternalPos()) {
                parentFrame.mNodePos = parentPos += 2;
                frame = new CursorFrame(parentFrame);
                return this.toFirst(this.latchToChild(parentNode, parentPos), frame);
            }
            frame = parentFrame;
            node = parentNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private CursorFrame skipNextGap(CursorFrame frame, long amount, byte[] inLimit) throws IOException {
        block9: while (true) lbl-1000:
        // 3 sources

        {
            block34: {
                block35: {
                    block33: {
                        node = frame.mNode;
                        pos = frame.mNodePos;
                        if (pos >= 0) break block33;
                        highest = node.highestLeafPos();
                        if ((pos = -3 - pos) >= highest) break block34;
                        frame.mNotFoundKey = null;
                        break block35;
                    }
                    highest = node.highestLeafPos();
                    if (pos >= highest) break block34;
                }
                avail = highest - pos >> 1;
                if ((long)avail >= amount) {
                    frame.mNodePos = pos + ((int)amount << 1);
                    return frame;
                }
                frame.mNodePos = highest;
                amount -= (long)avail;
            }
            while (true) {
                block39: {
                    block41: {
                        block42: {
                            block40: {
                                block38: {
                                    block37: {
                                        block36: {
                                            if ((parentFrame = frame.peek()) == null) {
                                                node.releaseShared();
                                                frame.popv();
                                                this.mLeaf = null;
                                                this.mKey = null;
                                                this.mKeyHash = 0;
                                                this.mValue = null;
                                                return null;
                                            }
                                            parentNode = parentFrame.tryAcquireShared();
                                            node.releaseShared();
                                            if (parentNode != null) break block36;
                                            parentNode = parentFrame.acquireShared();
                                            if (parentNode.mSplit != null) break block37;
                                            break block38;
                                        }
                                        if (parentNode.mSplit != null) break block37;
                                        frame.popv();
                                        parentPos = parentFrame.mNodePos;
                                        break block39;
                                    }
                                    parentNode = this.finishSplitShared(parentFrame, parentNode);
                                }
                                parentPos = parentFrame.mNodePos;
                                node = this.latchChildRetainParent(parentNode, parentPos);
                                pos = frame.mNodePos;
                                if (pos >= 0) break block40;
                                highest = node.highestLeafPos();
                                if ((pos = -3 - pos) >= highest) break block41;
                                frame.mNotFoundKey = null;
                                break block42;
                            }
                            highest = node.highestPos();
                            if (pos >= highest) break block41;
                        }
                        parentNode.releaseShared();
                        if (frame == this.mLeaf) {
                            avail = highest - pos >> 1;
                            if ((long)avail >= amount) {
                                frame.mNodePos = pos + ((int)amount << 1);
                                return frame;
                            }
                            frame.mNodePos = highest;
                            amount -= (long)avail;
                        }
                        if (inLimit != null) {
                            try {
                                if (node.compareKey(pos, inLimit) > 0) {
                                    this.mLeaf = frame;
                                    this.resetLatched(node);
                                    return null;
                                }
                            }
                            catch (Throwable e) {
                                this.mLeaf = frame;
                                this.resetLatched(node);
                                throw e;
                            }
                        }
                        frame.mNodePos = pos += 2;
                        if (!this.toFirst(this.latchToChild(node, pos), new CursorFrame(frame))) {
                            return null;
                        }
                        frame = this.mLeaf;
                        if (--amount > 0L) ** GOTO lbl-1000
                        return frame;
                    }
                    node.releaseShared();
                    frame.popv();
                }
                while (parentPos < parentNode.highestInternalPos()) {
                    block43: {
                        if (inLimit != null) {
                            try {
                                if (parentNode.compareKey(parentPos, inLimit) > 0) {
                                    this.mLeaf = parentFrame;
                                    this.resetLatched(parentNode);
                                    return null;
                                }
                            }
                            catch (Throwable e) {
                                this.mLeaf = parentFrame;
                                this.resetLatched(parentNode);
                                throw e;
                            }
                        }
                        parentFrame.mNodePos = parentPos += 2;
                        if (!parentNode.isBottomInternal()) ** GOTO lbl132
                        childCount = parentNode.retrieveChildEntryCount(parentPos);
                        if (childCount < 0) break block43;
                        if ((long)childCount < amount) {
                            amount -= (long)childCount;
                            continue;
                        }
                        ** GOTO lbl132
                    }
                    if (!this.mTree.allowStoredCounts()) ** GOTO lbl132
                    childNode = this.latchChildRetainParent(parentNode, parentPos);
                    if (childNode.mCachedState != 0 || !parentNode.tryUpgrade()) {
                        parentNode.releaseShared();
                    } else {
                        try {
                            commitLock = this.mTree.mDatabase.commitLock();
                            if (commitLock.tryAcquireShared()) {
                                try {
                                    parentNode = this.notSplitDirty(parentFrame);
                                    childCount = childNode.countNonGhostKeys();
                                    parentNode.storeChildEntryCount(parentPos, childCount);
                                    if ((long)childCount < amount) {
                                        amount -= (long)childCount;
                                        childNode.releaseShared();
                                        parentNode.downgrade();
                                        continue;
                                    }
                                }
                                finally {
                                    commitLock.releaseShared();
                                    continue;
                                }
                            }
                            parentNode.releaseExclusive();
                        }
                        catch (Throwable e) {
                            parentNode.releaseExclusive();
                            throw e;
                        }
lbl132:
                        // 3 sources

                        childNode = this.latchToChild(parentNode, parentPos);
                    }
                    frame = new CursorFrame(parentFrame);
                    if (!this.toFirst(childNode, frame)) {
                        return null;
                    }
                    frame = this.mLeaf;
                    if (--amount > 0L) continue block9;
                    return frame;
                }
                frame = parentFrame;
                node = parentNode;
            }
            break;
        }
    }

    @Override
    public final LockResult previous() throws IOException {
        return this.previous(this.mTxn, this.leafSharedNotSplit());
    }

    @Override
    public final LockResult previousGe(byte[] limitKey) throws IOException {
        return this.previousCmp(limitKey, -1);
    }

    @Override
    public final LockResult previousGt(byte[] limitKey) throws IOException {
        return this.previousCmp(limitKey, -2);
    }

    private LockResult previousCmp(byte[] limitKey, int limitMode) throws IOException {
        if (limitKey == null) {
            throw new NullPointerException("Key is null");
        }
        return this.previousCmp(limitKey, limitMode, this.leafSharedNotSplit());
    }

    private LockResult previousCmp(byte[] limitKey, int limitMode, CursorFrame frame) throws IOException {
        LocalTransaction txn = this.mTxn;
        while (this.toPrevious(frame)) {
            LockResult result = this.tryCopyCurrentCmp(txn, limitKey, limitMode);
            if (result != null ? this.mKey == null || this.mValue != null : (result = this.lockAndCopyIfExists(txn)) != null) {
                return result;
            }
            frame = this.leafSharedNotSplit();
        }
        return LockResult.UNOWNED;
    }

    private LockResult previous(LocalTransaction txn, CursorFrame frame) throws IOException {
        while (this.toPrevious(frame)) {
            LockResult result = this.tryCopyCurrent(txn);
            if (result != null ? this.mKey == null || this.mValue != null : (result = this.lockAndCopyIfExists(txn)) != null) {
                return result;
            }
            frame = this.leafSharedNotSplit();
        }
        return LockResult.UNOWNED;
    }

    private boolean toPrevious(CursorFrame frame) throws IOException {
        Node node;
        block11: {
            int pos;
            block12: {
                block10: {
                    node = frame.mNode;
                    pos = frame.mNodePos;
                    if (pos >= 0) break block10;
                    if ((pos ^= 0xFFFFFFFF) == 0) break block11;
                    frame.mNotFoundKey = null;
                    break block12;
                }
                if (pos == 0) break block11;
            }
            frame.mNodePos = pos - 2;
            return true;
        }
        while (true) {
            int parentPos;
            Node parentNode;
            CursorFrame parentFrame;
            block16: {
                block18: {
                    int pos;
                    block19: {
                        block17: {
                            block15: {
                                block14: {
                                    block13: {
                                        if ((parentFrame = frame.peek()) == null) {
                                            node.releaseShared();
                                            frame.popv();
                                            this.mLeaf = null;
                                            this.mKey = null;
                                            this.mKeyHash = 0;
                                            this.mValue = null;
                                            return false;
                                        }
                                        parentNode = parentFrame.tryAcquireShared();
                                        node.releaseShared();
                                        if (parentNode != null) break block13;
                                        parentNode = parentFrame.acquireShared();
                                        if (parentNode.mSplit != null) break block14;
                                        break block15;
                                    }
                                    if (parentNode.mSplit != null) break block14;
                                    frame.popv();
                                    parentPos = parentFrame.mNodePos;
                                    break block16;
                                }
                                parentNode = this.finishSplitShared(parentFrame, parentNode);
                            }
                            parentPos = parentFrame.mNodePos;
                            node = this.latchChildRetainParent(parentNode, parentPos);
                            pos = frame.mNodePos;
                            if (pos >= 0) break block17;
                            if ((pos ^= 0xFFFFFFFF) == 0) break block18;
                            frame.mNotFoundKey = null;
                            break block19;
                        }
                        if (pos == 0) break block18;
                    }
                    parentNode.releaseShared();
                    frame.mNodePos = pos -= 2;
                    if (frame != this.mLeaf) {
                        return this.toLast(this.latchToChild(node, pos), new CursorFrame(frame));
                    }
                    return true;
                }
                node.releaseShared();
                frame.popv();
            }
            if (parentPos > 0) {
                parentFrame.mNodePos = parentPos -= 2;
                frame = new CursorFrame(parentFrame);
                return this.toLast(this.latchToChild(parentNode, parentPos), frame);
            }
            frame = parentFrame;
            node = parentNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private CursorFrame skipPreviousGap(CursorFrame frame, long amount, byte[] inLimit) throws IOException {
        block9: while (true) lbl-1000:
        // 3 sources

        {
            block34: {
                block35: {
                    block33: {
                        node = frame.mNode;
                        pos = frame.mNodePos;
                        if (pos >= 0) break block33;
                        if ((pos ^= -1) == 0) break block34;
                        frame.mNotFoundKey = null;
                        break block35;
                    }
                    if (pos == 0) break block34;
                }
                avail = pos >> 1;
                if ((long)avail >= amount) {
                    frame.mNodePos = pos - ((int)amount << 1);
                    return frame;
                }
                frame.mNodePos = 0;
                amount -= (long)avail;
            }
            while (true) {
                block39: {
                    block41: {
                        block42: {
                            block40: {
                                block38: {
                                    block37: {
                                        block36: {
                                            if ((parentFrame = frame.peek()) == null) {
                                                node.releaseShared();
                                                frame.popv();
                                                this.mLeaf = null;
                                                this.mKey = null;
                                                this.mKeyHash = 0;
                                                this.mValue = null;
                                                return null;
                                            }
                                            parentNode = parentFrame.tryAcquireShared();
                                            node.releaseShared();
                                            if (parentNode != null) break block36;
                                            parentNode = parentFrame.acquireShared();
                                            if (parentNode.mSplit != null) break block37;
                                            break block38;
                                        }
                                        if (parentNode.mSplit != null) break block37;
                                        frame.popv();
                                        parentPos = parentFrame.mNodePos;
                                        break block39;
                                    }
                                    parentNode = this.finishSplitShared(parentFrame, parentNode);
                                }
                                parentPos = parentFrame.mNodePos;
                                node = this.latchChildRetainParent(parentNode, parentPos);
                                pos = frame.mNodePos;
                                if (pos >= 0) break block40;
                                if ((pos ^= -1) == 0) break block41;
                                frame.mNotFoundKey = null;
                                break block42;
                            }
                            if (pos == 0) break block41;
                        }
                        parentNode.releaseShared();
                        if (frame == this.mLeaf) {
                            avail = pos >> 1;
                            if ((long)avail >= amount) {
                                frame.mNodePos = pos - ((int)amount << 1);
                                return frame;
                            }
                            frame.mNodePos = 0;
                            amount -= (long)avail;
                        }
                        frame.mNodePos = pos -= 2;
                        if (inLimit != null) {
                            try {
                                if (node.compareKey(pos, inLimit) < 0) {
                                    this.mLeaf = frame;
                                    this.resetLatched(node);
                                    return null;
                                }
                            }
                            catch (Throwable e) {
                                this.mLeaf = frame;
                                this.resetLatched(node);
                                throw e;
                            }
                        }
                        if (!this.toLast(this.latchToChild(node, pos), new CursorFrame(frame))) {
                            return null;
                        }
                        frame = this.mLeaf;
                        if (--amount > 0L) ** GOTO lbl-1000
                        return frame;
                    }
                    node.releaseShared();
                    frame.popv();
                }
                while (parentPos > 0) {
                    block43: {
                        parentFrame.mNodePos = parentPos -= 2;
                        if (inLimit != null) {
                            try {
                                if (parentNode.compareKey(parentPos, inLimit) < 0) {
                                    this.mLeaf = parentFrame;
                                    this.resetLatched(parentNode);
                                    return null;
                                }
                            }
                            catch (Throwable e) {
                                this.mLeaf = parentFrame;
                                this.resetLatched(parentNode);
                                throw e;
                            }
                        }
                        if (!parentNode.isBottomInternal()) ** GOTO lbl128
                        childCount = parentNode.retrieveChildEntryCount(parentPos);
                        if (childCount < 0) break block43;
                        if ((long)childCount < amount) {
                            amount -= (long)childCount;
                            continue;
                        }
                        ** GOTO lbl128
                    }
                    if (!this.mTree.allowStoredCounts()) ** GOTO lbl128
                    childNode = this.latchChildRetainParent(parentNode, parentPos);
                    if (childNode.mCachedState != 0 || !parentNode.tryUpgrade()) {
                        parentNode.releaseShared();
                    } else {
                        try {
                            commitLock = this.mTree.mDatabase.commitLock();
                            if (commitLock.tryAcquireShared()) {
                                try {
                                    parentNode = this.notSplitDirty(parentFrame);
                                    childCount = childNode.countNonGhostKeys();
                                    parentNode.storeChildEntryCount(parentPos, childCount);
                                    if ((long)childCount < amount) {
                                        amount -= (long)childCount;
                                        childNode.releaseShared();
                                        parentNode.downgrade();
                                        continue;
                                    }
                                }
                                finally {
                                    commitLock.releaseShared();
                                    continue;
                                }
                            }
                            parentNode.releaseExclusive();
                        }
                        catch (Throwable e) {
                            parentNode.releaseExclusive();
                            throw e;
                        }
lbl128:
                        // 3 sources

                        childNode = this.latchToChild(parentNode, parentPos);
                    }
                    frame = new CursorFrame(parentFrame);
                    if (!this.toLast(childNode, frame)) {
                        return null;
                    }
                    frame = this.mLeaf;
                    if (--amount > 0L) continue block9;
                    return frame;
                }
                frame = parentFrame;
                node = parentNode;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockResult tryCopyCurrent(LocalTransaction txn) throws IOException {
        CursorFrame leaf = this.mLeaf;
        Node node = leaf.mNode;
        int pos = leaf.mNodePos;
        try {
            int keyHash;
            int lockType;
            block15: {
                this.mKeyHash = 0;
                if (txn == null) {
                    lockType = 0;
                } else {
                    LockMode mode = txn.lockMode();
                    if (mode.noReadLock) {
                        node.retrieveLeafEntry(pos, this);
                        LockResult lockResult = LockResult.UNOWNED;
                        return lockResult;
                    }
                    lockType = mode.repeatable;
                }
                this.mKey = node.retrieveKey(pos);
                this.mValue = NOT_LOADED;
                try {
                    keyHash = this.keyHash();
                    if (lockType != 0) break block15;
                    if (this.mTree.isLockAvailable(txn, this.mKey, keyHash)) {
                        this.mValue = this.mKeyOnly ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos);
                        LockResult lockResult = LockResult.UNOWNED;
                        return lockResult;
                    }
                    LockResult lockResult = null;
                    return lockResult;
                }
                catch (DeadlockException e) {
                    LockResult lockResult = null;
                    return lockResult;
                }
            }
            LockResult result = txn.tryLock(lockType, this.mTree.mId, this.mKey, keyHash, 0L);
            if (result.isHeld()) {
                this.mValue = this.mKeyOnly ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos);
                LockResult lockResult = result;
                return lockResult;
            }
            LockResult lockResult = null;
            return lockResult;
        }
        finally {
            node.releaseShared();
        }
    }

    private LockResult tryCopyCurrentCmp(LocalTransaction txn, byte[] limitKey, int limitMode) throws IOException {
        try {
            return this.doTryCopyCurrentCmp(txn, limitKey, limitMode);
        }
        catch (Throwable e) {
            this.mLeaf.mNode.releaseShared();
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    private LockResult doTryCopyCurrentCmp(LocalTransaction txn, byte[] limitKey, int limitMode) throws IOException {
        block12: {
            leaf = this.mLeaf;
            node = leaf.mNode;
            pos = leaf.mNodePos;
            key = node.retrieveKeyCmp(pos, limitKey, limitMode);
            if (key == null) ** GOTO lbl-1000
            if (key != limitKey) {
                this.mKey = key;
            } else if ((limitMode & 1) != 0) {
                this.mKey = (byte[])key.clone();
            } else lbl-1000:
            // 2 sources

            {
                node.releaseShared();
                this.reset();
                return LockResult.UNOWNED;
            }
            this.mKeyHash = 0;
            if (txn != null) break block12;
            lockType = 0;
            ** GOTO lbl26
        }
        mode = txn.lockMode();
        if (mode.noReadLock) {
            this.mValue = this.mKeyOnly != false ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos);
            result = LockResult.UNOWNED;
        } else {
            lockType = mode.repeatable;
lbl26:
            // 2 sources

            this.mValue = TreeCursor.NOT_LOADED;
            keyHash = this.keyHash();
            if (lockType == 0) {
                if (this.mTree.isLockAvailable(txn, this.mKey, keyHash)) {
                    this.mValue = this.mKeyOnly != false ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos);
                    result = LockResult.UNOWNED;
                } else {
                    result = null;
                }
            } else {
                result = txn.tryLock(lockType, this.mTree.mId, this.mKey, keyHash, 0L);
                if (result.isHeld()) {
                    this.mValue = this.mKeyOnly != false ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos);
                } else {
                    result = null;
                }
            }
        }
        node.releaseShared();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockResult lockAndCopyIfExists(LocalTransaction txn) throws IOException {
        block11: {
            LockResult result;
            int keyHash = this.keyHash();
            if (txn == null) {
                Locker locker = this.mTree.lockSharedLocal(this.mKey, keyHash);
                try {
                    if (this.copyIfExists() != null) {
                        LockResult lockResult = LockResult.UNOWNED;
                        return lockResult;
                    }
                    break block11;
                }
                finally {
                    locker.unlock();
                }
            }
            int lockType = txn.lockMode().repeatable;
            if (lockType == 0) {
                result = txn.lockShared(this.mTree.mId, this.mKey, keyHash);
                if (result == LockResult.ACQUIRED) {
                    result = LockResult.UNOWNED;
                }
            } else {
                result = txn.lock(lockType, this.mTree.mId, this.mKey, keyHash, txn.mLockTimeoutNanos);
            }
            if (this.copyIfExists() != null) {
                if (result == LockResult.UNOWNED) {
                    txn.unlock();
                }
                return result;
            }
            if (result == LockResult.UNOWNED || result == LockResult.ACQUIRED) {
                txn.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] copyIfExists() throws IOException {
        byte[] value;
        CursorFrame frame = this.leafSharedNotSplit();
        Node node = frame.mNode;
        try {
            int pos = frame.mNodePos;
            value = pos < 0 ? null : (this.mKeyOnly ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos));
        }
        finally {
            node.releaseShared();
        }
        this.mValue = value;
        return value;
    }

    private LocalTransaction prepareFind(byte[] key) {
        LockMode mode;
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        LocalTransaction txn = this.mTxn;
        int hash = txn != null && ((mode = txn.lockMode()) == LockMode.READ_UNCOMMITTED || mode == LockMode.UNSAFE) ? 0 : LockManager.hash(this.mTree.mId, key);
        this.mKey = key;
        this.mKeyHash = hash;
        return txn;
    }

    @Override
    public final LockResult find(byte[] key) throws IOException {
        this.reset();
        return this.doFind(key);
    }

    final LockResult doFind(byte[] key) throws IOException {
        return this.find(this.prepareFind(key), key, 0, this.latchRootNode(), new CursorFrame());
    }

    @Override
    public final LockResult findGe(byte[] key) throws IOException {
        this.reset();
        LocalTransaction txn = this.prepareFind(key);
        LockResult result = this.find(txn, key, 1, this.latchRootNode(), new CursorFrame());
        if (this.mValue != null) {
            return result;
        }
        if (result == LockResult.ACQUIRED) {
            txn.unlock();
        }
        return this.next(txn, this.mLeaf);
    }

    @Override
    public final LockResult findLe(byte[] key) throws IOException {
        this.reset();
        LocalTransaction txn = this.prepareFind(key);
        LockResult result = this.find(txn, key, 1, this.latchRootNode(), new CursorFrame());
        if (this.mValue != null) {
            return result;
        }
        if (result == LockResult.ACQUIRED) {
            txn.unlock();
        }
        return this.previous(txn, this.mLeaf);
    }

    @Override
    public final LockResult findGt(byte[] key) throws IOException {
        this.findNoLock(key);
        return this.next(this.mTxn, this.mLeaf);
    }

    @Override
    public final LockResult findLt(byte[] key) throws IOException {
        this.findNoLock(key);
        return this.previous(this.mTxn, this.mLeaf);
    }

    private void findNoLock(byte[] key) throws IOException {
        this.reset();
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        this.find(null, key, 3, this.latchRootNode(), new CursorFrame());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockResult findNearby(byte[] key) throws IOException {
        Node node;
        LocalTransaction txn = this.prepareFind(key);
        CursorFrame frame = this.mLeaf;
        if (frame == null) {
            frame = new CursorFrame();
            node = this.latchRootNode();
        } else {
            block23: {
                int pos;
                int startPos;
                node = frame.acquireShared();
                if (node.mSplit != null) {
                    node = this.finishSplitShared(frame, node);
                }
                if ((startPos = frame.mNodePos) < 0) {
                    startPos ^= 0xFFFFFFFF;
                }
                if ((pos = node.binarySearch(key, startPos)) >= 0) {
                    block22: {
                        frame.mNotFoundKey = null;
                        frame.mNodePos = pos;
                        try {
                            LockResult result = this.tryLockKey(txn);
                            if (result == null) {
                                this.mValue = NOT_LOADED;
                                break block22;
                            }
                            try {
                                this.mValue = this.mKeyOnly ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos);
                                LockResult lockResult = result;
                                return lockResult;
                            }
                            catch (Throwable e) {
                                this.mValue = NOT_LOADED;
                                throw e;
                            }
                        }
                        finally {
                            node.releaseShared();
                        }
                    }
                    return this.doLoad(txn);
                }
                if (!(pos == -1 && (node.type() & 2) == 0 || ~pos > node.highestLeafPos() && (node.type() & 8) == 0)) {
                    frame.mNotFoundKey = key;
                    frame.mNodePos = pos;
                    LockResult result = this.tryLockKey(txn);
                    if (result != null) {
                        this.mValue = null;
                        node.releaseShared();
                        return result;
                    }
                    this.mValue = NOT_LOADED;
                    node.releaseShared();
                    return this.doLoad(txn);
                }
                this.mLeaf = null;
                do {
                    CursorFrame parent;
                    if ((parent = frame.pop()) == null) {
                        Node root = this.mTree.mRoot;
                        if (node != root) {
                            node.releaseShared();
                            root.acquireShared();
                            node = root;
                        }
                        frame = null;
                        break block23;
                    }
                    node.releaseShared();
                    frame = parent;
                    node = frame.acquireShared();
                    if (node.mSplit != null) {
                        node = this.finishSplitShared(frame, node);
                    }
                    try {
                        pos = Node.internalPos(node.binarySearch(key, frame.mNodePos));
                    }
                    catch (Throwable e) {
                        node.releaseShared();
                        throw this.cleanup(e, frame);
                    }
                } while (pos == 0 && (node.type() & 2) == 0 || pos >= node.highestInternalPos() && (node.type() & 8) == 0);
                frame.mNodePos = pos;
                try {
                    node = this.latchToChild(node, pos);
                }
                catch (Throwable e) {
                    throw this.cleanup(e, frame);
                }
            }
            frame = new CursorFrame(frame);
        }
        return this.find(txn, key, 0, node, frame);
    }

    private LockResult find(LocalTransaction txn, byte[] key, int variant, Node node, CursorFrame frame) throws IOException {
        while (true) {
            int selectedPos;
            Node selected;
            Node right;
            Node left;
            if (node.isLeaf()) {
                LockResult result;
                int pos;
                if (node.mSplit == null) {
                    try {
                        pos = node.binarySearch(key);
                    }
                    catch (Throwable e) {
                        node.releaseShared();
                        throw this.cleanup(e, frame);
                    }
                    frame.bind(node, pos);
                } else {
                    try {
                        pos = node.mSplit.binarySearchLeaf(node, key);
                    }
                    catch (Throwable e) {
                        node.releaseShared();
                        throw this.cleanup(e, frame);
                    }
                    frame.bind(node, pos);
                    if (pos < 0) {
                        frame.mNotFoundKey = key;
                    }
                    node = this.finishSplitShared(frame, node);
                    pos = frame.mNodePos;
                }
                this.mLeaf = frame;
                if (variant >= 2) {
                    result = LockResult.UNOWNED;
                } else {
                    result = this.tryLockKey(txn);
                    if (result == null) {
                        if (pos < 0) {
                            frame.mNotFoundKey = key;
                        }
                        this.mValue = NOT_LOADED;
                        node.releaseShared();
                        return this.doLoad(txn);
                    }
                }
                if (pos < 0) {
                    frame.mNotFoundKey = key;
                    this.mValue = null;
                    if (variant < 1) {
                        node.releaseShared();
                    }
                } else if (variant == 3) {
                    this.mValue = NOT_LOADED;
                } else {
                    try {
                        this.mValue = this.mKeyOnly ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos);
                    }
                    catch (Throwable e) {
                        this.mValue = NOT_LOADED;
                        node.releaseShared();
                        throw e;
                    }
                    if (variant < 2) {
                        node.releaseShared();
                    }
                }
                return result;
            }
            Split split = node.mSplit;
            if (split == null) {
                int childPos;
                try {
                    childPos = Node.internalPos(node.binarySearch(key));
                }
                catch (Throwable e) {
                    node.releaseShared();
                    throw this.cleanup(e, frame);
                }
                frame.bind(node, childPos);
                try {
                    node = this.latchToChild(node, childPos);
                }
                catch (Throwable e) {
                    throw this.cleanup(e, frame);
                }
            }
            Node sibling = split.latchSibling();
            if (split.mSplitRight) {
                left = node;
                right = sibling;
            } else {
                left = sibling;
                right = node;
            }
            try {
                if (split.compare(key) < 0) {
                    selected = left;
                    selectedPos = Node.internalPos(left.binarySearch(key));
                    frame.bind(node, selectedPos);
                    right.releaseShared();
                } else {
                    selected = right;
                    selectedPos = Node.internalPos(right.binarySearch(key));
                    frame.bind(node, left.highestInternalPos() + 2 + selectedPos);
                    left.releaseShared();
                }
            }
            catch (Throwable e) {
                node.releaseShared();
                sibling.releaseShared();
                throw this.cleanup(e, frame);
            }
            try {
                node = this.latchToChild(selected, selectedPos);
            }
            catch (Throwable e) {
                throw this.cleanup(e, frame);
            }
            frame = new CursorFrame(frame);
        }
    }

    private LockResult tryLockKey(LocalTransaction txn) {
        LockMode mode;
        if (txn == null || (mode = txn.lockMode()) == LockMode.READ_COMMITTED) {
            return this.mTree.isLockAvailable(txn, this.mKey, this.mKeyHash) ? LockResult.UNOWNED : null;
        }
        try {
            if (mode.noReadLock) {
                return LockResult.UNOWNED;
            }
            LockResult result = txn.tryLock(mode.repeatable, this.mTree.mId, this.mKey, this.mKeyHash, 0L);
            return result.isHeld() ? result : null;
        }
        catch (DeadlockException e) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final LockResult random(byte[] lowKey, byte[] highKey) throws IOException {
        if (lowKey != null && highKey != null && Utils.compareUnsigned(lowKey, highKey) >= 0) {
            this.reset();
            return LockResult.UNOWNED;
        }
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        block8: while (true) {
            this.reset();
            CursorFrame frame = new CursorFrame();
            Node node = this.latchRootNode();
            while (true) {
                int pos;
                if (node.mSplit != null) {
                    frame.bind(node, 0);
                    node = this.finishSplitShared(frame, node);
                }
                try {
                    pos = this.randomPosition(rnd, node, lowKey, highKey);
                }
                catch (Throwable e) {
                    node.releaseShared();
                    throw this.cleanup(e, frame);
                }
                if (pos < 0) {
                    this.mLeaf = frame;
                    this.resetLatched(node);
                    if (!this.isRangeEmpty(lowKey, highKey)) continue block8;
                    return LockResult.UNOWNED;
                }
                frame.bindOrReposition(node, pos);
                if (node.isLeaf()) {
                    LocalTransaction txn;
                    this.mLeaf = frame;
                    try {
                        txn = this.prepareFind(node.retrieveKey(pos));
                    }
                    catch (Throwable e) {
                        this.resetLatched(node);
                        throw e;
                    }
                    LockResult result = this.tryLockKey(txn);
                    if (result == null) {
                        this.mValue = NOT_LOADED;
                        node.releaseShared();
                        result = this.doLoad(txn);
                    } else {
                        try {
                            this.mValue = this.mKeyOnly ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos);
                        }
                        catch (Throwable e) {
                            this.mValue = NOT_LOADED;
                            node.releaseShared();
                            throw e;
                        }
                        node.releaseShared();
                    }
                    if (this.mValue != null) return result;
                    if (result == LockResult.ACQUIRED) {
                        txn.unlock();
                    }
                    frame = this.leafSharedNotSplit();
                    if (rnd.nextBoolean()) {
                        result = highKey == null ? this.next(txn, frame) : this.nextCmp(highKey, 2, frame);
                    } else {
                        LockResult lockResult = result = lowKey == null ? this.previous(txn, frame) : this.previousCmp(lowKey, -1, frame);
                    }
                    if (this.mValue != null) return result;
                    continue block8;
                }
                try {
                    node = this.latchToChild(node, pos);
                }
                catch (Throwable e) {
                    throw this.cleanup(e, frame);
                }
                frame = new CursorFrame(frame);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] randomNode(byte[] lowKey, byte[] highKey) throws IOException {
        byte[] endKey = null;
        if (lowKey != null && highKey != null && Utils.compareUnsigned(lowKey, highKey) >= 0) {
            this.reset();
            return endKey;
        }
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        block16: while (true) {
            this.reset();
            CursorFrame frame = new CursorFrame();
            Node node = this.latchRootNode();
            int remainingAttemptsBIN = 2;
            int remainingAttempsLN = 2;
            while (true) {
                Node child;
                long childId;
                if (node.mSplit != null) {
                    frame.bindOrReposition(node, 0);
                    node = this.finishSplitShared(frame, node);
                }
                int pos = 0;
                if (!node.isLeaf()) {
                    try {
                        pos = this.randomPosition(rnd, node, lowKey, highKey);
                    }
                    catch (Throwable e) {
                        node.releaseShared();
                        throw this.cleanup(e, frame);
                    }
                    if (pos < 0) {
                        this.mLeaf = frame;
                        this.resetLatched(node);
                        if (!this.isRangeEmpty(lowKey, highKey)) continue block16;
                        return endKey;
                    }
                }
                frame.bindOrReposition(node, pos);
                if (node.isLeaf()) {
                    this.mLeaf = frame;
                    try {
                        this.mKey = node.retrieveKey(pos);
                        if (this.mKey == null) {
                            byte[] e = endKey;
                            return e;
                        }
                        byte[] byArray = this.mValue = this.mKeyOnly ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos);
                        if (this.mValue == null) {
                            this.reset();
                            byte[] e = endKey;
                            return e;
                        }
                        pos = node.highestKeyPos();
                        endKey = node.retrieveKey(pos);
                        if (endKey == null) {
                            this.reset();
                            byte[] e = endKey;
                            return e;
                        }
                    }
                    finally {
                        node.releaseShared();
                    }
                    return endKey;
                }
                if (node.isBottomInternal()) {
                    childId = node.retrieveChildRefId(pos);
                    child = this.mTree.mDatabase.nodeMapGet(childId);
                    if (child != null) {
                        if (remainingAttempsLN-- > 0) continue;
                        try {
                            int highestInternalPos = node.highestInternalPos();
                            int highestKeyPos = node.highestKeyPos();
                            for (int spos = lowKey == null ? 0 : Node.internalPos(node.binarySearch(lowKey)); spos <= highestInternalPos; spos += 2) {
                                childId = node.retrieveChildRefId(spos);
                                child = this.mTree.mDatabase.nodeMapGet(childId);
                                if (child == null) {
                                    pos = spos;
                                    frame.bindOrReposition(node, pos);
                                } else if (highKey == null || spos > highestKeyPos || node.compareKey(spos, highKey) < 0) {
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Throwable spos) {
                            // empty catch block
                        }
                    }
                    try {
                        node = this.latchToChild(node, pos);
                    }
                    catch (Throwable t) {
                        throw this.cleanup(t, frame);
                    }
                }
                childId = node.retrieveChildRefId(pos);
                child = this.mTree.mDatabase.nodeMapGet(childId);
                if (child != null) {
                    child.acquireShared();
                    try {
                        if (childId == child.mId && child.isBottomInternal() && remainingAttemptsBIN-- > 0) {
                            continue;
                        }
                    }
                    finally {
                        child.releaseShared();
                        continue;
                    }
                }
                try {
                    node = this.latchToChild(node, pos);
                }
                catch (Throwable t) {
                    throw this.cleanup(t, frame);
                }
                frame = new CursorFrame(frame);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Index.Stats analyze() throws IOException {
        double valueBytes;
        double keyBytes;
        double totalBytes;
        double freeBytes;
        double entryCount;
        CursorFrame frame = this.leafSharedNotSplit();
        Node node = frame.mNode;
        try {
            int numKeys;
            entryCount = node.numKeys();
            int pos = frame.mNodePos;
            freeBytes = node.availableBytes();
            totalBytes = this.pageSize(node.mPage);
            if (pos < 0 || (numKeys = node.numKeys()) <= 0) {
                keyBytes = 0.0;
                valueBytes = 0.0;
            } else {
                long[] stats = new long[2];
                node.retrieveKeyStats(pos, stats);
                keyBytes = (double)stats[0] * (double)numKeys;
                totalBytes += (double)stats[1] * (double)this.pageSize(node.mPage);
                node.retrieveLeafValueStats(pos, stats);
                valueBytes = (double)stats[0] * (double)numKeys;
                totalBytes += (double)stats[1] * (double)this.pageSize(node.mPage);
            }
            frame = frame.pop();
        }
        catch (Throwable e) {
            this.resetLatched(node);
            throw e;
        }
        node.releaseShared();
        while (frame != null) {
            int pageSize;
            int availBytes;
            double scalar;
            node = frame.acquireShared();
            try {
                scalar = node.numKeys() + 1;
                availBytes = node.availableInternalBytes();
                pageSize = this.pageSize(node.mPage);
                frame = frame.pop();
            }
            finally {
                node.releaseShared();
            }
            entryCount *= scalar;
            keyBytes *= scalar;
            valueBytes *= scalar;
            freeBytes *= scalar;
            totalBytes *= scalar;
            freeBytes += (double)availBytes;
            totalBytes += (double)pageSize;
        }
        return new Index.Stats(entryCount, keyBytes, valueBytes, freeBytes, totalBytes);
    }

    @Override
    public final LockResult load() throws IOException {
        try {
            return this.doLoad(this.mTxn);
        }
        catch (LockFailureException e) {
            this.mValue = NOT_LOADED;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockResult doLoad(LocalTransaction txn) throws IOException {
        Locker locker;
        LockResult result;
        byte[] key = this.mKey;
        if (key == null) {
            throw new IllegalStateException("Cursor position is undefined");
        }
        if (txn == null) {
            result = LockResult.UNOWNED;
            locker = this.mTree.lockSharedLocal(key, this.keyHash());
        } else {
            LockMode mode = txn.lockMode();
            if (mode.noReadLock) {
                result = LockResult.UNOWNED;
                locker = null;
            } else {
                int keyHash = this.keyHash();
                if (mode == LockMode.READ_COMMITTED) {
                    result = txn.lockShared(this.mTree.mId, key, keyHash);
                    if (result == LockResult.ACQUIRED) {
                        result = LockResult.UNOWNED;
                        locker = txn;
                    } else {
                        locker = null;
                    }
                } else {
                    result = txn.lock(mode.repeatable, this.mTree.mId, key, keyHash, txn.mLockTimeoutNanos);
                    locker = null;
                }
            }
        }
        try {
            CursorFrame frame = this.leafSharedNotSplit();
            Node node = frame.mNode;
            try {
                int pos = frame.mNodePos;
                this.mValue = pos >= 0 ? node.retrieveLeafValue(pos) : null;
            }
            finally {
                node.releaseShared();
            }
            LockResult lockResult = result;
            return lockResult;
        }
        finally {
            if (locker != null) {
                locker.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(byte[] value) throws IOException {
        block8: {
            byte[] key = this.mKey;
            if (key == null) {
                throw new IllegalStateException("Cursor position is undefined");
            }
            try {
                LocalTransaction txn = this.mTxn;
                if (txn == null) {
                    Locker locker = this.mTree.lockExclusiveLocal(key, this.keyHash());
                    try {
                        this.store(txn, this.leafExclusive(), value);
                        break block8;
                    }
                    finally {
                        locker.unlock();
                    }
                }
                if (txn.lockMode() != LockMode.UNSAFE) {
                    txn.lockExclusive(this.mTree.mId, key, this.keyHash());
                }
                this.store(txn, this.leafExclusive(), value);
            }
            catch (Throwable e) {
                throw this.handleException(e, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(byte[] value) throws IOException {
        block7: {
            byte[] key = this.mKey;
            if (key == null) {
                throw new IllegalStateException("Cursor position is undefined");
            }
            try {
                LocalTransaction txn = this.mTxn;
                if (txn == null) {
                    Locker locker = this.mTree.lockExclusiveLocal(key, this.keyHash());
                    try {
                        this.store(txn, this.leafExclusive(), value);
                        break block7;
                    }
                    finally {
                        locker.unlock();
                    }
                }
                this.doCommit(txn, key, value);
            }
            catch (Throwable e) {
                throw this.handleException(e, false);
            }
        }
    }

    final void doCommit(LocalTransaction txn, byte[] key, byte[] value) throws IOException {
        if (txn.lockMode() != LockMode.UNSAFE) {
            txn.lockExclusive(this.mTree.mId, key, this.keyHash());
            if (txn.mDurabilityMode != DurabilityMode.NO_REDO) {
                txn.storeCommit(this, value);
                return;
            }
        }
        this.store(txn, this.leafExclusive(), value);
        txn.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final byte[] findAndStore(byte[] key, byte[] value) throws IOException {
        try {
            int hash;
            this.mKey = key;
            LocalTransaction txn = this.mTxn;
            if (txn == null) {
                int hash2;
                this.mKeyHash = hash2 = LockManager.hash(this.mTree.mId, key);
                Locker locker = this.mTree.lockExclusiveLocal(key, hash2);
                try {
                    byte[] byArray = this.doFindAndStore(txn, key, value);
                    return byArray;
                }
                finally {
                    locker.unlock();
                }
            }
            if (txn.lockMode() == LockMode.UNSAFE) {
                this.mKeyHash = 0;
                return this.doFindAndStore(txn, key, value);
            }
            this.mKeyHash = hash = LockManager.hash(this.mTree.mId, key);
            txn.lockExclusive(this.mTree.mId, key, hash);
            return this.doFindAndStore(txn, key, value);
        }
        catch (Throwable e) {
            throw this.handleException(e, true);
        }
    }

    private byte[] doFindAndStore(LocalTransaction txn, byte[] key, byte[] value) throws IOException {
        this.find(null, key, 2, this.latchRootNode(), new CursorFrame());
        byte[] oldValue = this.mValue;
        CursorFrame leaf = this.mLeaf;
        if (!leaf.mNode.tryUpgrade()) {
            leaf.mNode.releaseShared();
            leaf.acquireExclusive();
        }
        this.store(txn, leaf, value);
        this.reset();
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final boolean findAndModify(byte[] key, byte[] oldValue, byte[] newValue) throws IOException {
        LocalTransaction txn = this.mTxn;
        try {
            LockResult result;
            this.mKey = key;
            if (txn == null) {
                int hash;
                this.mKeyHash = hash = LockManager.hash(this.mTree.mId, key);
                Locker locker = this.mTree.lockExclusiveLocal(key, hash);
                try {
                    boolean bl = this.doFindAndModify(null, key, oldValue, newValue);
                    return bl;
                }
                finally {
                    locker.unlock();
                }
            }
            LockMode mode = txn.lockMode();
            if (mode == LockMode.UNSAFE) {
                this.mKeyHash = 0;
                result = LockResult.OWNED_EXCLUSIVE;
            } else {
                int hash;
                this.mKeyHash = hash = LockManager.hash(this.mTree.mId, key);
                result = txn.lockExclusive(this.mTree.mId, key, hash);
                if (result == LockResult.ACQUIRED && mode.repeatable != 0) {
                    result = LockResult.UPGRADED;
                }
            }
            try {
                if (!this.doFindAndModify(txn, key, oldValue, newValue)) return false;
                return true;
            }
            finally {
                if (result == LockResult.ACQUIRED) {
                    txn.unlock();
                } else if (result == LockResult.UPGRADED) {
                    txn.unlockToUpgradable();
                }
            }
        }
        catch (Throwable e) {
            throw this.handleException(e, true);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean doFindAndModify(LocalTransaction txn, byte[] key, byte[] oldValue, byte[] newValue) throws IOException {
        block5: {
            block4: {
                block7: {
                    block6: {
                        block3: {
                            this.find(null, key, 2, this.latchRootNode(), new CursorFrame());
                            if (oldValue != TreeCursor.MODIFY_INSERT) break block3;
                            if (this.mValue != null) break block4;
                            break block5;
                        }
                        if (oldValue != TreeCursor.MODIFY_REPLACE) break block6;
                        if (this.mValue == null) break block4;
                        break block5;
                    }
                    if (this.mValue == null) break block7;
                    if (!Arrays.equals(oldValue, this.mValue)) break block4;
                    break block5;
                }
                if (oldValue == null) {
                    if (newValue == null) {
                        this.resetLatched(this.mLeaf.mNode);
                        return true;
                    } else {
                        ** GOTO lbl20
                    }
                }
                break block4;
lbl20:
                // 2 sources

                break block5;
            }
            this.resetLatched(this.mLeaf.mNode);
            return false;
        }
        leaf = this.mLeaf;
        if (!leaf.mNode.tryUpgrade()) {
            leaf.mNode.releaseShared();
            leaf.acquireExclusive();
        }
        this.store(txn, leaf, newValue);
        this.reset();
        return true;
    }

    final boolean deleteGhost(byte[] key) throws IOException {
        try {
            this.find(null, key, 2, this.latchRootNode(), new CursorFrame());
            CursorFrame leaf = this.mLeaf;
            if (leaf.mNode.mPage == PageOps.p_closedTreePage()) {
                this.resetLatched(leaf.mNode);
                return false;
            }
            if (this.mValue == null) {
                this.mKey = key;
                this.mKeyHash = 0;
                if (!leaf.mNode.tryUpgrade()) {
                    leaf.mNode.releaseShared();
                    leaf.acquireExclusive();
                }
                this.store(LocalTransaction.BOGUS, leaf, null);
                this.reset();
            } else {
                this.resetLatched(leaf.mNode);
            }
            return true;
        }
        catch (Throwable e) {
            throw this.handleException(e, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected final void store(LocalTransaction txn, CursorFrame leaf, byte[] value) throws IOException {
        block37: {
            block38: {
                block40: {
                    block39: {
                        key = this.mKey;
                        commitPos = 0L;
                        if (value != null) break block38;
                        if (leaf.mNodePos >= 0) break block39;
                        node = leaf.mNode;
                        break block37;
                    }
                    commitLock = this.mTree.mDatabase.commitLock();
                    if (commitLock.tryAcquireShared()) break block40;
                    leaf.mNode.releaseExclusive();
                    commitLock.acquireShared();
                    leaf.acquireExclusive();
                    if (leaf.mNodePos >= 0) break block40;
                    node = leaf.mNode;
                    commitLock.releaseShared();
                    break block37;
                }
                try {
                    block41: {
                        node = this.notSplitDirty(leaf);
                        pos = leaf.mNodePos;
                        if (pos < 0) ** GOTO lbl111
                        if (txn != null) break block41;
                        commitPos = this.mTree.redoStore(key, null);
                        ** GOTO lbl33
                    }
                    if (txn.lockMode() != LockMode.UNSAFE) {
                        node.txnDeleteLeafEntry(txn, this.mTree, key, this.keyHash(), pos);
                    }
                    try {
                        if (txn.mDurabilityMode != DurabilityMode.NO_REDO) {
                            commitPos = this.mTree.redoStoreNoLock(key, null);
                        }
lbl33:
                        // 4 sources

                        node.deleteLeafEntry(pos);
                    }
                    catch (Throwable e) {
                        node.releaseExclusive();
                        throw e;
                    }
                    leaf.mNodePos = newPos = ~pos;
                    leaf.mNotFoundKey = key;
                    frame = node.mLastCursorFrame;
                    do {
                        if (frame == leaf) continue;
                        framePos = frame.mNodePos;
                        if (framePos == pos) {
                            frame.mNodePos = newPos;
                            frame.mNotFoundKey = key;
                            continue;
                        }
                        if (framePos > pos) {
                            frame.mNodePos = framePos - 2;
                            continue;
                        }
                        if (framePos >= newPos) continue;
                        frame.mNodePos = framePos + 2;
                    } while ((frame = frame.mPrevCousin) != null);
                    if (!node.shouldLeafMerge()) ** GOTO lbl111
                    this.mergeLeaf(leaf, node);
                    node = null;
                }
                finally {
                    commitLock.releaseShared();
                }
            }
            commitLock = this.commitLock(leaf);
            try {
                node = this.notSplitDirty(leaf);
                pos = leaf.mNodePos;
                if (pos >= 0) {
                    try {
                        if (txn == null) {
                            commitPos = this.mTree.redoStore(key, value);
                        } else if (txn.lockMode() != LockMode.UNSAFE) {
                            node.txnPreUpdateLeafEntry(txn, this.mTree, key, pos);
                            if (txn.mDurabilityMode != DurabilityMode.NO_REDO) {
                                txn.redoStore(this.mTree.mId, key, value);
                            }
                        } else if (txn.mDurabilityMode != DurabilityMode.NO_REDO) {
                            commitPos = this.mTree.redoStoreNoLock(key, value);
                        }
                        node.updateLeafValue(leaf, this.mTree, pos, 0, value);
                    }
                    catch (Throwable e) {
                        node.releaseExclusive();
                        throw e;
                    }
                    if (node.shouldLeafMerge()) {
                        this.mergeLeaf(leaf, node);
                        node = null;
                    } else if (node.mSplit != null) {
                        node = this.mTree.finishSplit(leaf, node);
                    }
                    break block37;
                }
                try {
                    if (txn == null) {
                        commitPos = this.mTree.redoStore(key, value);
                    } else if (txn.lockMode() != LockMode.UNSAFE) {
                        txn.pushUninsert(this.mTree.mId, key);
                        if (txn.mDurabilityMode != DurabilityMode.NO_REDO) {
                            txn.redoStore(this.mTree.mId, key, value);
                        }
                    } else if (txn.mDurabilityMode != DurabilityMode.NO_REDO) {
                        commitPos = this.mTree.redoStoreNoLock(key, value);
                    }
                    node.insertLeafEntry(leaf, this.mTree, ~pos, key, value);
                }
                catch (Throwable e) {
                    node.releaseExclusive();
                    throw e;
                }
                node = this.postInsert(leaf, node, key);
            }
            finally {
                commitLock.releaseShared();
            }
        }
        if (node != null) {
            node.releaseExclusive();
        }
        this.mValue = value;
        if (commitPos != 0L) {
            this.mTree.txnCommitSync(txn, commitPos);
        }
    }

    private Node postInsert(CursorFrame leaf, Node node, byte[] key) throws IOException {
        int newPos;
        int pos = leaf.mNodePos;
        leaf.mNodePos = newPos = ~pos;
        leaf.mNotFoundKey = null;
        CursorFrame frame = node.mLastCursorFrame;
        do {
            if (frame == leaf) continue;
            int framePos = frame.mNodePos;
            if (framePos == pos) {
                byte[] frameKey = frame.mNotFoundKey;
                if (frameKey == null) continue;
                int compare = Utils.compareUnsigned(frameKey, key);
                if (compare > 0) {
                    frame.mNodePos = framePos - 2;
                    continue;
                }
                if (compare != 0) continue;
                frame.mNodePos = newPos;
                frame.mNotFoundKey = null;
                continue;
            }
            if (framePos >= newPos) {
                frame.mNodePos = framePos + 2;
                continue;
            }
            if (framePos >= pos) continue;
            frame.mNodePos = framePos - 2;
        } while ((frame = frame.mPrevCousin) != null);
        if (node.mSplit != null) {
            node = this.mTree.finishSplit(leaf, node);
        }
        return node;
    }

    final void storeFragmented(byte[] value) throws IOException {
        if (this.mKey == null) {
            throw new IllegalStateException("Cursor position is undefined");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        CursorFrame leaf = this.leafExclusive();
        CommitLock commitLock = this.commitLock(leaf);
        try {
            Node node = this.notSplitDirty(leaf);
            int pos = leaf.mNodePos;
            if (pos >= 0) {
                try {
                    node.updateLeafValue(leaf, this.mTree, pos, 64, value);
                }
                catch (Throwable e) {
                    node.releaseExclusive();
                    throw e;
                }
                if (node.mSplit != null) {
                    node = this.mTree.finishSplit(leaf, node);
                }
            } else {
                byte[] key = this.mKey;
                try {
                    node.insertFragmentedLeafEntry(leaf, this.mTree, ~pos, key, value);
                }
                catch (Throwable e) {
                    node.releaseExclusive();
                    throw e;
                }
                node = this.postInsert(leaf, node, key);
            }
            this.mValue = NOT_LOADED;
            node.releaseExclusive();
        }
        catch (Throwable e) {
            throw this.handleException(e, false);
        }
        finally {
            commitLock.releaseShared();
        }
    }

    final Node insertBlank(CursorFrame leaf, Node node, long vlength) throws IOException {
        byte[] key = this.mKey;
        try {
            node.insertBlankLeafEntry(leaf, this.mTree, ~leaf.mNodePos, key, vlength);
        }
        catch (Throwable e) {
            node.releaseExclusive();
            throw e;
        }
        return this.postInsert(leaf, node, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void deleteAll() throws IOException {
        this.reset();
        this.autoload(false);
        this.toFirstNode(this.latchRootNode(), new CursorFrame());
        this.mLeaf.mNode.releaseShared();
        CommitLock commitLock = this.mTree.mDatabase.commitLock();
        while (true) {
            commitLock.acquireShared();
            try {
                this.mLeaf.acquireExclusive();
                Node node = this.notSplitDirty(this.mLeaf);
                if (node.hasKeys()) {
                    try {
                        node.deleteLeafEntry(0);
                    }
                    catch (Throwable e) {
                        node.releaseExclusive();
                        throw e;
                    }
                }
                if (node.hasKeys()) {
                    node.releaseExclusive();
                    continue;
                }
                if (this.deleteNode(this.mLeaf, node)) continue;
                this.mLeaf = null;
                this.reset();
                return;
            }
            finally {
                commitLock.releaseShared();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteNode(CursorFrame frame, Node node) throws IOException {
        node.mLastCursorFrame = null;
        LocalDatabase db = this.mTree.mDatabase;
        db.prepareToDelete(node);
        if (node == this.mTree.mRoot) {
            try {
                node.asTrimmedRoot();
            }
            finally {
                node.releaseExclusive();
            }
            return false;
        }
        CursorFrame parentFrame = frame.mParentFrame;
        Node parentNode = parentFrame.acquireExclusive();
        if (parentNode.hasKeys()) {
            parentNode.deleteLeftChildRef(0);
        } else {
            if (!this.deleteNode(parentFrame, parentNode)) {
                db.deleteNode(node);
                return false;
            }
            parentNode = parentFrame.acquireExclusive();
        }
        Node next = this.latchChildRetainParentEx(parentNode, 0);
        try {
            if (db.markDirty(this.mTree, next)) {
                parentNode.updateChildRefId(0, next.mId);
            }
        }
        finally {
            parentNode.releaseExclusive();
        }
        frame.mNode = next;
        frame.mNodePos = 0;
        next.mLastCursorFrame = frame;
        next.type((byte)(next.type() | 2));
        next.releaseExclusive();
        db.deleteNode(node);
        return true;
    }

    private int randomPosition(Random rnd, Node node, byte[] lowKey, byte[] highKey) throws IOException {
        int pos = 0;
        if (highKey == null) {
            pos = node.highestPos() + 2;
        } else {
            pos = node.binarySearch(highKey);
            if (pos < 0) {
                pos ^= 0xFFFFFFFF;
            }
            if (!node.isLeaf()) {
                pos += 2;
            }
        }
        if (lowKey == null) {
            if (pos > 0) {
                pos = pos == 2 ? 0 : rnd.nextInt(pos >> 1) << 1;
                return pos;
            }
        } else {
            int lowPos = node.binarySearch(lowKey);
            if (!node.isLeaf()) {
                lowPos = Node.internalPos(lowPos);
            } else if (lowPos < 0) {
                lowPos ^= 0xFFFFFFFF;
            }
            int range = pos - lowPos;
            if (range > 0) {
                pos = range == 2 ? lowPos : lowPos + (rnd.nextInt(range >> 1) << 1);
                return pos;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRangeEmpty(byte[] lowKey, byte[] highKey) throws IOException {
        boolean oldKeyOnly = this.mKeyOnly;
        LocalTransaction oldTxn = this.mTxn;
        try {
            this.mTxn = LocalTransaction.BOGUS;
            this.mKeyOnly = true;
            if (lowKey == null) {
                this.first();
            } else {
                this.findGe(lowKey);
            }
            if (this.mKey == null || highKey != null && Utils.compareUnsigned(this.mKey, highKey) >= 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.reset();
            this.mKeyOnly = oldKeyOnly;
            this.mTxn = oldTxn;
        }
    }

    final CommitLock commitLock(CursorFrame leaf) {
        CommitLock commitLock = this.mTree.mDatabase.commitLock();
        if (!commitLock.tryAcquireShared()) {
            leaf.mNode.releaseExclusive();
            commitLock.acquireShared();
            leaf.acquireExclusive();
        }
        return commitLock;
    }

    protected final IOException handleException(Throwable e, boolean reset) throws IOException {
        DatabaseException de;
        if (this.mLeaf == null && e instanceof IllegalStateException) {
            if (reset) {
                this.reset();
            }
            throw (IllegalStateException)e;
        }
        if (e instanceof DatabaseException && (de = (DatabaseException)e).isRecoverable()) {
            if (reset) {
                this.reset();
            }
            throw de;
        }
        try {
            throw Utils.closeOnFailure(this.mTree.mDatabase, e);
        }
        catch (Throwable throwable) {
            this.reset();
            throw throwable;
        }
    }

    @Override
    public final TreeCursor copy() {
        TreeCursor copy = this.copyNoValue();
        copy.mKeyOnly = this.mKeyOnly;
        if (!copy.mKeyOnly) {
            copy.mValue = Utils.cloneArray(this.mValue);
        }
        return copy;
    }

    private TreeCursor copyNoValue() {
        TreeCursor copy = new TreeCursor(this.mTree, this.mTxn);
        CursorFrame frame = this.mLeaf;
        if (frame != null) {
            CursorFrame frameCopy = new CursorFrame();
            frame.copyInto(frameCopy);
            copy.mLeaf = frameCopy;
        }
        copy.mKey = this.mKey;
        copy.mKeyHash = this.mKeyHash;
        return copy;
    }

    private Node latchRootNode() {
        Node root = this.mTree.mRoot;
        root.acquireShared();
        return root;
    }

    @Override
    public final void reset() {
        this.mKey = null;
        this.mKeyHash = 0;
        this.mValue = null;
        CursorFrame frame = this.mLeaf;
        this.mLeaf = null;
        if (frame != null) {
            CursorFrame.popAll(frame);
        }
    }

    private void resetLatched(Node node) {
        node.releaseShared();
        this.reset();
    }

    private RuntimeException cleanup(Throwable e, CursorFrame frame) {
        this.mLeaf = frame;
        this.reset();
        return Utils.rethrow(e);
    }

    @Override
    public final void close() {
        this.reset();
    }

    @Override
    public final void close(Throwable cause) {
        try {
            DatabaseException de;
            if (cause instanceof DatabaseException && (de = (DatabaseException)cause).isRecoverable()) {
                return;
            }
            try {
                throw Utils.closeOnFailure(this.mTree.mDatabase, cause);
            }
            catch (IOException iOException) {
            }
        }
        finally {
            this.reset();
        }
    }

    final int height() {
        int height = 0;
        CursorFrame frame = this.mLeaf;
        while (frame != null) {
            ++height;
            frame = frame.mParentFrame;
        }
        return height;
    }

    final void nextNode() throws IOException {
        this.mLeaf.mNodePos = 0x7FFFFFFE;
        this.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    final boolean compact(long highestNodeId, CompactionObserver observer) throws IOException {
        height = this.height();
        frameNodes = new Node[height];
        frame = this.mLeaf;
        while (true) {
            block21: {
                for (level = 0; level < height; ++level) {
                    node = frame.acquireShared();
                    if (frameNodes[level] == node) {
                        node.releaseShared();
                        break;
                    }
                    frameNodes[level] = node;
                    id = this.compactFrame(highestNodeId, frame, node);
                    if (id > highestNodeId) {
                        return false;
                    }
                    try {
                        if (!observer.indexNodeVisited(id)) {
                            return false;
                        }
                    }
                    catch (Throwable e) {
                        Utils.uncaught(e);
                        return false;
                    }
                    frame = frame.mParentFrame;
                }
                frame = this.leafSharedNotSplit();
                node = frame.mNode;
                end = node.highestLeafPos();
                pos = frame.mNodePos;
                if (pos < 0) {
                    pos ^= -1;
                }
                while (pos <= end) {
                    if (!node.isFragmentedLeafValue(pos)) {
                        pos += 2;
                        continue;
                    }
                    break block21;
                }
                node.releaseShared();
                this.nextNode();
                frame = this.mLeaf;
                if (frame != null) ** continue;
                return true;
            }
            do {
                block22: {
                    try {
                        nodePos = frame.mNodePos;
                        if (nodePos < 0 || !node.isFragmentedLeafValue(nodePos)) break block22;
                        pLen = this.pageSize(node.mPage);
                        stream = new TreeValueStream(this);
                        pos = 0L;
                        while (true) {
                            if ((result = stream.compactCheck(frame, pos, highestNodeId)) < 0) {
                                break;
                            }
                            if (result > 0) {
                                node.releaseShared();
                                node = null;
                                stream.doWrite(pos, TreeValueStream.TOUCH_VALUE, 0, 0);
                                frame = this.leafSharedNotSplit();
                                node = frame.mNode;
                                if (node.mId > highestNodeId) {
                                    var14_18 = false;
                                    return var14_18;
                                }
                            }
                            pos += (long)pLen;
                        }
                    }
                    finally {
                        if (node != null) {
                            node.releaseShared();
                        }
                    }
                }
                this.next();
                if (this.mLeaf == null) {
                    return true;
                }
                frame = this.leafSharedNotSplit();
            } while ((next = frame.mNode) == node);
            next.releaseShared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long compactFrame(long highestNodeId, CursorFrame frame, Node node) throws IOException {
        long id = node.mId;
        node.releaseShared();
        if (id > highestNodeId) {
            LocalDatabase db = this.mTree.mDatabase;
            CommitLock commitLock = db.commitLock();
            commitLock.acquireShared();
            try {
                node = frame.acquireExclusive();
                id = node.mId;
                if (id > highestNodeId) {
                    node = this.notSplitDirty(frame);
                    id = node.mId;
                }
                node.releaseExclusive();
            }
            finally {
                commitLock.releaseShared();
            }
        }
        return id;
    }

    public final boolean equalPositions(TreeCursor other) {
        if (this == other) {
            return true;
        }
        CursorFrame thisFrame = this.mLeaf;
        CursorFrame otherFrame = other.mLeaf;
        while (thisFrame != null) {
            if (otherFrame == null) {
                return false;
            }
            if (thisFrame.mNode != otherFrame.mNode) {
                return false;
            }
            if (thisFrame.mNodePos != otherFrame.mNodePos) {
                return false;
            }
            thisFrame = thisFrame.mParentFrame;
            otherFrame = otherFrame.mParentFrame;
        }
        return otherFrame == null;
    }

    public final boolean verifyExtremities(byte extremity) throws IOException {
        Node node = this.latchRootNode();
        try {
            while (true) {
                boolean bl;
                if ((node.type() & extremity) == 0) {
                    bl = false;
                    return bl;
                }
                if (node.isLeaf()) {
                    bl = true;
                    return bl;
                }
                int pos = 0;
                if (extremity == 8) {
                    pos = node.highestInternalPos();
                }
                node = this.latchToChild(node, pos);
            }
        }
        finally {
            node.releaseShared();
        }
    }

    final boolean verify(int height, VerificationObserver observer) throws IOException {
        if (height > 0) {
            Node[] stack = new Node[height];
            while (this.key() != null) {
                if (!this.verifyFrames(height, stack, this.mLeaf, observer)) {
                    return false;
                }
                this.nextNode();
            }
        }
        return true;
    }

    private boolean verifyFrames(int level, Node[] stack, CursorFrame frame, VerificationObserver observer) throws IOException {
        CursorFrame parentFrame = frame.mParentFrame;
        if (parentFrame != null) {
            Node parentNode = parentFrame.mNode;
            int parentLevel = level - 1;
            if (parentLevel > 0 && stack[parentLevel] != parentNode) {
                parentNode = parentFrame.acquireShared();
                parentNode.releaseShared();
                if (stack[parentLevel] != parentNode) {
                    stack[parentLevel] = parentNode;
                    if (!this.verifyFrames(parentLevel, stack, parentFrame, observer)) {
                        return false;
                    }
                }
            }
            parentNode = parentFrame.acquireShared();
            Node childNode = frame.acquireShared();
            long childId = childNode.mId;
            if (!childNode.hasKeys() || !parentNode.hasKeys()) {
                childNode.releaseShared();
                parentNode.releaseShared();
            } else {
                boolean left;
                int childPos;
                int parentPos = parentFrame.mNodePos;
                if (parentPos >= parentNode.highestInternalPos()) {
                    parentPos = parentNode.highestKeyPos();
                    childPos = 0;
                    left = false;
                } else {
                    childPos = childNode.highestKeyPos();
                    left = true;
                }
                byte[] parentKey = parentNode.retrieveKey(parentPos);
                byte[] childKey = childNode.retrieveKey(childPos);
                childNode.releaseShared();
                parentNode.releaseShared();
                int compare = Utils.compareUnsigned(childKey, parentKey);
                if (left) {
                    if (compare >= 0) {
                        observer.failed = true;
                        if (!observer.indexNodeFailed(childId, level, "Child keys are not less than parent key: " + parentNode)) {
                            return false;
                        }
                    }
                } else if (childNode.isInternal()) {
                    if (compare <= 0) {
                        observer.failed = true;
                        if (!observer.indexNodeFailed(childId, level, "Internal child keys are not greater than parent key: " + parentNode)) {
                            return false;
                        }
                    }
                } else if (compare < 0) {
                    observer.failed = true;
                    if (!observer.indexNodeFailed(childId, level, "Child keys are not greater than or equal to parent key: " + parentNode)) {
                        return false;
                    }
                }
            }
            switch (parentNode.type()) {
                case 100: {
                    if (!childNode.isLeaf()) break;
                    observer.failed = true;
                    if (observer.indexNodeFailed(childId, level, "Child is a leaf, but parent is a regular internal node: " + parentNode)) break;
                    return false;
                }
                case 116: {
                    if (childNode.isLeaf()) break;
                    observer.failed = true;
                    if (observer.indexNodeFailed(childId, level, "Child is not a leaf, but parent is a bottom internal node: " + parentNode)) break;
                    return false;
                }
                default: {
                    if (!parentNode.isLeaf()) break;
                }
                case -128: {
                    observer.failed = true;
                    if (observer.indexNodeFailed(childId, level, "Child parent is a leaf node: " + parentNode)) break;
                    return false;
                }
            }
            if ((childNode.type() & 2) != 0 && (parentNode.type() & 2) == 0) {
                observer.failed = true;
                if (!observer.indexNodeFailed(childId, level, "Child is low extremity but parent is not: " + parentNode)) {
                    return false;
                }
            }
            if ((childNode.type() & 8) != 0 && (parentNode.type() & 8) == 0) {
                observer.failed = true;
                if (!observer.indexNodeFailed(childId, level, "Child is high extremity but parent is not: " + parentNode)) {
                    return false;
                }
            }
        }
        return frame.acquireShared().verifyTreeNode(level, observer);
    }

    private CursorFrame leaf() {
        CursorFrame leaf = this.mLeaf;
        if (leaf == null) {
            throw new IllegalStateException("Cursor position is undefined");
        }
        return leaf;
    }

    protected final CursorFrame leafExclusive() {
        CursorFrame leaf = this.leaf();
        leaf.acquireExclusive();
        return leaf;
    }

    final CursorFrame leafExclusiveNotSplit() throws IOException {
        CursorFrame leaf = this.leaf();
        Node node = leaf.acquireExclusive();
        if (node.mSplit != null) {
            this.mTree.finishSplit(leaf, node);
        }
        return leaf;
    }

    final CursorFrame leafSharedNotSplit() throws IOException {
        CursorFrame leaf = this.leaf();
        Node node = leaf.acquireShared();
        if (node.mSplit != null) {
            this.finishSplitShared(leaf, node);
        }
        return leaf;
    }

    final Node finishSplitShared(CursorFrame frame, Node node) throws IOException {
        block3: {
            block2: {
                if (node.tryUpgrade()) break block2;
                node.releaseShared();
                node = frame.acquireExclusive();
                if (node.mSplit == null) break block3;
            }
            node = this.mTree.finishSplit(frame, node);
        }
        node.downgrade();
        return node;
    }

    final Node notSplitDirty(CursorFrame frame) throws IOException {
        Node node = frame.mNode;
        while (node.mSplit == null) {
            LocalDatabase db = this.mTree.mDatabase;
            if (!db.shouldMarkDirty(node)) {
                return node;
            }
            CursorFrame parentFrame = frame.mParentFrame;
            if (parentFrame == null) {
                try {
                    db.doMarkDirty(this.mTree, node);
                    return node;
                }
                catch (Throwable e) {
                    node.releaseExclusive();
                    throw e;
                }
            }
            Node parentNode = parentFrame.tryAcquireExclusive();
            if (parentNode != null) {
                if (parentNode.mSplit == null && !db.shouldMarkDirty(parentNode)) {
                    try {
                        db.doMarkDirty(this.mTree, node);
                        parentNode.updateChildRefId(parentFrame.mNodePos, node.mId);
                        Node node2 = node;
                        return node2;
                    }
                    catch (Throwable e) {
                        node.releaseExclusive();
                        throw e;
                    }
                    finally {
                        parentNode.releaseExclusive();
                    }
                }
                node.releaseExclusive();
            } else {
                node.releaseExclusive();
                parentFrame.acquireExclusive();
            }
            this.notSplitDirty(parentFrame).releaseExclusive();
            node = frame.acquireExclusive();
        }
        return this.mTree.finishSplit(frame, node);
    }

    private void mergeLeaf(CursorFrame leaf, Node node) throws IOException {
        int leftPos;
        int rightAvail;
        Node rightNode;
        int nodeAvail;
        Node leftNode;
        CursorFrame parentFrame = leaf.mParentFrame;
        node.releaseExclusive();
        if (parentFrame == null) {
            return;
        }
        Node parentNode = parentFrame.acquireExclusive();
        while (true) {
            if (parentNode.mSplit != null) {
                parentNode = this.mTree.finishSplit(parentFrame, parentNode);
            }
            if (!parentNode.hasKeys()) {
                parentNode.releaseExclusive();
                return;
            }
            int pos = parentFrame.mNodePos;
            if (pos == 0) {
                leftNode = null;
            } else {
                leftNode = this.latchChildRetainParentEx(parentNode, pos - 2);
                if (leftNode.mSplit != null) {
                    parentNode.insertSplitChildRef(parentFrame, this.mTree, pos - 2, leftNode);
                    continue;
                }
            }
            node = leaf.acquireExclusive();
            nodeAvail = node.availableLeafBytes();
            if (!node.shouldMerge(nodeAvail)) {
                if (leftNode != null) {
                    leftNode.releaseExclusive();
                }
                node.releaseExclusive();
                parentNode.releaseExclusive();
                return;
            }
            if (pos >= parentNode.highestInternalPos()) {
                rightNode = null;
                break;
            }
            try {
                rightNode = this.latchChildRetainParentEx(parentNode, pos + 2);
            }
            catch (Throwable e) {
                if (leftNode != null) {
                    leftNode.releaseExclusive();
                }
                node.releaseExclusive();
                throw e;
            }
            if (rightNode.mSplit == null) break;
            if (leftNode != null) {
                leftNode.releaseExclusive();
            }
            node.releaseExclusive();
            parentNode.insertSplitChildRef(parentFrame, this.mTree, pos + 2, rightNode);
        }
        int leftAvail = leftNode == null ? -1 : leftNode.availableLeafBytes();
        int n = rightAvail = rightNode == null ? -1 : rightNode.availableLeafBytes();
        if (leftAvail < rightAvail) {
            if (leftNode != null) {
                leftNode.releaseExclusive();
            }
            leftPos = parentFrame.mNodePos;
            leftNode = node;
            leftAvail = nodeAvail;
        } else {
            if (rightNode != null) {
                rightNode.releaseExclusive();
            }
            leftPos = parentFrame.mNodePos - 2;
            rightNode = node;
            rightAvail = nodeAvail;
        }
        int remaining = leftAvail + rightAvail - this.pageSize(node.mPage) + 12;
        if (remaining >= 0) {
            try {
                if (this.mTree.markDirty(leftNode)) {
                    parentNode.updateChildRefId(leftPos, leftNode.mId);
                }
            }
            catch (Throwable e) {
                leftNode.releaseExclusive();
                rightNode.releaseExclusive();
                parentNode.releaseExclusive();
                throw e;
            }
            try {
                Node.moveLeafToLeftAndDelete(this.mTree, leftNode, rightNode);
            }
            catch (Throwable e) {
                leftNode.releaseExclusive();
                parentNode.releaseExclusive();
                throw e;
            }
            rightNode = null;
            parentNode.deleteRightChildRef(leftPos + 2);
        }
        this.mergeInternal(parentFrame, parentNode, leftNode, rightNode);
    }

    private void mergeInternal(CursorFrame frame, Node node, Node leftChildNode, Node rightChildNode) throws IOException {
        int leftPos;
        int rightAvail;
        Node rightNode;
        int nodeAvail;
        Node leftNode;
        if (node.shouldInternalMerge()) {
            if (!node.hasKeys() && node == this.mTree.mRoot) {
                if (rightChildNode != null) {
                    throw new AssertionError();
                }
                node.rootDelete(this.mTree, leftChildNode);
                return;
            }
        } else {
            if (rightChildNode != null) {
                rightChildNode.releaseExclusive();
            }
            leftChildNode.releaseExclusive();
            node.releaseExclusive();
            return;
        }
        if (rightChildNode != null) {
            rightChildNode.releaseExclusive();
        }
        leftChildNode.releaseExclusive();
        CursorFrame parentFrame = frame.mParentFrame;
        node.releaseExclusive();
        if (parentFrame == null) {
            return;
        }
        Node parentNode = parentFrame.acquireExclusive();
        if (parentNode.isLeaf()) {
            throw new AssertionError((Object)"Parent node is a leaf");
        }
        while (true) {
            if (parentNode.mSplit != null) {
                parentNode = this.mTree.finishSplit(parentFrame, parentNode);
            }
            if (!parentNode.hasKeys()) {
                parentNode.releaseExclusive();
                return;
            }
            int pos = parentFrame.mNodePos;
            if (pos == 0) {
                leftNode = null;
            } else {
                leftNode = this.latchChildRetainParentEx(parentNode, pos - 2);
                if (leftNode.mSplit != null) {
                    parentNode.insertSplitChildRef(parentFrame, this.mTree, pos - 2, leftNode);
                    continue;
                }
            }
            node = frame.acquireExclusive();
            nodeAvail = node.availableInternalBytes();
            if (!node.shouldMerge(nodeAvail)) {
                if (leftNode != null) {
                    leftNode.releaseExclusive();
                }
                node.releaseExclusive();
                parentNode.releaseExclusive();
                return;
            }
            if (pos >= parentNode.highestInternalPos()) {
                rightNode = null;
                break;
            }
            try {
                rightNode = this.latchChildRetainParentEx(parentNode, pos + 2);
            }
            catch (Throwable e) {
                if (leftNode != null) {
                    leftNode.releaseExclusive();
                }
                node.releaseExclusive();
                throw e;
            }
            if (rightNode.mSplit == null) break;
            if (leftNode != null) {
                leftNode.releaseExclusive();
            }
            node.releaseExclusive();
            parentNode.insertSplitChildRef(parentFrame, this.mTree, pos + 2, rightNode);
        }
        int leftAvail = leftNode == null ? -1 : leftNode.availableInternalBytes();
        int n = rightAvail = rightNode == null ? -1 : rightNode.availableInternalBytes();
        if (leftAvail < rightAvail) {
            if (leftNode != null) {
                leftNode.releaseExclusive();
            }
            leftPos = parentFrame.mNodePos;
            leftNode = node;
            leftAvail = nodeAvail;
        } else {
            if (rightNode != null) {
                rightNode.releaseExclusive();
            }
            leftPos = parentFrame.mNodePos - 2;
            rightNode = node;
            rightAvail = nodeAvail;
        }
        byte[] parentPage = parentNode.mPage;
        int parentEntryLoc = PageOps.p_ushortGetLE(parentPage, parentNode.searchVecStart() + leftPos);
        int parentEntryLen = Node.keyLengthAtLoc(parentPage, parentEntryLoc);
        int remaining = leftAvail - parentEntryLen + rightAvail - this.pageSize(parentPage) + 10;
        if (remaining >= 0) {
            try {
                if (this.mTree.markDirty(leftNode)) {
                    parentNode.updateChildRefId(leftPos, leftNode.mId);
                }
            }
            catch (Throwable e) {
                leftNode.releaseExclusive();
                rightNode.releaseExclusive();
                parentNode.releaseExclusive();
                throw e;
            }
            try {
                Node.moveInternalToLeftAndDelete(this.mTree, leftNode, rightNode, parentPage, parentEntryLoc, parentEntryLen);
            }
            catch (Throwable e) {
                leftNode.releaseExclusive();
                parentNode.releaseExclusive();
                throw e;
            }
            rightNode = null;
            parentNode.deleteRightChildRef(leftPos + 2);
        }
        this.mergeInternal(parentFrame, parentNode, leftNode, rightNode);
    }

    private int pageSize(byte[] page) {
        return page.length;
    }

    private Node latchToChild(Node parent, int childPos) throws IOException {
        return this.latchChild(parent, childPos, 1);
    }

    private Node latchChildRetainParent(Node parent, int childPos) throws IOException {
        return this.latchChild(parent, childPos, 0);
    }

    private Node latchChild(Node parent, int childPos, int options) throws IOException {
        long childId;
        block4: {
            Node childNode;
            block9: {
                block6: {
                    block7: {
                        block8: {
                            block5: {
                                childId = parent.retrieveChildRefId(childPos);
                                childNode = this.mTree.mDatabase.nodeMapGet(childId);
                                if (childNode == null) break block4;
                                childNode.acquireShared();
                                if (childId == childNode.mId) break block5;
                                childNode.releaseShared();
                                break block4;
                            }
                            if (childNode.mCachedState == 0 || parent.mCachedState != 0 || childNode.mLastCursorFrame != null) break block6;
                            if (childNode.tryUpgrade()) break block7;
                            childNode.releaseShared();
                            childNode = this.mTree.mDatabase.nodeMapGet(childId);
                            if (childNode == null) break block4;
                            childNode.acquireExclusive();
                            if (childId == childNode.mId) break block8;
                            childNode.releaseExclusive();
                            break block4;
                        }
                        if (childNode.mCachedState != 0 && childNode.mLastCursorFrame == null) break block7;
                        childNode.downgrade();
                        break block6;
                    }
                    if ((options & 1) != 0) {
                        parent.releaseShared();
                    }
                    try {
                        childNode.write(this.mTree.mDatabase.mPageDb);
                    }
                    catch (Throwable e) {
                        childNode.releaseExclusive();
                        throw e;
                    }
                    childNode.mCachedState = 0;
                    childNode.downgrade();
                    break block9;
                }
                if ((options & 1) != 0) {
                    parent.releaseShared();
                }
            }
            childNode.used();
            return childNode;
        }
        return parent.loadChild(this.mTree.mDatabase, childId, options);
    }

    private Node latchChildRetainParentEx(Node parent, int childPos) throws IOException {
        long childId = parent.retrieveChildRefId(childPos);
        Node childNode = this.mTree.mDatabase.nodeMapGet(childId);
        if (childNode != null) {
            childNode.acquireExclusive();
            if (childId != childNode.mId) {
                childNode.releaseExclusive();
            } else {
                if (childNode.mCachedState != 0 && parent.mCachedState == 0 && childNode.mLastCursorFrame == null) {
                    try {
                        childNode.write(this.mTree.mDatabase.mPageDb);
                    }
                    catch (Throwable e) {
                        childNode.releaseExclusive();
                        throw e;
                    }
                    childNode.mCachedState = 0;
                }
                childNode.used();
                return childNode;
            }
        }
        return parent.loadChild(this.mTree.mDatabase, childId, 4);
    }
}

