/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.cojen.tupl.ShutdownHook;
import org.cojen.tupl.Utils;
import org.cojen.tupl.io.CauseCloseable;
import org.cojen.tupl.io.FileFactory;

final class TempFileManager
implements CauseCloseable,
ShutdownHook {
    private File mBaseFile;
    private final FileFactory mFileFactory;
    private long mCount;
    private Map<File, Closeable> mFiles;
    private Throwable mCause;

    TempFileManager(File baseFile, FileFactory factory) throws IOException {
        this.mBaseFile = baseFile;
        this.mFileFactory = factory;
        Utils.deleteNumberedFiles(baseFile, ".temp.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File createTempFile() throws IOException {
        while (true) {
            File file;
            TempFileManager tempFileManager = this;
            synchronized (tempFileManager) {
                if (this.mBaseFile == null) {
                    throw new IOException("Shutting down", this.mCause);
                }
                file = new File(this.mBaseFile.getPath() + ".temp." + this.mCount++);
                if (this.mFiles == null) {
                    this.mFiles = new HashMap<File, Closeable>(4);
                }
                if (this.mFiles.containsKey(file)) {
                    continue;
                }
                this.mFiles.put(file, null);
            }
            if (this.mFileFactory == null ? file.createNewFile() : this.mFileFactory.createFile(file)) {
                return file;
            }
            tempFileManager = this;
            synchronized (tempFileManager) {
                this.mFiles.remove(file);
            }
        }
    }

    synchronized void register(File file, Closeable c) throws IOException {
        if (this.mFiles == null || !this.mFiles.containsKey(file)) {
            if (this.mBaseFile == null) {
                throw new IOException("Shutting down", this.mCause);
            }
            return;
        }
        if (this.mFiles.get(file) != null) {
            throw new IllegalStateException();
        }
        this.mFiles.put(file, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteTempFile(File file) {
        Closeable c;
        TempFileManager tempFileManager = this;
        synchronized (tempFileManager) {
            if (this.mFiles == null || !this.mFiles.containsKey(file)) {
                return;
            }
            c = this.mFiles.remove(file);
        }
        Utils.closeQuietly(null, c);
        file.delete();
    }

    @Override
    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Throwable cause) {
        HashMap<File, Closeable> files;
        Iterator iterator = this;
        synchronized (iterator) {
            this.mBaseFile = null;
            if (cause != null) {
                this.mCause = cause;
            }
            if (this.mFiles == null) {
                files = null;
            } else {
                files = new HashMap<File, Closeable>(this.mFiles);
                this.mFiles = null;
            }
        }
        if (files != null) {
            for (Closeable c : files.values()) {
                Utils.closeQuietly(null, c, cause);
            }
            for (File f : files.keySet()) {
                f.delete();
            }
        }
    }

    @Override
    public void shutdown() {
        this.close();
    }
}

