/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import org.cojen.tupl.EventListener;
import org.cojen.tupl.RedoWriter;
import org.cojen.tupl.ReplRedoEngine;
import org.cojen.tupl.ReplRedoWriter;
import org.cojen.tupl.UnmodifiableReplicaException;
import org.cojen.tupl.ext.ReplicationManager;

final class ReplRedoController
extends ReplRedoWriter {
    private final ReplicationManager mManager;
    private volatile ReplRedoWriter mTxnRedoWriter;
    private ReplRedoWriter mCheckpointRedoWriter;
    private long mCheckpointPos;
    private long mCheckpointTxnId;
    private long mCheckpointNum;

    ReplRedoController(ReplRedoEngine engine) {
        super(engine, null);
        this.mManager = engine.mManager;
        this.mTxnRedoWriter = this;
    }

    synchronized void initCheckpointNumber(long num) {
        this.mCheckpointNum = num;
    }

    public void recover(long initialTxnId, EventListener listener) throws IOException {
        this.mEngine.startReceiving(this.mManager.readPosition(), initialTxnId);
        this.mManager.recover(listener);
    }

    @Override
    public RedoWriter txnRedoWriter() {
        return this.mTxnRedoWriter;
    }

    @Override
    synchronized boolean shouldCheckpoint(long sizeThreshold) {
        ReplicationManager.Writer writer = this.mTxnRedoWriter.mReplWriter;
        long pos = writer == null ? this.mEngine.mDecodePosition : writer.position();
        return pos - this.mCheckpointPos >= sizeThreshold;
    }

    @Override
    void checkpointPrepare() throws IOException {
        this.mEngine.suspend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void checkpointSwitch() throws IOException {
        ++this.mCheckpointNum;
        if (this.mCheckpointPos == 0L && this.mCheckpointTxnId == 0L) {
            ReplRedoWriter redo;
            this.mCheckpointRedoWriter = redo = this.mTxnRedoWriter;
            ReplicationManager.Writer writer = redo.mReplWriter;
            if (writer == null) {
                this.mCheckpointPos = this.mEngine.mDecodePosition;
                this.mCheckpointTxnId = this.mEngine.mDecodeTransactionId;
            } else {
                ReplRedoWriter replRedoWriter = redo;
                synchronized (replRedoWriter) {
                    this.mCheckpointPos = redo.mLastCommitPos;
                    this.mCheckpointTxnId = redo.mLastCommitTxnId;
                }
            }
        }
    }

    @Override
    long checkpointNumber() {
        return this.mCheckpointNum;
    }

    @Override
    long checkpointPosition() {
        return this.mCheckpointPos;
    }

    @Override
    long checkpointTransactionId() {
        return this.mCheckpointTxnId;
    }

    @Override
    void checkpointAborted() {
        this.mEngine.resume();
        this.mCheckpointRedoWriter = null;
    }

    @Override
    void checkpointStarted() throws IOException {
        this.mEngine.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void checkpointFlushed() throws IOException {
        block10: {
            ReplRedoWriter redo = this.mCheckpointRedoWriter;
            ReplicationManager.Writer writer = redo.mReplWriter;
            if (writer != null) {
                if (writer.confirm(this.mCheckpointPos, -1L)) {
                    ReplRedoWriter replRedoWriter = redo;
                    synchronized (replRedoWriter) {
                        if (this.mCheckpointPos > redo.mConfirmedPos) {
                            redo.mConfirmedPos = this.mCheckpointPos;
                            redo.mConfirmedTxnId = this.mCheckpointTxnId;
                        }
                    }
                }
                ReplRedoWriter replRedoWriter = redo;
                synchronized (replRedoWriter) {
                    long confirmedPos = redo.mConfirmedPos;
                    if (confirmedPos >= this.mCheckpointPos) {
                        break block10;
                    }
                    this.mCheckpointPos = confirmedPos;
                    this.mCheckpointTxnId = redo.mConfirmedTxnId;
                }
                throw this.unmodifiable(writer);
            }
        }
        this.mManager.syncConfirm(this.mCheckpointPos, -1L);
    }

    @Override
    void checkpointFinished() throws IOException {
        this.mManager.checkpointed(this.mCheckpointPos);
        this.mCheckpointRedoWriter = null;
        this.mCheckpointPos = 0L;
        this.mCheckpointTxnId = 0L;
    }

    @Override
    void opWriteCheck() throws IOException {
        throw new UnmodifiableReplicaException();
    }

    @Override
    long adjustTransactionId(long txnId) {
        return -txnId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void force(boolean metadata) throws IOException {
        if (metadata) {
            long pos;
            ReplRedoWriter redo = this.mTxnRedoWriter;
            if (redo.mReplWriter == null) {
                pos = this.mEngine.mDecodePosition;
            } else {
                ReplRedoWriter replRedoWriter = redo;
                synchronized (replRedoWriter) {
                    pos = redo.mLastCommitPos;
                }
            }
            try {
                this.mEngine.mManager.syncConfirm(pos);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mEngine.mManager.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void leaderNotify() throws UnmodifiableReplicaException, IOException {
        ReplRedoWriter redo;
        ReplicationManager.Writer writer = this.mTxnRedoWriter.mReplWriter;
        if (writer != null) {
            return;
        }
        this.mManager.flip();
        writer = this.mManager.writer();
        if (writer == null) {
            return;
        }
        ReplRedoWriter replRedoWriter = redo = new ReplRedoWriter(this.mEngine, writer);
        synchronized (replRedoWriter) {
            this.mTxnRedoWriter = redo;
            redo.mConfirmedPos = redo.mLastCommitPos = writer.position();
            redo.mLastCommitTxnId = 0L;
            redo.mConfirmedTxnId = 0L;
            redo.clearAndReset();
            redo.timestamp();
            redo.nopRandom();
            redo.flush();
        }
    }

    UnmodifiableReplicaException unmodifiable(ReplicationManager.Writer expect) {
        this.switchToReplica(expect, false);
        return new UnmodifiableReplicaException();
    }

    boolean switchToReplica(ReplicationManager.Writer expect, boolean syncd) {
        ReplRedoWriter redo = this.mTxnRedoWriter;
        ReplicationManager.Writer writer = redo.mReplWriter;
        if (writer == null || writer != expect) {
            return false;
        }
        if (syncd) {
            this.mManager.flip();
            this.mTxnRedoWriter = this;
        } else {
            new Thread(() -> {
                ReplRedoController replRedoController = this;
                synchronized (replRedoController) {
                    if (!this.switchToReplica(expect, true)) {
                        return;
                    }
                }
                long pos = this.mManager.readPosition();
                redo.flipped(pos);
                this.mEngine.startReceiving(pos, 0L);
            }).start();
        }
        return true;
    }
}

