/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.File;
import java.io.PrintStream;
import java.util.Date;
import org.cojen.tupl.RedoLog;
import org.cojen.tupl.RedoVisitor;

class RedoPrinter
implements RedoVisitor {
    private static final int MAX_VALUE = 1000;
    private final PrintStream mOut = System.out;

    public static void main(String[] args) throws Exception {
        File baseFile = new File(args[0]);
        long logId = Long.parseLong(args[1]);
        new RedoLog(null, baseFile, null, logId, 0L, true).replay(new RedoPrinter(), null, null, null);
    }

    RedoPrinter() {
    }

    @Override
    public boolean reset() {
        this.mOut.println("reset");
        return true;
    }

    @Override
    public boolean timestamp(long timestamp) {
        this.mOut.println("timestamp: " + this.toDateTime(timestamp));
        return true;
    }

    @Override
    public boolean shutdown(long timestamp) {
        this.mOut.println("shutdown: " + this.toDateTime(timestamp));
        return true;
    }

    @Override
    public boolean close(long timestamp) {
        this.mOut.println("close: " + this.toDateTime(timestamp));
        return true;
    }

    @Override
    public boolean endFile(long timestamp) {
        this.mOut.println("endFile: " + this.toDateTime(timestamp));
        return true;
    }

    @Override
    public boolean store(long indexId, byte[] key, byte[] value) {
        this.mOut.println("store: indexId=" + indexId + ", key=" + this.toHex(key) + ", value=" + this.toHex(value));
        return true;
    }

    @Override
    public boolean storeNoLock(long indexId, byte[] key, byte[] value) {
        this.mOut.println("storeNoLock: indexId=" + indexId + ", key=" + this.toHex(key) + ", value=" + this.toHex(value));
        return true;
    }

    @Override
    public boolean renameIndex(long txnId, long indexId, byte[] newName) {
        this.mOut.println("renameIndex: txnId=" + txnId + ", indexId=" + indexId + ", newName=" + this.toHex(newName));
        return true;
    }

    @Override
    public boolean deleteIndex(long txnId, long indexId) {
        this.mOut.println("deleteIndex: txnId=" + txnId + ", indexId=" + indexId);
        return true;
    }

    @Override
    public boolean txnEnter(long txnId) {
        this.mOut.println("txnEnter: txnId=" + txnId);
        return true;
    }

    @Override
    public boolean txnRollback(long txnId) {
        this.mOut.println("txnRollback: txnId=" + txnId);
        return true;
    }

    @Override
    public boolean txnRollbackFinal(long txnId) {
        this.mOut.println("txnRollbackFinal: txnId=" + txnId);
        return true;
    }

    @Override
    public boolean txnCommit(long txnId) {
        this.mOut.println("txnCommit: txnId=" + txnId);
        return true;
    }

    @Override
    public boolean txnCommitFinal(long txnId) {
        this.mOut.println("txnCommitFinal: txnId=" + txnId);
        return true;
    }

    @Override
    public boolean txnStore(long txnId, long indexId, byte[] key, byte[] value) {
        this.mOut.println("txnStore: txnId=" + txnId + ", indexId=" + indexId + ", key=" + this.toHex(key) + ", value=" + this.toHex(value));
        return true;
    }

    @Override
    public boolean txnStoreCommitFinal(long txnId, long indexId, byte[] key, byte[] value) {
        this.txnStore(txnId, indexId, key, value);
        return this.txnCommit(txnId);
    }

    @Override
    public boolean txnCustom(long txnId, byte[] message) {
        this.mOut.println("txnCustom: txnId=" + txnId + ", message=" + this.toHex(message));
        return true;
    }

    @Override
    public boolean txnCustomLock(long txnId, byte[] message, long indexId, byte[] key) {
        this.mOut.println("txnCustomLock: txnId=" + txnId + ", message=" + this.toHex(message) + ", indexId=" + indexId + ", key=" + this.toHex(key));
        return true;
    }

    private String toHex(byte[] bytes) {
        StringBuilder bob;
        int len;
        if (bytes == null) {
            return "null";
        }
        if (bytes.length <= 1000) {
            len = bytes.length;
            bob = new StringBuilder(len * 2);
        } else {
            len = 1000;
            bob = new StringBuilder(len * 2 + 3);
        }
        for (int i = 0; i < len; ++i) {
            int b = bytes[i] & 0xFF;
            if (b < 16) {
                bob.append('0');
            }
            bob.append(Integer.toHexString(b));
        }
        if (bytes.length > 1000) {
            bob.append("...");
        }
        return bob.toString();
    }

    private String toDateTime(long timestamp) {
        return new Date(timestamp).toString();
    }
}

