/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import org.cojen.tupl.LocalDatabase;
import org.cojen.tupl.Lock;
import org.cojen.tupl.LockManager;
import org.cojen.tupl.LockOwner;
import org.cojen.tupl.UndoLog;

final class PendingTxn
extends LockOwner {
    private final Lock mFirst;
    private Lock[] mRest;
    private int mRestSize;
    long mTxnId;
    long mCommitPos;
    UndoLog mUndoLog;
    boolean mHasFragmentedTrash;
    PendingTxn mPrev;

    PendingTxn(Lock first) {
        this.mFirst = first;
    }

    void add(Lock lock) {
        Lock first = this.mFirst;
        if (first == null) {
            throw new IllegalStateException("cannot add lock");
        }
        Lock[] rest = this.mRest;
        if (rest == null) {
            this.mRest = rest = new Lock[8];
            this.mRestSize = 1;
            rest[0] = lock;
        } else {
            int size = this.mRestSize;
            if (size >= rest.length) {
                Lock[] newRest = new Lock[rest.length << 1];
                System.arraycopy(rest, 0, newRest, 0, rest.length);
                rest = newRest;
                this.mRest = newRest;
            }
            rest[size] = lock;
            this.mRestSize = size + 1;
        }
    }

    void commit(LocalDatabase db) throws IOException {
        this.unlockAll(db);
        UndoLog undo = this.mUndoLog;
        if (undo != null) {
            undo.truncate(true);
            db.unregister(undo);
        }
        if (this.mHasFragmentedTrash) {
            db.fragmentedTrash().emptyTrash(this.mTxnId);
        }
    }

    void rollback(LocalDatabase db) throws IOException {
        UndoLog undo = this.mUndoLog;
        if (undo != null) {
            undo.rollback();
        }
        this.unlockAll(db);
        if (undo != null) {
            db.unregister(undo);
        }
    }

    private void unlockAll(LocalDatabase db) {
        Lock first = this.mFirst;
        if (first != null) {
            LockManager manager = db.mLockManager;
            manager.unlock(this, first);
            Lock[] rest = this.mRest;
            if (rest != null) {
                for (Lock lock : rest) {
                    if (lock == null) {
                        return;
                    }
                    manager.unlock(this, lock);
                }
            }
        }
    }
}

