/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import java.util.BitSet;
import java.util.concurrent.locks.ReentrantLock;
import org.cojen.tupl.CorruptDatabaseException;
import org.cojen.tupl.IdHeap;
import org.cojen.tupl.IntegerRef;
import org.cojen.tupl.PageDb;
import org.cojen.tupl.PageManager;
import org.cojen.tupl.PageOps;
import org.cojen.tupl.Utils;
import org.cojen.tupl.io.PageArray;

final class PageQueue
implements IntegerRef {
    private static final int I_REMOVE_PAGE_COUNT = 0;
    private static final int I_REMOVE_NODE_COUNT = 8;
    private static final int I_REMOVE_HEAD_ID = 16;
    private static final int I_REMOVE_HEAD_OFFSET = 24;
    private static final int I_REMOVE_HEAD_FIRST_PAGE_ID = 28;
    private static final int I_APPEND_HEAD_ID = 36;
    static final int HEADER_SIZE = 44;
    private static final int I_NEXT_NODE_ID = 0;
    private static final int I_FIRST_PAGE_ID = 8;
    private static final int I_NODE_START = 16;
    private final PageManager mManager;
    private final int mPageSize;
    private final int mAllocMode;
    private final boolean mAggressive;
    private long mRemovePageCount;
    private long mRemoveNodeCount;
    private final byte[] mRemoveHead;
    private long mRemoveHeadId;
    private int mRemoveHeadOffset;
    private long mRemoveHeadFirstPageId;
    private long mRemoveStoppedId;
    private long mRemovedNodeCounter;
    private long mReserveReclaimUpperBound;
    private volatile long mAppendHeadId;
    private final ReentrantLock mAppendLock;
    private final IdHeap mAppendHeap;
    private final byte[] mAppendTail;
    private volatile long mAppendTailId;
    private long mAppendPageCount;
    private long mAppendNodeCount;
    private boolean mDrainInProgress;

    static boolean exists(byte[] header, int offset) {
        return PageOps.p_longGetLE(header, offset + 16) != 0L;
    }

    static PageQueue newRegularFreeList(PageManager manager) {
        return new PageQueue(manager, 0, false, null);
    }

    static PageQueue newRecycleFreeList(PageManager manager) {
        return new PageQueue(manager, 0, true, null);
    }

    private PageQueue(PageManager manager, int allocMode, boolean aggressive, ReentrantLock appendLock) {
        PageArray array = manager.pageArray();
        this.mManager = manager;
        this.mPageSize = array.pageSize();
        this.mAllocMode = allocMode;
        this.mAggressive = aggressive;
        this.mRemoveHead = PageOps.p_calloc(this.mPageSize);
        this.mAppendLock = appendLock == null ? new ReentrantLock(false) : appendLock;
        this.mAppendHeap = new IdHeap(this.mPageSize - 16);
        this.mAppendTail = PageOps.p_calloc(this.mPageSize);
    }

    void delete() {
        PageOps.p_delete(this.mRemoveHead);
        PageOps.p_delete(this.mAppendTail);
    }

    PageQueue newReserveFreeList() {
        if (this.mAggressive) {
            throw new IllegalStateException();
        }
        return new PageQueue(this.mManager, 1, false, this.mAppendLock);
    }

    void init(long headNodeId) {
        this.mAppendLock.lock();
        try {
            this.mAppendHeadId = this.mAppendTailId = headNodeId;
            this.mRemoveStoppedId = this.mAppendTailId;
        }
        finally {
            this.mAppendLock.unlock();
        }
    }

    void init(byte[] header, int offset) throws IOException {
        this.mRemovePageCount = PageOps.p_longGetLE(header, offset + 0);
        this.mRemoveNodeCount = PageOps.p_longGetLE(header, offset + 8);
        this.mRemoveHeadId = PageOps.p_longGetLE(header, offset + 16);
        this.mRemoveHeadOffset = PageOps.p_intGetLE(header, offset + 24);
        this.mRemoveHeadFirstPageId = PageOps.p_longGetLE(header, offset + 28);
        this.mAppendHeadId = this.mAppendTailId = PageOps.p_longGetLE(header, offset + 36);
        if (this.mRemoveHeadId == 0L) {
            this.mRemoveStoppedId = this.mAppendHeadId;
        } else {
            this.mManager.pageArray().readPage(this.mRemoveHeadId, this.mRemoveHead);
            if (this.mRemoveHeadFirstPageId == 0L) {
                this.mRemoveHeadFirstPageId = PageOps.p_longGetBE(this.mRemoveHead, 8);
            }
        }
    }

    void reclaim(ReentrantLock removeLock, long upperBound) throws IOException {
        long pageId;
        if (this.mAllocMode != 1) {
            throw new IllegalStateException();
        }
        removeLock.lock();
        this.mReserveReclaimUpperBound = upperBound;
        while (true) {
            if ((pageId = this.tryRemove(removeLock)) == 0L) break;
            if (pageId <= upperBound) {
                this.mManager.deletePage(pageId);
            }
            removeLock.lock();
        }
        removeLock.unlock();
        pageId = this.mRemoveStoppedId;
        if (pageId != 0L && pageId <= upperBound) {
            this.mManager.deletePage(pageId);
        }
    }

    long getRemoveScanTarget() {
        return this.mRemovedNodeCounter + this.mRemoveNodeCount;
    }

    boolean isRemoveScanComplete(long target) {
        return this.mRemovedNodeCounter - target >= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long tryRemove(ReentrantLock lock) throws IOException {
        long oldHeadId;
        long pageId;
        if (this.mRemoveHeadId == 0L) {
            if (!this.mAggressive || this.mRemoveStoppedId == this.mAppendTailId) {
                return 0L;
            }
            this.loadRemoveNode(this.mRemoveStoppedId);
            this.mRemoveStoppedId = 0L;
        }
        try {
            long nextId;
            long delta;
            pageId = this.mRemoveHeadFirstPageId;
            if (this.mAllocMode != 1 && this.mManager.isPageOutOfBounds(pageId)) {
                throw new CorruptDatabaseException("Invalid page id in free list: " + pageId + "; list node: " + this.mRemoveHeadId);
            }
            --this.mRemovePageCount;
            byte[] head = this.mRemoveHead;
            if (this.mRemoveHeadOffset < this.pageSize(head) && (delta = PageOps.p_ulongGetVar(head, this)) > 0L) {
                this.mRemoveHeadFirstPageId = pageId + delta;
                long l = pageId;
                return l;
            }
            oldHeadId = this.mRemoveHeadId;
            if (this.mAllocMode == 1 && oldHeadId > this.mReserveReclaimUpperBound) {
                oldHeadId = 0L;
            }
            if ((nextId = PageOps.p_longGetBE(head, 0)) == (this.mAggressive ? this.mAppendTailId : this.mAppendHeadId)) {
                this.mRemoveHeadId = 0L;
                this.mRemoveHeadOffset = 0;
                this.mRemoveHeadFirstPageId = 0L;
                this.mRemoveStoppedId = nextId;
            } else {
                this.loadRemoveNode(nextId);
            }
            --this.mRemoveNodeCount;
            ++this.mRemovedNodeCounter;
        }
        finally {
            lock.unlock();
        }
        if (oldHeadId != 0L) {
            this.mManager.deletePage(oldHeadId);
        }
        return pageId;
    }

    private void loadRemoveNode(long id) throws IOException {
        if (this.mAllocMode != 1 && this.mManager.isPageOutOfBounds(id)) {
            throw new CorruptDatabaseException("Invalid node id in free list: " + id);
        }
        byte[] head = this.mRemoveHead;
        this.mManager.pageArray().readPage(id, head);
        this.mRemoveHeadId = id;
        this.mRemoveHeadOffset = 16;
        this.mRemoveHeadFirstPageId = PageOps.p_longGetBE(head, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void append(long id) throws IOException {
        block6: {
            if (id <= 1L) {
                throw new IllegalArgumentException("Page id: " + id);
            }
            IdHeap appendHeap = this.mAppendHeap;
            this.mAppendLock.lock();
            try {
                appendHeap.add(id);
                ++this.mAppendPageCount;
                if (this.mDrainInProgress || !appendHeap.shouldDrain()) break block6;
                try {
                    this.drainAppendHeap(appendHeap);
                }
                catch (IOException e) {
                    appendHeap.remove(id);
                    --this.mAppendPageCount;
                    throw e;
                }
            }
            finally {
                this.mAppendLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long tryUnappend() {
        this.mAppendLock.lock();
        try {
            IdHeap appendHeap = this.mAppendHeap;
            if (this.mDrainInProgress && appendHeap.size() <= 1) {
                long l = 0L;
                return l;
            }
            long id = appendHeap.tryRemove();
            if (id != 0L) {
                --this.mAppendPageCount;
            }
            long l = id;
            return l;
        }
        finally {
            this.mAppendLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainAppendHeap(IdHeap appendHeap) throws IOException {
        if (this.mDrainInProgress) {
            throw new AssertionError();
        }
        this.mDrainInProgress = true;
        try {
            long newTailId = this.mManager.allocPage(this.mAllocMode);
            long firstPageId = appendHeap.remove();
            byte[] tailBuf = this.mAppendTail;
            PageOps.p_longPutBE(tailBuf, 0, newTailId);
            PageOps.p_longPutBE(tailBuf, 8, firstPageId);
            int end = appendHeap.drain(firstPageId, tailBuf, 16, this.pageSize(tailBuf) - 16);
            PageOps.p_clear(tailBuf, end, this.pageSize(tailBuf));
            try {
                this.mManager.pageArray().writePage(this.mAppendTailId, tailBuf);
            }
            catch (IOException e) {
                appendHeap.undrain(firstPageId, tailBuf, 16, end);
                throw e;
            }
            ++this.mAppendNodeCount;
            this.mAppendTailId = newTailId;
        }
        finally {
            this.mDrainInProgress = false;
        }
    }

    ReentrantLock appendLock() {
        return this.mAppendLock;
    }

    void preCommit() throws IOException {
        IdHeap appendHeap = this.mAppendHeap;
        while (appendHeap.size() > 0) {
            this.drainAppendHeap(appendHeap);
        }
    }

    void commitStart(byte[] header, int offset) {
        PageOps.p_longPutLE(header, offset + 0, this.mRemovePageCount + this.mAppendPageCount);
        PageOps.p_longPutLE(header, offset + 8, this.mRemoveNodeCount + this.mAppendNodeCount);
        if (this.mRemoveHeadId == 0L && this.mAppendPageCount > 0L) {
            long headId = this.mAppendHeadId;
            if (headId != this.mRemoveStoppedId) {
                headId = this.mRemoveStoppedId == this.mAppendTailId ? 0L : this.mRemoveStoppedId;
            }
            PageOps.p_longPutLE(header, offset + 16, headId);
            PageOps.p_intPutLE(header, offset + 24, 16);
            PageOps.p_longPutLE(header, offset + 28, 0L);
        } else {
            PageOps.p_longPutLE(header, offset + 16, this.mRemoveHeadId);
            PageOps.p_intPutLE(header, offset + 24, this.mRemoveHeadOffset);
            PageOps.p_longPutLE(header, offset + 28, this.mRemoveHeadFirstPageId);
        }
        PageOps.p_longPutLE(header, offset + 36, this.mAppendTailId);
        this.mRemovePageCount += this.mAppendPageCount;
        this.mRemoveNodeCount += this.mAppendNodeCount;
        this.mAppendPageCount = 0L;
        this.mAppendNodeCount = 0L;
    }

    void commitEnd(byte[] header, int offset) throws IOException {
        long newAppendHeadId = PageOps.p_longGetLE(header, offset + 36);
        if (this.mRemoveHeadId == 0L && this.mRemoveStoppedId != newAppendHeadId && this.mRemoveStoppedId != this.mAppendTailId) {
            this.loadRemoveNode(this.mRemoveStoppedId);
            this.mRemoveStoppedId = 0L;
        }
        this.mAppendHeadId = newAppendHeadId;
    }

    void addTo(PageDb.Stats stats) {
        stats.freePages += this.mRemovePageCount + this.mAppendPageCount + this.mRemoveNodeCount + this.mAppendNodeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean verifyPageRange(long startId, long endId) throws IOException {
        long expectedHash = 0L;
        for (long i = startId; i < endId; ++i) {
            expectedHash += Utils.scramble(i);
        }
        long hash = 0L;
        long count = 0L;
        long nodeId = this.mRemoveHeadId;
        if (nodeId != 0L) {
            byte[] node = PageOps.p_clone(this.mRemoveHead, this.pageSize(this.mRemoveHead));
            try {
                long pageId = this.mRemoveHeadFirstPageId;
                IntegerRef.Value nodeOffsetRef = new IntegerRef.Value();
                nodeOffsetRef.value = this.mRemoveHeadOffset;
                while (true) {
                    long delta;
                    if (pageId < startId || pageId >= endId) {
                        boolean bl = false;
                        return bl;
                    }
                    hash += Utils.scramble(pageId);
                    ++count;
                    if (nodeOffsetRef.value < this.pageSize(node) && (delta = PageOps.p_ulongGetVar(node, nodeOffsetRef)) > 0L) {
                        pageId += delta;
                        continue;
                    }
                    if (nodeId >= startId && nodeId < endId) {
                        hash += Utils.scramble(nodeId);
                        ++count;
                    }
                    if ((nodeId = PageOps.p_longGetBE(node, 0)) == this.mAppendTailId) {
                        break;
                    }
                    this.mManager.pageArray().readPage(nodeId, node);
                    pageId = PageOps.p_longGetBE(node, 8);
                    nodeOffsetRef.value = 16;
                }
            }
            finally {
                PageOps.p_delete(node);
            }
        }
        return hash == expectedHash && count == endId - startId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int traceRemovablePages(BitSet pages) throws IOException {
        int count = 0;
        long nodeId = this.mAppendHeadId;
        if (nodeId < this.mManager.pageArray().getPageCount()) {
            ++count;
            PageQueue.clearPageBit(pages, nodeId);
        }
        if ((nodeId = this.mRemoveHeadId) == 0L) {
            return count;
        }
        byte[] node = PageOps.p_clone(this.mRemoveHead, this.pageSize(this.mRemoveHead));
        try {
            long pageId = this.mRemoveHeadFirstPageId;
            IntegerRef.Value nodeOffsetRef = new IntegerRef.Value();
            nodeOffsetRef.value = this.mRemoveHeadOffset;
            while (true) {
                long delta;
                ++count;
                PageQueue.clearPageBit(pages, pageId);
                if (nodeOffsetRef.value < this.pageSize(node) && (delta = PageOps.p_ulongGetVar(node, nodeOffsetRef)) > 0L) {
                    pageId += delta;
                    continue;
                }
                ++count;
                PageQueue.clearPageBit(pages, nodeId);
                nodeId = PageOps.p_longGetBE(node, 0);
                if (nodeId == this.mAppendHeadId) break;
                if (nodeId == this.mAppendTailId) {
                    break;
                }
                this.mManager.pageArray().readPage(nodeId, node);
                pageId = PageOps.p_longGetBE(node, 8);
                nodeOffsetRef.value = 16;
            }
        }
        finally {
            PageOps.p_delete(node);
        }
        return count;
    }

    private static void clearPageBit(BitSet pages, long pageId) throws CorruptDatabaseException {
        int index = (int)pageId;
        if (pages.get(index)) {
            pages.clear(index);
        } else if (index < pages.size()) {
            throw new CorruptDatabaseException("Doubly freed page: " + pageId);
        }
    }

    private int pageSize(byte[] page) {
        return page.length;
    }

    @Override
    public int get() {
        return this.mRemoveHeadOffset;
    }

    @Override
    public void set(int offset) {
        this.mRemoveHeadOffset = offset;
    }
}

