/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import org.cojen.tupl.DeadlockDetector;
import org.cojen.tupl.DeadlockException;
import org.cojen.tupl.IllegalUpgradeException;
import org.cojen.tupl.Lock;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockInterruptedException;
import org.cojen.tupl.LockManager;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.LockOwner;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.LockTimeoutException;
import org.cojen.tupl.LockUpgradeRule;
import org.cojen.tupl.PendingTxn;

class Locker
extends LockOwner {
    final LockManager mManager;
    ParentScope mParentScope;
    Object mTailBlock;

    Locker(LockManager manager) {
        this.mManager = manager;
    }

    public final boolean isNested() {
        return this.mParentScope != null;
    }

    public final int nestingLevel() {
        int count = 0;
        ParentScope parent = this.mParentScope;
        while (parent != null) {
            ++count;
            parent = parent.mParentScope;
        }
        return count;
    }

    final LockResult tryLock(int lockType, long indexId, byte[] key, int hash, long nanosTimeout) throws DeadlockException {
        LockResult result = this.mManager.getLockHT(hash).tryLock(lockType, this, indexId, key, hash, nanosTimeout);
        if (result == LockResult.TIMED_OUT_LOCK) {
            this.detectDeadlock(nanosTimeout);
        }
        return result;
    }

    final LockResult lock(int lockType, long indexId, byte[] key, int hash, long nanosTimeout) throws LockFailureException {
        LockResult result = this.mManager.getLockHT(hash).tryLock(lockType, this, indexId, key, hash, nanosTimeout);
        if (result.isHeld()) {
            return result;
        }
        throw this.failed(result, nanosTimeout);
    }

    final LockResult lockNT(int lockType, long indexId, byte[] key, int hash, long nanosTimeout) throws LockFailureException {
        LockResult result = this.mManager.getLockHT(hash).tryLock(lockType, this, indexId, key, hash, nanosTimeout);
        if (!result.isHeld()) {
            switch (result) {
                case ILLEGAL: {
                    throw new IllegalUpgradeException();
                }
                case INTERRUPTED: {
                    throw new LockInterruptedException();
                }
            }
        }
        return result;
    }

    public final LockResult tryLockShared(long indexId, byte[] key, long nanosTimeout) throws DeadlockException {
        return this.tryLock(1, indexId, key, LockManager.hash(indexId, key), nanosTimeout);
    }

    final LockResult tryLockShared(long indexId, byte[] key, int hash, long nanosTimeout) throws DeadlockException {
        return this.tryLock(1, indexId, key, hash, nanosTimeout);
    }

    public final LockResult lockShared(long indexId, byte[] key, long nanosTimeout) throws LockFailureException {
        return this.lock(1, indexId, key, LockManager.hash(indexId, key), nanosTimeout);
    }

    final LockResult lockShared(long indexId, byte[] key, int hash, long nanosTimeout) throws LockFailureException {
        return this.lock(1, indexId, key, hash, nanosTimeout);
    }

    final LockResult lockSharedNT(long indexId, byte[] key, int hash, long nanosTimeout) throws LockFailureException {
        return this.lockNT(1, indexId, key, hash, nanosTimeout);
    }

    public final LockResult tryLockUpgradable(long indexId, byte[] key, long nanosTimeout) throws DeadlockException {
        return this.tryLock(Integer.MIN_VALUE, indexId, key, LockManager.hash(indexId, key), nanosTimeout);
    }

    final LockResult tryLockUpgradable(long indexId, byte[] key, int hash, long nanosTimeout) throws DeadlockException {
        return this.tryLock(Integer.MIN_VALUE, indexId, key, hash, nanosTimeout);
    }

    public final LockResult lockUpgradable(long indexId, byte[] key, long nanosTimeout) throws LockFailureException {
        return this.lock(Integer.MIN_VALUE, indexId, key, LockManager.hash(indexId, key), nanosTimeout);
    }

    final LockResult lockUpgradable(long indexId, byte[] key, int hash, long nanosTimeout) throws LockFailureException {
        return this.lock(Integer.MIN_VALUE, indexId, key, hash, nanosTimeout);
    }

    final LockResult lockUpgradableNT(long indexId, byte[] key, int hash, long nanosTimeout) throws LockFailureException {
        return this.lockNT(Integer.MIN_VALUE, indexId, key, hash, nanosTimeout);
    }

    public final LockResult tryLockExclusive(long indexId, byte[] key, long nanosTimeout) throws DeadlockException {
        return this.tryLock(-1, indexId, key, LockManager.hash(indexId, key), nanosTimeout);
    }

    final LockResult tryLockExclusive(long indexId, byte[] key, int hash, long nanosTimeout) throws DeadlockException {
        return this.tryLock(-1, indexId, key, hash, nanosTimeout);
    }

    public final LockResult lockExclusive(long indexId, byte[] key, long nanosTimeout) throws LockFailureException {
        return this.lock(-1, indexId, key, LockManager.hash(indexId, key), nanosTimeout);
    }

    final LockResult lockExclusive(long indexId, byte[] key, int hash, long nanosTimeout) throws LockFailureException {
        return this.lock(-1, indexId, key, hash, nanosTimeout);
    }

    final LockResult lockExclusive(Lock lock, long nanosTimeout) throws LockFailureException {
        LockResult result = this.mManager.getLockHT(lock.mHashCode).tryLockExclusive(this, lock, nanosTimeout);
        if (result.isHeld()) {
            return result;
        }
        throw this.failed(result, nanosTimeout);
    }

    final LockResult lockExclusiveNT(long indexId, byte[] key, int hash, long nanosTimeout) throws LockFailureException {
        return this.lockNT(-1, indexId, key, hash, nanosTimeout);
    }

    final boolean canAttemptUpgrade(int count) {
        LockManager manager = this.mManager;
        if (manager == null) {
            return false;
        }
        LockUpgradeRule lockUpgradeRule = manager.mDefaultLockUpgradeRule;
        return lockUpgradeRule == LockUpgradeRule.UNCHECKED | lockUpgradeRule == LockUpgradeRule.LENIENT & count == 1;
    }

    LockFailureException failed(LockResult result, long nanosTimeout) throws DeadlockException {
        switch (result) {
            case TIMED_OUT_LOCK: {
                this.detectDeadlock(nanosTimeout);
                break;
            }
            case ILLEGAL: {
                return new IllegalUpgradeException();
            }
            case INTERRUPTED: {
                return new LockInterruptedException();
            }
        }
        if (result.isTimedOut()) {
            return new LockTimeoutException(nanosTimeout);
        }
        return new LockFailureException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectDeadlock(long nanosTimeout) throws DeadlockException {
        if (this.mWaitingFor != null) {
            try {
                DeadlockDetector detector = new DeadlockDetector(this);
                if (detector.scan()) {
                    throw new DeadlockException(nanosTimeout, detector.mGuilty, detector.newDeadlockSet());
                }
            }
            finally {
                this.mWaitingFor = null;
            }
        }
    }

    public final LockResult lockCheck(long indexId, byte[] key) {
        return this.mManager.check(this, indexId, key, LockManager.hash(indexId, key));
    }

    public final long lastLockedIndex() {
        return this.peek().mIndexId;
    }

    public final byte[] lastLockedKey() {
        return this.peek().mKey;
    }

    private Lock peek() {
        Object tailObj = this.mTailBlock;
        if (tailObj == null) {
            throw new IllegalStateException("No locks held");
        }
        return tailObj instanceof Lock ? (Lock)tailObj : ((Block)tailObj).last();
    }

    public final void unlock() {
        Object tailObj = this.mTailBlock;
        if (tailObj == null) {
            throw new IllegalStateException("No locks held");
        }
        if (tailObj instanceof Lock) {
            this.mTailBlock = null;
            this.mManager.unlock(this, (Lock)tailObj);
        } else {
            ((Block)tailObj).unlockLast(this);
        }
    }

    public final void unlockToShared() {
        Object tailObj = this.mTailBlock;
        if (tailObj == null) {
            throw new IllegalStateException("No locks held");
        }
        if (tailObj instanceof Lock) {
            this.mManager.unlockToShared(this, (Lock)tailObj);
        } else {
            ((Block)tailObj).unlockLastToShared(this);
        }
    }

    public final void unlockToUpgradable() {
        Object tailObj = this.mTailBlock;
        if (tailObj == null) {
            throw new IllegalStateException("No locks held");
        }
        if (tailObj instanceof Lock) {
            this.mManager.unlockToUpgradable(this, (Lock)tailObj);
        } else {
            ((Block)tailObj).unlockLastToUpgradable(this);
        }
    }

    final ParentScope scopeEnter() {
        Object tailObj;
        ParentScope parent = new ParentScope();
        parent.mParentScope = this.mParentScope;
        parent.mTailBlock = tailObj = this.mTailBlock;
        if (tailObj instanceof Block) {
            parent.mTailBlockSize = ((Block)tailObj).mSize;
        }
        this.mParentScope = parent;
        return parent;
    }

    final void promote() {
        Object tailObj = this.mTailBlock;
        if (tailObj != null) {
            ParentScope parent = this.mParentScope;
            parent.mTailBlock = tailObj;
            if (tailObj instanceof Block) {
                parent.mTailBlockSize = ((Block)tailObj).mSize;
            }
        }
    }

    final void scopeUnlockAll() {
        Object parentTailObj;
        ParentScope parent = this.mParentScope;
        if (parent == null || (parentTailObj = parent.mTailBlock) == null) {
            Object tailObj = this.mTailBlock;
            if (tailObj instanceof Lock) {
                this.mManager.unlock(this, (Lock)tailObj);
                this.mTailBlock = null;
            } else {
                Block tail = (Block)tailObj;
                if (tail != null) {
                    do {
                        tail.unlockToSavepoint(this, 0);
                    } while ((tail = tail.pop()) != null);
                    this.mTailBlock = null;
                }
            }
        } else if (parentTailObj instanceof Lock) {
            Object tailObj = this.mTailBlock;
            if (tailObj instanceof Block) {
                Block tail = (Block)tailObj;
                while (true) {
                    Block prev;
                    if ((prev = tail.peek()) == null) break;
                    tail.unlockToSavepoint(this, 0);
                    tail.discard();
                    tail = prev;
                }
                tail.unlockToSavepoint(this, 1);
                this.mTailBlock = tail;
            }
        } else {
            Block tail;
            for (tail = (Block)this.mTailBlock; tail != parentTailObj; tail = tail.pop()) {
                tail.unlockToSavepoint(this, 0);
            }
            tail.unlockToSavepoint(this, parent.mTailBlockSize);
            this.mTailBlock = tail;
        }
    }

    final PendingTxn transferExclusive() {
        PendingTxn pending;
        Object tailObj = this.mTailBlock;
        if (tailObj instanceof Lock) {
            pending = this.mManager.transferExclusive(this, (Lock)tailObj, null);
        } else if (tailObj == null) {
            pending = new PendingTxn(null);
        } else {
            pending = null;
            Block tail = (Block)tailObj;
            do {
                pending = tail.transferExclusive(this, pending);
            } while ((tail = tail.pop()) != null);
        }
        this.mTailBlock = null;
        return pending;
    }

    final ParentScope scopeExit() {
        this.scopeUnlockAll();
        return this.popScope();
    }

    final void scopeExitAll() {
        this.mParentScope = null;
        this.scopeUnlockAll();
        this.mTailBlock = null;
    }

    final void push(Lock lock, int upgrade) {
        Object tailObj = this.mTailBlock;
        if (tailObj == null) {
            this.mTailBlock = upgrade == 0 ? lock : new Block(lock);
        } else if (tailObj instanceof Lock) {
            if (tailObj != lock || this.mParentScope != null) {
                this.mTailBlock = new Block((Lock)tailObj, lock, upgrade);
            }
        } else {
            ((Block)tailObj).pushLock(this, lock, upgrade);
        }
    }

    private ParentScope popScope() {
        ParentScope parent = this.mParentScope;
        if (parent == null) {
            this.mTailBlock = null;
        } else {
            this.mTailBlock = parent.mTailBlock;
            this.mParentScope = parent.mParentScope;
        }
        return parent;
    }

    static final class ParentScope {
        ParentScope mParentScope;
        Object mTailBlock;
        int mTailBlockSize;
        LockMode mLockMode;
        long mLockTimeoutNanos;
        int mHasState;
        long mSavepoint;

        ParentScope() {
        }
    }

    static final class Block {
        private static final int FIRST_BLOCK_CAPACITY = 8;
        private static final int HIGHEST_BLOCK_CAPACITY = 64;
        private Lock[] mLocks;
        private long mUpgrades;
        int mSize;
        private Block mPrev;

        Block(Lock first) {
            Lock[] lockArray = new Lock[8];
            this.mLocks = lockArray;
            lockArray[0] = first;
            this.mUpgrades = 1L;
            this.mSize = 1;
        }

        Block(Lock first, Lock second, int upgrade) {
            Lock[] locks = new Lock[8];
            locks[0] = first;
            locks[1] = second;
            this.mLocks = locks;
            this.mUpgrades = upgrade << 1;
            this.mSize = 2;
        }

        private Block(Block prev, Lock first, int upgrade) {
            this.mPrev = prev;
            int capacity = prev.mLocks.length;
            if (capacity < 8) {
                capacity = 8;
            } else if (capacity < 64) {
                capacity <<= 1;
            }
            Lock[] lockArray = new Lock[capacity];
            this.mLocks = lockArray;
            lockArray[0] = first;
            this.mUpgrades = upgrade;
            this.mSize = 1;
        }

        void pushLock(Locker locker, Lock lock, int upgrade) {
            ParentScope parent;
            Lock[] locks = this.mLocks;
            int size = this.mSize;
            if (upgrade != 0 && ((parent = locker.mParentScope) == null || parent.mTailBlockSize != size) && locks[size - 1] == lock) {
                return;
            }
            if (size < locks.length) {
                locks[size] = lock;
                this.mUpgrades |= (long)upgrade << size;
                this.mSize = size + 1;
            } else {
                locker.mTailBlock = new Block(this, lock, upgrade);
            }
        }

        Lock last() {
            return this.mLocks[this.mSize - 1];
        }

        void unlockLast(Locker locker) {
            long upgrades = this.mUpgrades;
            int size = this.mSize - 1;
            long mask = 1L << size;
            if ((upgrades & mask) != 0L) {
                throw new IllegalStateException("Cannot unlock non-immediate upgrade");
            }
            Lock[] locks = this.mLocks;
            locker.mManager.unlock(locker, locks[size]);
            locks[size] = null;
            if (size == 0) {
                locker.mTailBlock = this.mPrev;
                this.mPrev = null;
            } else {
                this.mUpgrades &= upgrades & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                this.mSize = size;
            }
        }

        void unlockLastToShared(Locker locker) {
            int size = this.mSize - 1;
            if ((this.mUpgrades & 1L << size) != 0L) {
                throw new IllegalStateException("Cannot unlock non-immediate upgrade");
            }
            locker.mManager.unlockToShared(locker, this.mLocks[size]);
        }

        void unlockLastToUpgradable(Locker locker) {
            Lock[] locks = this.mLocks;
            int size = this.mSize;
            locker.mManager.unlockToUpgradable(locker, locks[--size]);
            long upgrades = this.mUpgrades;
            long mask = 1L << size;
            if ((upgrades & mask) != 0L) {
                locks[size] = null;
                if (size == 0) {
                    locker.mTailBlock = this.mPrev;
                    this.mPrev = null;
                } else {
                    this.mUpgrades = upgrades & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                    this.mSize = size;
                }
            }
        }

        void unlockToSavepoint(Locker locker, int targetSize) {
            int size = this.mSize;
            if (size > targetSize) {
                Lock[] locks = this.mLocks;
                LockManager manager = locker.mManager;
                long mask = 1L << --size;
                long upgrades = this.mUpgrades;
                while (true) {
                    Lock lock = locks[size];
                    if ((upgrades & mask) != 0L) {
                        manager.unlockToUpgradable(locker, lock);
                    } else {
                        manager.unlock(locker, lock);
                    }
                    locks[size] = null;
                    if (size == targetSize) break;
                    --size;
                    mask >>>= 1;
                }
                this.mUpgrades = upgrades & (-1L << size ^ 0xFFFFFFFFFFFFFFFFL);
                this.mSize = size;
            }
        }

        PendingTxn transferExclusive(Locker locker, PendingTxn pending) {
            int size = this.mSize;
            if (size > 0) {
                Lock[] locks = this.mLocks;
                LockManager manager = locker.mManager;
                do {
                    Lock lock = locks[--size];
                    pending = manager.transferExclusive(locker, lock, pending);
                } while (size != 0);
            }
            return pending;
        }

        Block pop() {
            Block prev = this.mPrev;
            this.mPrev = null;
            return prev;
        }

        Block peek() {
            return this.mPrev;
        }

        void discard() {
            this.mPrev = null;
        }
    }
}

