/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.util.concurrent.TimeUnit;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.Utils;

public class LockTimeoutException
extends LockFailureException {
    private static final long serialVersionUID = 1L;
    private final long mNanosTimeout;
    private TimeUnit mUnit;

    public LockTimeoutException(long nanosTimeout) {
        super((String)null);
        this.mNanosTimeout = nanosTimeout;
    }

    @Override
    public String getMessage() {
        return Utils.timeoutMessage(this.mNanosTimeout, this);
    }

    @Override
    public long getTimeout() {
        return this.getUnit().convert(this.mNanosTimeout, TimeUnit.NANOSECONDS);
    }

    @Override
    public TimeUnit getUnit() {
        TimeUnit unit = this.mUnit;
        if (unit != null) {
            return unit;
        }
        this.mUnit = Utils.inferUnit(TimeUnit.NANOSECONDS, this.mNanosTimeout);
        return this.mUnit;
    }
}

