/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.lang.ref.SoftReference;
import org.cojen.tupl.Hasher;
import org.cojen.tupl.Lock;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockOwner;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.LockUpgradeRule;
import org.cojen.tupl.Locker;
import org.cojen.tupl.PendingTxn;
import org.cojen.tupl.Tree;
import org.cojen.tupl.Utils;
import org.cojen.tupl.util.Latch;
import org.cojen.tupl.util.LatchCondition;

final class LockManager {
    static final int TYPE_SHARED = 1;
    static final int TYPE_UPGRADABLE = Integer.MIN_VALUE;
    static final int TYPE_EXCLUSIVE = -1;
    final LockUpgradeRule mDefaultLockUpgradeRule;
    final long mDefaultTimeoutNanos;
    private final LockHT[] mHashTables;
    private final int mHashTableShift;
    private final ThreadLocal<SoftReference<Locker>> mLocalLockerRef;

    LockManager(LockUpgradeRule lockUpgradeRule, long timeoutNanos) {
        this(lockUpgradeRule, timeoutNanos, Runtime.getRuntime().availableProcessors() * 16);
    }

    private LockManager(LockUpgradeRule lockUpgradeRule, long timeoutNanos, int numHashTables) {
        if (lockUpgradeRule == null) {
            lockUpgradeRule = LockUpgradeRule.STRICT;
        }
        this.mDefaultLockUpgradeRule = lockUpgradeRule;
        this.mDefaultTimeoutNanos = timeoutNanos;
        numHashTables = Utils.roundUpPower2(Math.max(2, numHashTables));
        this.mHashTables = new LockHT[numHashTables];
        for (int i = 0; i < numHashTables; ++i) {
            this.mHashTables[i] = new LockHT();
        }
        this.mHashTableShift = Integer.numberOfLeadingZeros(numHashTables - 1);
        this.mLocalLockerRef = new ThreadLocal();
    }

    public long numLocksHeld() {
        long count = 0L;
        for (LockHT ht : this.mHashTables) {
            count += (long)ht.size();
        }
        return count;
    }

    final boolean isAvailable(LockOwner locker, long indexId, byte[] key, int hash) {
        Lock lock = this.getLockHT(hash).lockFor(indexId, key, hash);
        return lock == null ? true : lock.isAvailable(locker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final LockResult check(LockOwner locker, long indexId, byte[] key, int hash) {
        LockHT ht = this.getLockHT(hash);
        ht.acquireShared();
        try {
            Lock lock = ht.lockFor(indexId, key, hash);
            LockResult lockResult = lock == null ? LockResult.UNOWNED : lock.check(locker);
            return lockResult;
        }
        finally {
            ht.releaseShared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unlock(LockOwner locker, Lock lock) {
        LockHT ht = this.getLockHT(lock.mHashCode);
        ht.acquireExclusive();
        try {
            if (lock.unlock(locker, ht)) {
                ht.remove(lock);
            }
        }
        finally {
            ht.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unlockToShared(LockOwner locker, Lock lock) {
        LockHT ht = this.getLockHT(lock.mHashCode);
        ht.acquireExclusive();
        try {
            lock.unlockToShared(locker, ht);
        }
        finally {
            ht.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unlockToUpgradable(LockOwner locker, Lock lock) {
        LockHT ht = this.getLockHT(lock.mHashCode);
        ht.acquireExclusive();
        try {
            lock.unlockToUpgradable(locker, ht);
        }
        finally {
            ht.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PendingTxn transferExclusive(LockOwner locker, Lock lock, PendingTxn pending) {
        LockHT ht = this.getLockHT(lock.mHashCode);
        ht.acquireExclusive();
        try {
            PendingTxn pendingTxn = lock.transferExclusive(locker, pending);
            return pendingTxn;
        }
        finally {
            ht.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ghosted(Tree tree, byte[] key, int hash) {
        LockHT ht = this.getLockHT(hash);
        ht.acquireExclusive();
        try {
            ht.lockFor((long)tree.mId, (byte[])key, (int)hash).mSharedLockOwnersObj = tree;
        }
        finally {
            ht.releaseExclusive();
        }
    }

    final Locker lockSharedLocal(long indexId, byte[] key, int hash) throws LockFailureException {
        Locker locker = this.localLocker();
        LockResult result = this.getLockHT(hash).tryLock(1, locker, indexId, key, hash, this.mDefaultTimeoutNanos);
        if (result.isHeld()) {
            return locker;
        }
        throw locker.failed(result, this.mDefaultTimeoutNanos);
    }

    final Locker lockExclusiveLocal(long indexId, byte[] key, int hash) throws LockFailureException {
        Locker locker = this.localLocker();
        LockResult result = this.getLockHT(hash).tryLock(-1, locker, indexId, key, hash, this.mDefaultTimeoutNanos);
        if (result.isHeld()) {
            return locker;
        }
        throw locker.failed(result, this.mDefaultTimeoutNanos);
    }

    final Locker localLocker() {
        Locker locker;
        SoftReference<Locker> lockerRef = this.mLocalLockerRef.get();
        if (lockerRef == null || (locker = lockerRef.get()) == null) {
            locker = new Locker(this);
            this.mLocalLockerRef.set(new SoftReference<Locker>(locker));
        }
        return locker;
    }

    final void close() {
        Locker locker = new Locker(null);
        for (LockHT ht : this.mHashTables) {
            ht.close(locker);
        }
    }

    static final int hash(long indexId, byte[] key) {
        return (int)Hasher.hash(indexId, key);
    }

    LockHT getLockHT(int hash) {
        return this.mHashTables[hash >>> this.mHashTableShift];
    }

    static final class LockHT
    extends Latch {
        private static final float LOAD_FACTOR = 0.75f;
        private transient Lock[] mEntries = new Lock[16];
        private int mSize;
        private int mGrowThreshold = (int)((float)this.mEntries.length * 0.75f);
        private long a0;
        private long a1;
        private long a2;
        private long a3;

        LockHT() {
        }

        int size() {
            this.acquireShared();
            int size = this.mSize;
            this.releaseShared();
            return size;
        }

        Lock lockFor(long indexId, byte[] key, int hash) {
            Lock[] entries = this.mEntries;
            int index = hash & entries.length - 1;
            Lock e = entries[index];
            while (e != null) {
                if (e.matches(indexId, key, hash)) {
                    return e;
                }
                e = e.mLockManagerNext;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LockResult tryLock(int type, Locker locker, long indexId, byte[] key, int hash, long nanosTimeout) {
            LockResult result;
            Lock lock;
            block20: {
                LockResult result2;
                block19: {
                    this.acquireExclusive();
                    try {
                        Lock[] entries = this.mEntries;
                        int index = hash & entries.length - 1;
                        lock = entries[index];
                        while (lock != null) {
                            if (lock.matches(indexId, key, hash)) {
                                if (type == 1) {
                                    result2 = lock.tryLockShared(this, locker, nanosTimeout);
                                    break block19;
                                }
                                if (type == Integer.MIN_VALUE) {
                                    result2 = lock.tryLockUpgradable(this, locker, nanosTimeout);
                                    break block19;
                                }
                                result = lock.tryLockExclusive(this, locker, nanosTimeout);
                                break block20;
                            }
                            lock = lock.mLockManagerNext;
                        }
                        if (this.mSize >= this.mGrowThreshold) {
                            int capacity = entries.length << 1;
                            Lock[] newEntries = new Lock[capacity];
                            int newMask = capacity - 1;
                            int i = entries.length;
                            while (--i >= 0) {
                                Lock e = entries[i];
                                while (e != null) {
                                    Lock next = e.mLockManagerNext;
                                    int ix = e.mHashCode & newMask;
                                    e.mLockManagerNext = newEntries[ix];
                                    newEntries[ix] = e;
                                    e = next;
                                }
                            }
                            entries = newEntries;
                            this.mEntries = newEntries;
                            this.mGrowThreshold = (int)((float)capacity * 0.75f);
                            index = hash & newMask;
                        }
                        lock = new Lock();
                        lock.mIndexId = indexId;
                        lock.mKey = key;
                        lock.mHashCode = hash;
                        lock.mLockManagerNext = entries[index];
                        lock.mLockCount = type;
                        if (type == 1) {
                            lock.mSharedLockOwnersObj = locker;
                        } else {
                            lock.mOwner = locker;
                        }
                        entries[index] = lock;
                        ++this.mSize;
                    }
                    finally {
                        this.releaseExclusive();
                    }
                    locker.push(lock, 0);
                    return LockResult.ACQUIRED;
                }
                if (result2 == LockResult.ACQUIRED) {
                    locker.push(lock, 0);
                }
                return result2;
            }
            if (result == LockResult.ACQUIRED) {
                locker.push(lock, 0);
            } else if (result == LockResult.UPGRADED) {
                locker.push(lock, 1);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LockResult tryLockExclusive(Locker locker, Lock newLock, long nanosTimeout) {
            LockResult result;
            Lock lock;
            block12: {
                int hash = newLock.mHashCode;
                this.acquireExclusive();
                try {
                    Lock[] entries = this.mEntries;
                    int index = hash & entries.length - 1;
                    lock = entries[index];
                    while (lock != null) {
                        if (lock.matches(newLock.mIndexId, newLock.mKey, hash)) {
                            result = lock.tryLockExclusive(this, locker, nanosTimeout);
                            break block12;
                        }
                        lock = lock.mLockManagerNext;
                    }
                    if (this.mSize >= this.mGrowThreshold) {
                        int capacity = entries.length << 1;
                        Lock[] newEntries = new Lock[capacity];
                        int newMask = capacity - 1;
                        int i = entries.length;
                        while (--i >= 0) {
                            Lock e = entries[i];
                            while (e != null) {
                                Lock next = e.mLockManagerNext;
                                int ix = e.mHashCode & newMask;
                                e.mLockManagerNext = newEntries[ix];
                                newEntries[ix] = e;
                                e = next;
                            }
                        }
                        entries = newEntries;
                        this.mEntries = newEntries;
                        this.mGrowThreshold = (int)((float)capacity * 0.75f);
                        index = hash & newMask;
                    }
                    lock = newLock;
                    lock.mLockManagerNext = entries[index];
                    lock.mLockCount = -1;
                    lock.mOwner = locker;
                    entries[index] = lock;
                    ++this.mSize;
                }
                finally {
                    this.releaseExclusive();
                }
                locker.push(lock, 0);
                return LockResult.ACQUIRED;
            }
            if (result == LockResult.ACQUIRED) {
                locker.push(lock, 0);
            } else if (result == LockResult.UPGRADED) {
                locker.push(lock, 1);
            }
            return result;
        }

        void remove(Lock lock) {
            Lock[] entries = this.mEntries;
            int index = lock.mHashCode & entries.length - 1;
            Lock e = entries[index];
            if (e == lock) {
                entries[index] = e.mLockManagerNext;
            } else {
                while (true) {
                    Lock next;
                    if ((next = e.mLockManagerNext) == lock) {
                        e.mLockManagerNext = next.mLockManagerNext;
                        break;
                    }
                    e = next;
                }
            }
            --this.mSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(LockOwner locker) {
            this.acquireExclusive();
            try {
                if (this.mSize > 0) {
                    Lock[] entries = this.mEntries;
                    int i = entries.length;
                    while (--i >= 0) {
                        Lock e = entries[i];
                        Lock prev = null;
                        while (e != null) {
                            Lock next = e.mLockManagerNext;
                            if (e.mLockCount == -1) {
                                e.mOwner = locker;
                            } else {
                                e.mLockCount = 0;
                                e.mOwner = null;
                                if (prev == null) {
                                    entries[i] = next;
                                } else {
                                    prev.mLockManagerNext = next;
                                }
                                e.mLockManagerNext = null;
                                --this.mSize;
                            }
                            e.mSharedLockOwnersObj = null;
                            LatchCondition q = e.mQueueU;
                            if (q != null) {
                                q.clear();
                                e.mQueueU = null;
                            }
                            if ((q = e.mQueueSX) != null) {
                                q.clear();
                                e.mQueueSX = null;
                            }
                            prev = e;
                            e = next;
                        }
                    }
                }
            }
            finally {
                this.releaseExclusive();
            }
        }
    }
}

