/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.cojen.tupl.CommitLock;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.LocalDatabase;
import org.cojen.tupl.Lock;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Locker;
import org.cojen.tupl.PendingTxn;
import org.cojen.tupl.RedoWriter;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.TreeCursor;
import org.cojen.tupl.UndoLog;
import org.cojen.tupl.Utils;

final class LocalTransaction
extends Locker
implements Transaction {
    static final LocalTransaction BOGUS = new LocalTransaction();
    static final int HAS_SCOPE = 1;
    static final int HAS_COMMIT = 2;
    static final int HAS_TRASH = 4;
    final LocalDatabase mDatabase;
    final RedoWriter mRedoWriter;
    DurabilityMode mDurabilityMode;
    private LockMode mLockMode;
    long mLockTimeoutNanos;
    private int mHasState;
    private long mSavepoint;
    private long mTxnId;
    private UndoLog mUndoLog;
    private Object mBorked;

    LocalTransaction(LocalDatabase db, RedoWriter redo, DurabilityMode durabilityMode, LockMode lockMode, long timeoutNanos) {
        super(db.mLockManager);
        this.mDatabase = db;
        this.mRedoWriter = redo;
        this.mDurabilityMode = durabilityMode;
        this.mLockMode = lockMode;
        this.mLockTimeoutNanos = timeoutNanos;
    }

    LocalTransaction(LocalDatabase db, long txnId, LockMode lockMode, long timeoutNanos) {
        this(db, null, DurabilityMode.NO_REDO, lockMode, timeoutNanos);
        this.mTxnId = txnId;
    }

    LocalTransaction(LocalDatabase db, long txnId, LockMode lockMode, long timeoutNanos, int hasState) {
        this(db, null, DurabilityMode.NO_REDO, lockMode, timeoutNanos);
        this.mTxnId = txnId;
        this.mHasState = hasState;
    }

    final void recoveredScope(long savepoint, int hasState) {
        Locker.ParentScope parentScope = super.scopeEnter();
        parentScope.mLockMode = this.mLockMode;
        parentScope.mLockTimeoutNanos = this.mLockTimeoutNanos;
        parentScope.mHasState = this.mHasState;
        parentScope.mSavepoint = this.mSavepoint;
        this.mSavepoint = savepoint;
        this.mHasState = hasState;
    }

    final void recoveredUndoLog(UndoLog undo) {
        this.mDatabase.register(undo);
        this.mUndoLog = undo;
    }

    private LocalTransaction() {
        super(null);
        this.mDatabase = null;
        this.mRedoWriter = null;
        this.mDurabilityMode = DurabilityMode.NO_REDO;
        this.mLockMode = LockMode.UNSAFE;
        this.mBorked = this;
    }

    @Override
    public final void lockMode(LockMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Lock mode is null");
        }
        this.mLockMode = mode;
    }

    @Override
    public final LockMode lockMode() {
        return this.mLockMode;
    }

    @Override
    public final void lockTimeout(long timeout, TimeUnit unit) {
        this.mLockTimeoutNanos = Utils.toNanos(timeout, unit);
    }

    @Override
    public final long lockTimeout(TimeUnit unit) {
        return unit.convert(this.mLockTimeoutNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public final void durabilityMode(DurabilityMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Durability mode is null");
        }
        this.mDurabilityMode = mode;
    }

    @Override
    public final DurabilityMode durabilityMode() {
        return this.mDurabilityMode;
    }

    @Override
    public final void check() throws DatabaseException {
        Object borked = this.mBorked;
        if (borked != null) {
            if (borked == BOGUS) {
                throw new DatabaseException("Transaction is bogus");
            }
            throw new DatabaseException("Invalid transaction, caused by: " + borked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void commit() throws IOException {
        block20: {
            this.check();
            try {
                Locker.ParentScope parentScope = this.mParentScope;
                if (parentScope == null) {
                    UndoLog undo = this.mUndoLog;
                    if (undo == null) {
                        int hasState = this.mHasState;
                        if ((hasState & 2) != 0) {
                            RedoWriter redo = this.mRedoWriter;
                            long commitPos = redo.txnCommitFinal(this.mTxnId, this.mDurabilityMode);
                            this.mHasState = hasState & 0xFFFFFFFC;
                            if (commitPos != 0L) {
                                if (this.mDurabilityMode == DurabilityMode.SYNC) {
                                    redo.txnCommitSync(this, commitPos);
                                } else {
                                    this.commitPending(commitPos, null);
                                    return;
                                }
                            }
                        }
                        super.scopeUnlockAll();
                    } else {
                        long commitPos;
                        CommitLock commitLock = this.mDatabase.commitLock();
                        commitLock.acquireShared();
                        try {
                            commitPos = this.mHasState & 2;
                            if (commitPos != 0L) {
                                commitPos = this.mRedoWriter.txnCommitFinal(this.mTxnId, this.mDurabilityMode);
                                this.mHasState &= 0xFFFFFFFC;
                            }
                            undo.pushCommit();
                        }
                        finally {
                            commitLock.releaseShared();
                        }
                        if (commitPos != 0L) {
                            if (this.mDurabilityMode == DurabilityMode.SYNC) {
                                this.mRedoWriter.txnCommitSync(this, commitPos);
                            } else {
                                this.commitPending(commitPos, undo);
                                return;
                            }
                        }
                        super.scopeUnlockAll();
                        undo.truncate(true);
                        this.mDatabase.unregister(undo);
                        this.mUndoLog = null;
                        int hasState = this.mHasState;
                        if ((hasState & 4) != 0) {
                            this.mDatabase.fragmentedTrash().emptyTrash(this.mTxnId);
                            this.mHasState = hasState & 0xFFFFFFFB;
                        }
                    }
                    this.mTxnId = 0L;
                    break block20;
                }
                int hasState = this.mHasState;
                if ((hasState & 2) != 0) {
                    this.mRedoWriter.txnCommit(this.mTxnId);
                    this.mHasState = hasState & 0xFFFFFFFC;
                    parentScope.mHasState |= 2;
                }
                super.promote();
                UndoLog undo = this.mUndoLog;
                if (undo != null) {
                    this.mSavepoint = undo.scopeCommit();
                }
            }
            catch (Throwable e) {
                throw this.borked(e, true);
            }
        }
    }

    private void commitPending(long commitPos, UndoLog undo) throws IOException {
        PendingTxn pending = this.transferExclusive();
        pending.mTxnId = this.mTxnId;
        pending.mCommitPos = commitPos;
        pending.mUndoLog = undo;
        this.mUndoLog = null;
        int hasState = this.mHasState;
        if ((hasState & 4) != 0) {
            pending.mHasFragmentedTrash = true;
            this.mHasState = hasState & 0xFFFFFFFB;
        }
        this.mTxnId = 0L;
        this.mRedoWriter.txnCommitPending(pending);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void storeCommit(TreeCursor cursor, byte[] value) throws IOException {
        block36: {
            RedoWriter redo = this.mRedoWriter;
            if (redo == null) {
                cursor.store(this, cursor.leafExclusive(), value);
                this.commit();
                return;
            }
            this.check();
            long txnId = this.mTxnId;
            CommitLock commitLock = this.mDatabase.commitLock();
            commitLock.acquireShared();
            try {
                if (txnId == 0L) {
                    this.mTxnId = txnId = this.mDatabase.nextTransactionId();
                }
            }
            catch (Throwable e) {
                commitLock.releaseShared();
                throw e;
            }
            try {
                int hasState = this.mHasState;
                long indexId = cursor.mTree.mId;
                byte[] key = cursor.mKey;
                Locker.ParentScope parentScope = this.mParentScope;
                if (parentScope == null) {
                    long commitPos;
                    try {
                        if ((hasState & 1) == 0) {
                            redo.txnEnter(txnId);
                            this.mHasState = hasState | 1;
                        }
                        commitPos = value == null ? redo.txnDeleteCommitFinal(txnId, indexId, key, this.mDurabilityMode) : redo.txnStoreCommitFinal(txnId, indexId, key, value, this.mDurabilityMode);
                        cursor.store(BOGUS, cursor.leafExclusive(), value);
                    }
                    catch (Throwable e) {
                        commitLock.releaseShared();
                        throw e;
                    }
                    this.mHasState = hasState & 0xFFFFFFFC;
                    UndoLog undo = this.mUndoLog;
                    if (undo == null) {
                        commitLock.releaseShared();
                        if (commitPos != 0L) {
                            if (this.mDurabilityMode == DurabilityMode.SYNC) {
                                redo.txnCommitSync(this, commitPos);
                            } else {
                                this.commitPending(commitPos, null);
                                return;
                            }
                        }
                        super.scopeUnlockAll();
                    } else {
                        try {
                            undo.pushCommit();
                        }
                        finally {
                            commitLock.releaseShared();
                        }
                        if (commitPos != 0L) {
                            if (this.mDurabilityMode == DurabilityMode.SYNC) {
                                redo.txnCommitSync(this, commitPos);
                            } else {
                                this.commitPending(commitPos, undo);
                                return;
                            }
                        }
                        super.scopeUnlockAll();
                        undo.truncate(true);
                        this.mDatabase.unregister(undo);
                        this.mUndoLog = null;
                        if ((hasState & 4) != 0) {
                            this.mDatabase.fragmentedTrash().emptyTrash(this.mTxnId);
                            this.mHasState = hasState & 0xFFFFFFFB;
                        }
                    }
                    this.mTxnId = 0L;
                    break block36;
                }
                try {
                    if ((hasState & 1) == 0) {
                        this.setScopeState(redo, parentScope);
                        if (value == null) {
                            redo.txnDelete((byte)37, txnId, indexId, key);
                        } else {
                            redo.txnStore((byte)33, txnId, indexId, key, value);
                        }
                    } else if (value == null) {
                        redo.txnDelete((byte)38, txnId, indexId, key);
                    } else {
                        redo.txnStore((byte)34, txnId, indexId, key, value);
                    }
                    DurabilityMode original = this.mDurabilityMode;
                    this.mDurabilityMode = DurabilityMode.NO_REDO;
                    try {
                        cursor.store(this, cursor.leafExclusive(), value);
                    }
                    finally {
                        this.mDurabilityMode = original;
                    }
                }
                finally {
                    commitLock.releaseShared();
                }
                this.mHasState = hasState & 0xFFFFFFFC;
                parentScope.mHasState |= 2;
                super.promote();
                UndoLog undo = this.mUndoLog;
                if (undo != null) {
                    this.mSavepoint = undo.scopeCommit();
                }
            }
            catch (Throwable e) {
                throw this.borked(e, true);
            }
        }
    }

    @Override
    public final void commitAll() throws IOException {
        while (true) {
            this.commit();
            if (this.mParentScope == null) break;
            this.exit();
        }
    }

    @Override
    public final void enter() throws IOException {
        this.check();
        try {
            Locker.ParentScope parentScope = super.scopeEnter();
            parentScope.mLockMode = this.mLockMode;
            parentScope.mLockTimeoutNanos = this.mLockTimeoutNanos;
            parentScope.mHasState = this.mHasState;
            UndoLog undo = this.mUndoLog;
            if (undo != null) {
                parentScope.mSavepoint = this.mSavepoint;
                this.mSavepoint = undo.scopeEnter();
            }
            this.mHasState &= 0xFFFFFFFC;
        }
        catch (Throwable e) {
            throw this.borked(e, true);
        }
    }

    @Override
    public final void exit() throws IOException {
        if (this.mBorked != null) {
            return;
        }
        try {
            Locker.ParentScope parentScope = this.mParentScope;
            if (parentScope == null) {
                int hasState = this.mHasState;
                if ((hasState & 1) != 0) {
                    this.mRedoWriter.txnRollbackFinal(this.mTxnId);
                }
                this.mHasState = 0;
                UndoLog undo = this.mUndoLog;
                if (undo != null) {
                    undo.rollback();
                }
                super.scopeExit();
                this.mSavepoint = 0L;
                if (undo != null) {
                    this.mDatabase.unregister(undo);
                    this.mUndoLog = null;
                }
                this.mTxnId = 0L;
            } else {
                UndoLog undo;
                int hasState = this.mHasState;
                if ((this.mHasState & 1) != 0) {
                    this.mRedoWriter.txnRollback(this.mTxnId);
                    this.mHasState = hasState & 0xFFFFFFFC;
                }
                if ((undo = this.mUndoLog) != null) {
                    undo.scopeRollback(this.mSavepoint);
                }
                super.scopeExit();
                this.mLockMode = parentScope.mLockMode;
                this.mLockTimeoutNanos = parentScope.mLockTimeoutNanos;
                this.mHasState |= parentScope.mHasState;
                this.mSavepoint = parentScope.mSavepoint;
            }
        }
        catch (Throwable e) {
            throw this.borked(e, true);
        }
    }

    @Override
    public final void reset() throws IOException {
        if (this.mBorked != null) {
            return;
        }
        try {
            int hasState = this.mHasState;
            Locker.ParentScope parentScope = this.mParentScope;
            while (parentScope != null) {
                if ((hasState & 1) != 0) {
                    this.mRedoWriter.txnRollback(this.mTxnId);
                }
                hasState = parentScope.mHasState;
                parentScope = parentScope.mParentScope;
            }
            if ((hasState & 1) != 0) {
                this.mRedoWriter.txnRollbackFinal(this.mTxnId);
            }
            this.mHasState = 0;
            UndoLog undo = this.mUndoLog;
            if (undo != null) {
                undo.rollback();
            }
            super.scopeExitAll();
            this.mSavepoint = 0L;
            if (undo != null) {
                this.mDatabase.unregister(undo);
                this.mUndoLog = null;
            }
            this.mTxnId = 0L;
        }
        catch (Throwable e) {
            throw this.borked(e, true);
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder(Transaction.class.getName());
        if (this == BOGUS) {
            return b.append('.').append("BOGUS").toString();
        }
        b.append('@').append(Integer.toHexString(this.hashCode()));
        b.append(" {");
        b.append("id").append(": ").append(this.mTxnId);
        b.append(", ");
        b.append("durabilityMode").append(": ").append((Object)this.mDurabilityMode);
        b.append(", ");
        b.append("lockMode").append(": ").append((Object)this.mLockMode);
        b.append(", ");
        b.append("lockTimeout").append(": ");
        TimeUnit unit = Utils.inferUnit(TimeUnit.NANOSECONDS, this.mLockTimeoutNanos);
        Utils.appendTimeout(b, this.lockTimeout(unit), unit);
        Object borked = this.mBorked;
        if (borked != null) {
            b.append(", ");
            b.append("invalid").append(": ").append(borked);
        }
        return b.append('}').toString();
    }

    @Override
    public final LockResult lockShared(long indexId, byte[] key) throws LockFailureException {
        return super.lockShared(indexId, key, this.mLockTimeoutNanos);
    }

    final LockResult lockShared(long indexId, byte[] key, int hash) throws LockFailureException {
        return super.lockShared(indexId, key, hash, this.mLockTimeoutNanos);
    }

    @Override
    public final LockResult lockUpgradable(long indexId, byte[] key) throws LockFailureException {
        return super.lockUpgradable(indexId, key, this.mLockTimeoutNanos);
    }

    final LockResult lockUpgradable(long indexId, byte[] key, int hash) throws LockFailureException {
        return super.lockUpgradable(indexId, key, hash, this.mLockTimeoutNanos);
    }

    @Override
    public final LockResult lockExclusive(long indexId, byte[] key) throws LockFailureException {
        return super.lockExclusive(indexId, key, this.mLockTimeoutNanos);
    }

    final LockResult lockExclusive(long indexId, byte[] key, int hash) throws LockFailureException {
        return super.lockExclusive(indexId, key, hash, this.mLockTimeoutNanos);
    }

    final LockResult lockExclusive(Lock lock) throws LockFailureException {
        return super.lockExclusive(lock, this.mLockTimeoutNanos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void customRedo(byte[] message, long indexId, byte[] key) throws IOException {
        if (this.mDatabase.mCustomTxnHandler == null) {
            throw new IllegalStateException("Custom transaction handler is not installed");
        }
        this.check();
        RedoWriter redo = this.mRedoWriter;
        if (redo != null) {
            int hasState;
            long txnId = this.mTxnId;
            if (txnId == 0L) {
                CommitLock commitLock = this.mDatabase.commitLock();
                commitLock.acquireShared();
                try {
                    this.mTxnId = txnId = this.mDatabase.nextTransactionId();
                }
                finally {
                    commitLock.releaseShared();
                }
            }
            if (((hasState = this.mHasState) & 1) == 0) {
                Locker.ParentScope parentScope = this.mParentScope;
                if (parentScope != null) {
                    this.setScopeState(redo, parentScope);
                }
                redo.txnEnter(txnId);
            }
            this.mHasState = hasState | 3;
            if (indexId == 0L) {
                if (key != null) {
                    throw new IllegalArgumentException("Key cannot be used if indexId is zero");
                }
                redo.txnCustom(txnId, message);
            } else {
                redo.txnCustomLock(txnId, message, indexId, key);
            }
        }
    }

    @Override
    public final void customUndo(byte[] message) throws IOException {
        if (this.mDatabase.mCustomTxnHandler == null) {
            throw new IllegalStateException("Custom transaction handler is not installed");
        }
        this.check();
        CommitLock commitLock = this.mDatabase.commitLock();
        commitLock.acquireShared();
        try {
            this.undoLog().pushCustom(message);
        }
        finally {
            commitLock.releaseShared();
        }
    }

    final boolean recoveryCleanup(boolean resetAlways) throws IOException {
        UndoLog undo = this.mUndoLog;
        if (undo != null) {
            switch (undo.peek(true)) {
                default: {
                    break;
                }
                case 4: {
                    undo.deleteGhosts();
                    resetAlways = true;
                    break;
                }
                case 5: {
                    undo.truncate(false);
                    resetAlways = true;
                }
            }
        }
        if (resetAlways) {
            this.reset();
        }
        return resetAlways;
    }

    final void redoStore(long indexId, byte[] key, byte[] value) throws IOException {
        this.check();
        RedoWriter redo = this.mRedoWriter;
        if (redo != null) {
            long txnId = this.mTxnId;
            if (txnId == 0L) {
                this.mTxnId = txnId = this.mDatabase.nextTransactionId();
            }
            try {
                int hasState = this.mHasState;
                if ((hasState & 1) == 0) {
                    Locker.ParentScope parentScope = this.mParentScope;
                    if (parentScope != null) {
                        this.setScopeState(redo, parentScope);
                    }
                    if (value == null) {
                        redo.txnDelete((byte)36, txnId, indexId, key);
                    } else {
                        redo.txnStore((byte)32, txnId, indexId, key, value);
                    }
                } else if (value == null) {
                    redo.txnDelete((byte)37, txnId, indexId, key);
                } else {
                    redo.txnStore((byte)33, txnId, indexId, key, value);
                }
                this.mHasState = hasState | 3;
            }
            catch (Throwable e) {
                throw this.borked(e, false);
            }
        }
    }

    private void setScopeState(RedoWriter redo, Locker.ParentScope scope) throws IOException {
        int hasState = scope.mHasState;
        if ((hasState & 1) == 0) {
            Locker.ParentScope parentScope = scope.mParentScope;
            if (parentScope != null) {
                this.setScopeState(redo, parentScope);
            }
            redo.txnEnter(this.mTxnId);
            scope.mHasState = hasState | 1;
        }
    }

    final long txnId() throws IOException {
        long txnId = this.mTxnId;
        if (txnId == 0L) {
            this.mTxnId = txnId = this.mDatabase.nextTransactionId();
        }
        return txnId;
    }

    final void setHasTrash() {
        this.mHasState |= 4;
    }

    final void pushUndoStore(long indexId, byte op, byte[] payload, int off, int len) throws IOException {
        this.check();
        try {
            this.undoLog().push(indexId, op, payload, off, len);
        }
        catch (Throwable e) {
            throw this.borked(e, false);
        }
    }

    final void pushUninsert(long indexId, byte[] key) throws IOException {
        this.check();
        try {
            this.undoLog().push(indexId, (byte)19, key, 0, key.length);
        }
        catch (Throwable e) {
            throw this.borked(e, false);
        }
    }

    final void pushUndeleteFragmented(long indexId, byte[] payload, int off, int len) throws IOException {
        this.check();
        try {
            this.undoLog().push(indexId, (byte)22, payload, off, len);
        }
        catch (Throwable e) {
            throw this.borked(e, false);
        }
    }

    private UndoLog undoLog() throws IOException {
        UndoLog undo = this.mUndoLog;
        if (undo == null) {
            undo = new UndoLog(this.mDatabase, this.txnId());
            Locker.ParentScope parentScope = this.mParentScope;
            while (parentScope != null) {
                undo.scopeEnter();
                parentScope = parentScope.mParentScope;
            }
            this.mDatabase.register(undo);
            this.mUndoLog = undo;
        }
        return undo;
    }

    final RuntimeException borked(Throwable e, boolean rollback) {
        if (this.mBorked == null) {
            if (this.mDatabase.mClosed) {
                Throwable cause = this.mDatabase.mClosedCause;
                if (cause != null) {
                    try {
                        e.initCause(cause);
                    }
                    catch (IllegalArgumentException | IllegalStateException runtimeException) {
                        // empty catch block
                    }
                }
                this.mBorked = e;
            } else if (rollback) {
                UndoLog undo = this.mUndoLog;
                try {
                    if (undo != null) {
                        undo.rollback();
                    }
                    super.scopeExitAll();
                    if (undo != null) {
                        this.mDatabase.unregister(undo);
                        this.mUndoLog = null;
                    }
                }
                catch (Throwable e2) {
                    Throwable cause;
                    if (this.mDatabase.mClosed && (cause = this.mDatabase.mClosedCause) != null) {
                        try {
                            e.initCause(cause);
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                    try {
                        e2.initCause(e);
                        e = e2;
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    this.mBorked = e;
                }
            }
        }
        return Utils.rethrow(e);
    }
}

