/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import org.cojen.tupl.DatabaseException;

public class LargeValueException
extends DatabaseException {
    private static final long serialVersionUID = 1L;
    private final long mLength;

    public LargeValueException(long length) {
        super(LargeValueException.createMessage(length));
        this.mLength = length;
    }

    public LargeValueException(long length, Throwable cause) {
        super(LargeValueException.createMessage(length), cause);
        this.mLength = length;
    }

    public long getLength() {
        return this.mLength;
    }

    @Override
    boolean isRecoverable() {
        return true;
    }

    private static String createMessage(long length) {
        return "Value is too large: " + Long.toUnsignedString(length);
    }
}

