/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import org.cojen.tupl.DatabaseException;

public class LargeKeyException
extends DatabaseException {
    private static final long serialVersionUID = 1L;
    private final long mLength;

    public LargeKeyException(long length) {
        super(LargeKeyException.createMessage(length));
        this.mLength = length;
    }

    public LargeKeyException(long length, Throwable cause) {
        super(LargeKeyException.createMessage(length), cause);
        this.mLength = length;
    }

    public long getLength() {
        return this.mLength;
    }

    @Override
    boolean isRecoverable() {
        return true;
    }

    private static String createMessage(long length) {
        return "Key is too large: " + Long.toUnsignedString(length);
    }
}

