/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.util.LinkedHashSet;
import java.util.Set;
import org.cojen.tupl.DeadlockSet;
import org.cojen.tupl.Lock;
import org.cojen.tupl.LockOwner;
import org.cojen.tupl.Locker;

final class DeadlockDetector {
    private final Locker mOrigin;
    private final Set<LockOwner> mLockers;
    final Set<Lock> mLocks;
    boolean mGuilty;

    DeadlockDetector(Locker locker) {
        this.mOrigin = locker;
        this.mLockers = new LinkedHashSet<LockOwner>();
        this.mLocks = new LinkedHashSet<Lock>();
    }

    DeadlockSet newDeadlockSet() {
        int size = this.mLocks.size();
        long[] indexIds = new long[size];
        byte[][] keys = new byte[size][];
        int i = 0;
        for (Lock lock : this.mLocks) {
            indexIds[i] = lock.mIndexId;
            byte[] key = lock.mKey;
            if (key != null) {
                key = (byte[])key.clone();
            }
            keys[i] = key;
            ++i;
        }
        return new DeadlockSet(indexIds, keys);
    }

    boolean scan() {
        return this.scan(this.mOrigin);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean scan(LockOwner locker) {
        boolean found = false;
        Lock lock;
        block0: while ((lock = locker.mWaitingFor) != null) {
            this.mLocks.add(lock);
            if (this.mLockers.isEmpty()) {
                this.mLockers.add(locker);
            } else {
                this.mGuilty |= this.mOrigin == locker;
                if (!this.mLockers.add(locker)) {
                    return true;
                }
            }
            LockOwner owner = lock.mOwner;
            Object shared = lock.mSharedLockOwnersObj;
            if (owner != null && owner != locker) {
                if (shared == null) {
                    locker = owner;
                    continue;
                }
                found |= this.scan(owner);
            }
            if (shared == null) return found;
            if (shared instanceof Locker) {
                locker = (Locker)shared;
                continue;
            }
            if (!(shared instanceof Lock.LockOwnerHTEntry[])) {
                return found;
            }
            Lock.LockOwnerHTEntry[] entries = (Lock.LockOwnerHTEntry[])shared;
            int i = entries.length;
            block1: while (true) {
                if (--i < 0) return found;
                Lock.LockOwnerHTEntry e = entries[i];
                while (true) {
                    if (e == null) continue block1;
                    Lock.LockOwnerHTEntry next = e.mNext;
                    if (i == 0 && next == null) {
                        locker = e.mOwner;
                        continue block0;
                    }
                    found |= this.scan(e.mOwner);
                    e = next;
                }
                break;
            }
            break;
        }
        return found;
    }
}

