/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.cojen.tupl.CompactionObserver;
import org.cojen.tupl.DatabaseConfig;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.Index;
import org.cojen.tupl.LocalDatabase;
import org.cojen.tupl.Snapshot;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Utils;
import org.cojen.tupl.VerificationObserver;
import org.cojen.tupl.View;
import org.cojen.tupl.io.CauseCloseable;

public interface Database
extends CauseCloseable,
Flushable {
    public static Database open(DatabaseConfig config) throws IOException {
        Method m = config.directOpenMethod();
        if (m != null) {
            try {
                return (Database)m.invoke(null, config);
            }
            catch (Exception e) {
                config.handleDirectException(e);
            }
        }
        return LocalDatabase.open(config);
    }

    public static Database destroy(DatabaseConfig config) throws IOException {
        Method m = config.directDestroyMethod();
        if (m != null) {
            try {
                return (Database)m.invoke(null, config);
            }
            catch (Exception e) {
                config.handleDirectException(e);
            }
        }
        return LocalDatabase.destroy(config);
    }

    public Index findIndex(byte[] var1) throws IOException;

    default public Index findIndex(String name) throws IOException {
        return this.findIndex(name.getBytes("UTF-8"));
    }

    public Index openIndex(byte[] var1) throws IOException;

    default public Index openIndex(String name) throws IOException {
        return this.openIndex(name.getBytes("UTF-8"));
    }

    public Index indexById(long var1) throws IOException;

    default public Index indexById(byte[] id) throws IOException {
        if (id.length != 8) {
            throw new IllegalArgumentException("Expected an 8 byte identifier: " + id.length);
        }
        return this.indexById(Utils.decodeLongBE(id, 0));
    }

    public void renameIndex(Index var1, byte[] var2) throws IOException;

    default public void renameIndex(Index index, String newName) throws IOException {
        this.renameIndex(index, newName.getBytes("UTF-8"));
    }

    public Runnable deleteIndex(Index var1) throws IOException;

    public View indexRegistryByName() throws IOException;

    public View indexRegistryById() throws IOException;

    default public Transaction newTransaction() {
        return this.newTransaction(null);
    }

    public Transaction newTransaction(DurabilityMode var1);

    public long preallocate(long var1) throws IOException;

    default public void capacityLimit(long bytes) {
        throw new UnsupportedOperationException();
    }

    default public long capacityLimit() {
        return -1L;
    }

    default public void capacityLimitOverride(long bytes) {
        throw new UnsupportedOperationException();
    }

    public Snapshot beginSnapshot() throws IOException;

    public static Database restoreFromSnapshot(DatabaseConfig config, InputStream in) throws IOException {
        Method m = config.directRestoreMethod();
        if (m != null) {
            try {
                return (Database)m.invoke(null, config, in);
            }
            catch (Exception e) {
                config.handleDirectException(e);
            }
        }
        return LocalDatabase.restoreFromSnapshot(config, in);
    }

    public void createCachePrimer(OutputStream var1) throws IOException;

    public void applyCachePrimer(InputStream var1) throws IOException;

    public Stats stats();

    @Override
    public void flush() throws IOException;

    public void sync() throws IOException;

    public void checkpoint() throws IOException;

    public void suspendCheckpoints();

    public void resumeCheckpoints();

    public boolean compactFile(CompactionObserver var1, double var2) throws IOException;

    public boolean verify(VerificationObserver var1) throws IOException;

    @Override
    default public void close() throws IOException {
        this.close(null);
    }

    @Override
    public void close(Throwable var1) throws IOException;

    public void shutdown() throws IOException;

    public static class Stats
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 3L;
        public int pageSize;
        public long freePages;
        public long totalPages;
        public long cachedPages;
        public int openIndexes;
        public long lockCount;
        public long cursorCount;
        public long txnCount;
        public long txnsCreated;

        public int pageSize() {
            return this.pageSize;
        }

        public long freePages() {
            return this.freePages;
        }

        public long totalPages() {
            return this.totalPages;
        }

        public long cachedPages() {
            return this.cachedPages;
        }

        public int openIndexes() {
            return this.openIndexes;
        }

        public long lockCount() {
            return this.lockCount;
        }

        public long cursorCount() {
            return this.cursorCount;
        }

        public long transactionCount() {
            return this.txnCount;
        }

        public long transactionsCreated() {
            return this.txnsCreated;
        }

        public Stats clone() {
            try {
                return (Stats)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw Utils.rethrow(e);
            }
        }

        public int hashCode() {
            long hash = this.freePages;
            hash = hash * 31L + this.totalPages;
            hash = hash * 31L + this.txnsCreated;
            return (int)Utils.scramble(hash);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && obj.getClass() == Stats.class) {
                Stats other = (Stats)obj;
                return this.pageSize == other.pageSize && this.freePages == other.freePages && this.totalPages == other.totalPages && this.openIndexes == other.openIndexes && this.lockCount == other.lockCount && this.cursorCount == other.cursorCount && this.txnCount == other.txnCount && this.txnsCreated == other.txnsCreated;
            }
            return false;
        }

        public String toString() {
            return "Database.Stats {pageSize=" + this.pageSize + ", freePages=" + this.freePages + ", totalPages=" + this.totalPages + ", cachedPages=" + this.cachedPages + ", openIndexes=" + this.openIndexes + ", lockCount=" + this.lockCount + ", cursorCount=" + this.cursorCount + ", transactionCount=" + this.txnCount + ", transactionsCreated=" + this.txnsCreated + '}';
        }
    }
}

