/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.ReentrantReadWriteLock;

final class CommitLock
extends ReentrantReadWriteLock {
    private static final AtomicIntegerFieldUpdater<CommitLock> cExclusiveUpdater = AtomicIntegerFieldUpdater.newUpdater(CommitLock.class, "mExclusiveRequested");
    private volatile int mExclusiveRequested;

    CommitLock() {
    }

    public boolean tryAcquireShared() {
        return this.mExclusiveRequested == 0 ? this.readLock().tryLock() : false;
    }

    public void acquireShared() {
        this.readLock().lock();
    }

    public void releaseShared() {
        this.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireExclusive() throws InterruptedIOException {
        cExclusiveUpdater.incrementAndGet(this);
        try {
            ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
            try {
                long timeoutMillis = 1L;
                while (!writeLock.tryLock(timeoutMillis, TimeUnit.MILLISECONDS)) {
                    timeoutMillis <<= 1;
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }
        finally {
            cExclusiveUpdater.decrementAndGet(this);
        }
    }

    public void releaseExclusive() {
        this.writeLock().unlock();
    }
}

