/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.cojen.tupl.Crypto;
import org.cojen.tupl.DirectPageOps;
import org.cojen.tupl.Utils;
import org.cojen.tupl.io.DirectAccess;

public class CipherCrypto
implements Crypto {
    private final ThreadLocal<Cipher> mHeaderPageCipher = new ThreadLocal<T>();
    private final ThreadLocal<Cipher> mDataPageCipher = new ThreadLocal<T>();
    private final SecretKey mRootKey;
    private final boolean mIsNewKey;
    private volatile byte[] mDataIvSalt;
    private volatile SecretKey mDataKey;

    public static void main(String[] args) throws Exception {
        System.out.println(CipherCrypto.toString(new CipherCrypto().secretKey()));
    }

    public CipherCrypto() throws GeneralSecurityException {
        this(null, null);
    }

    public CipherCrypto(byte[] encodedKey) throws GeneralSecurityException {
        this(null, encodedKey);
    }

    public CipherCrypto(SecretKey key) throws GeneralSecurityException {
        this(key, null);
    }

    /*
     * Unable to fully structure code
     */
    private CipherCrypto(SecretKey key, byte[] encodedKey) throws GeneralSecurityException {
        super();
        if (key != null) ** GOTO lbl10
        if (encodedKey == null) {
            key = this.generateKey();
            isNewKey = true;
        } else {
            key = new SecretKeySpec(encodedKey, this.algorithm());
lbl10:
            // 2 sources

            isNewKey = false;
        }
        this.mRootKey = key;
        this.mIsNewKey = isNewKey;
    }

    public SecretKey secretKey() {
        if (!this.mIsNewKey) {
            throw new IllegalStateException("Unavailable");
        }
        return this.mRootKey;
    }

    @Override
    public final void encryptPage(long pageIndex, int pageSize, byte[] src, int srcOffset, byte[] dst, int dstOffset) throws GeneralSecurityException {
        Cipher cipher;
        byte[] dataIvSalt = this.mDataIvSalt;
        SecretKey dataKey = this.mDataKey;
        if (dataIvSalt == null) {
            this.createDataKeyIfNecessary();
            dataIvSalt = this.mDataIvSalt;
            dataKey = this.mDataKey;
        }
        if (pageIndex <= 1L) {
            cipher = this.headerPageCipher();
            this.initCipher(cipher, 1, this.mRootKey);
            byte[] srcCopy = new byte[pageSize];
            System.arraycopy(src, srcOffset, srcCopy, 0, pageSize);
            src = srcCopy;
            srcOffset = 0;
            int offset = pageSize;
            byte[] headerIv = cipher.getIV();
            CipherCrypto.checkBlockLength(headerIv);
            offset = CipherCrypto.encodeBlock(src, offset, headerIv);
            CipherCrypto.encodeBlock(dst, dstOffset + pageSize, headerIv);
            pageSize = offset;
            offset = CipherCrypto.encodeBlock(src, offset, dataIvSalt);
            offset = CipherCrypto.encodeBlock(src, offset, dataKey.getEncoded());
        } else {
            cipher = this.dataPageCipher();
            IvParameterSpec ivSpec = this.generateDataPageIv(cipher, pageIndex, dataIvSalt, dataKey);
            this.initCipher(cipher, 1, dataKey, ivSpec);
        }
        if (cipher.doFinal(src, srcOffset, pageSize, dst, dstOffset) != pageSize) {
            throw new GeneralSecurityException("Encrypted length does not match");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void encryptPage(long pageIndex, int pageSize, long srcPtr, int srcOffset, long dstPtr, int dstOffset) throws GeneralSecurityException {
        block7: {
            byte[] dataIvSalt = this.mDataIvSalt;
            SecretKey dataKey = this.mDataKey;
            if (dataIvSalt == null) {
                this.createDataKeyIfNecessary();
                dataIvSalt = this.mDataIvSalt;
                dataKey = this.mDataKey;
            }
            if (pageIndex <= 1L) {
                Cipher cipher = this.headerPageCipher();
                this.initCipher(cipher, 1, this.mRootKey);
                long srcCopy = DirectPageOps.p_alloc(pageSize);
                try {
                    DirectPageOps.p_copy(srcPtr, srcOffset, srcCopy, 0, pageSize);
                    srcPtr = srcCopy;
                    srcOffset = 0;
                    int offset = pageSize;
                    byte[] headerIv = cipher.getIV();
                    CipherCrypto.checkBlockLength(headerIv);
                    offset = CipherCrypto.encodeBlock(srcPtr, offset, headerIv);
                    CipherCrypto.encodeBlock(dstPtr, dstOffset + pageSize, headerIv);
                    pageSize = offset;
                    offset = CipherCrypto.encodeBlock(srcPtr, offset, dataIvSalt);
                    offset = CipherCrypto.encodeBlock(srcPtr, offset, dataKey.getEncoded());
                    if (CipherCrypto.cipherDoFinal(cipher, srcPtr, srcOffset, pageSize, dstPtr, dstOffset) != pageSize) {
                        throw new GeneralSecurityException("Encrypted length does not match");
                    }
                    break block7;
                }
                finally {
                    DirectPageOps.p_delete(srcCopy);
                }
            }
            Cipher cipher = this.dataPageCipher();
            IvParameterSpec ivSpec = this.generateDataPageIv(cipher, pageIndex, dataIvSalt, dataKey);
            this.initCipher(cipher, 1, dataKey, ivSpec);
            if (CipherCrypto.cipherDoFinal(cipher, srcPtr, srcOffset, pageSize, dstPtr, dstOffset) != pageSize) {
                throw new GeneralSecurityException("Encrypted length does not match");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDataKeyIfNecessary() throws GeneralSecurityException {
        SecretKey secretKey = this.mRootKey;
        synchronized (secretKey) {
            if (this.mDataIvSalt == null) {
                byte[] dataIvSalt = this.generateKey().getEncoded();
                SecretKey dataKey = this.generateKey();
                CipherCrypto.checkBlockLength(dataIvSalt);
                CipherCrypto.checkBlockLength(dataKey.getEncoded());
                this.mDataIvSalt = dataIvSalt;
                this.mDataKey = dataKey;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void decryptPage(long pageIndex, int pageSize, byte[] src, int srcOffset, byte[] dst, int dstOffset) throws GeneralSecurityException {
        if (pageIndex <= 1L) {
            byte[] headerIv = CipherCrypto.decodeBlock(src, srcOffset + pageSize);
            pageSize = pageSize - headerIv.length - 1;
            Cipher cipher = this.headerPageCipher();
            this.initCipher(cipher, 2, this.mRootKey, new IvParameterSpec(headerIv));
            if (cipher.doFinal(src, srcOffset, pageSize, dst, dstOffset) != pageSize) {
                throw new GeneralSecurityException("Decrypted length does not match");
            }
            if (this.mDataIvSalt == null) {
                SecretKey secretKey = this.mRootKey;
                synchronized (secretKey) {
                    if (this.mDataIvSalt == null) {
                        int offset = dstOffset + pageSize;
                        byte[] dataIvSalt = CipherCrypto.decodeBlock(dst, offset);
                        this.mDataIvSalt = dataIvSalt;
                        offset = offset - dataIvSalt.length - 1;
                        byte[] dataKeyValue = CipherCrypto.decodeBlock(dst, offset);
                        this.mDataKey = new SecretKeySpec(dataKeyValue, this.algorithm());
                    }
                }
            }
        } else {
            Cipher cipher = this.dataPageCipher();
            SecretKey dataKey = this.mDataKey;
            IvParameterSpec ivSpec = this.generateDataPageIv(cipher, pageIndex, this.mDataIvSalt, dataKey);
            this.initCipher(cipher, 2, dataKey, ivSpec);
            if (cipher.doFinal(src, srcOffset, pageSize, dst, dstOffset) != pageSize) {
                throw new GeneralSecurityException("Decrypted length does not match");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void decryptPage(long pageIndex, int pageSize, long srcPtr, int srcOffset, long dstPtr, int dstOffset) throws GeneralSecurityException {
        if (pageIndex <= 1L) {
            byte[] headerIv = CipherCrypto.decodeBlock(srcPtr, srcOffset + pageSize);
            pageSize = pageSize - headerIv.length - 1;
            Cipher cipher = this.headerPageCipher();
            this.initCipher(cipher, 2, this.mRootKey, new IvParameterSpec(headerIv));
            if (CipherCrypto.cipherDoFinal(cipher, srcPtr, srcOffset, pageSize, dstPtr, dstOffset) != pageSize) {
                throw new GeneralSecurityException("Decrypted length does not match");
            }
            if (this.mDataIvSalt == null) {
                SecretKey secretKey = this.mRootKey;
                synchronized (secretKey) {
                    if (this.mDataIvSalt == null) {
                        int offset = dstOffset + pageSize;
                        byte[] dataIvSalt = CipherCrypto.decodeBlock(dstPtr, offset);
                        this.mDataIvSalt = dataIvSalt;
                        offset = offset - dataIvSalt.length - 1;
                        byte[] dataKeyValue = CipherCrypto.decodeBlock(dstPtr, offset);
                        this.mDataKey = new SecretKeySpec(dataKeyValue, this.algorithm());
                    }
                }
            }
        } else {
            Cipher cipher = this.dataPageCipher();
            SecretKey dataKey = this.mDataKey;
            IvParameterSpec ivSpec = this.generateDataPageIv(cipher, pageIndex, this.mDataIvSalt, dataKey);
            this.initCipher(cipher, 2, dataKey, ivSpec);
            if (CipherCrypto.cipherDoFinal(cipher, srcPtr, srcOffset, pageSize, dstPtr, dstOffset) != pageSize) {
                throw new GeneralSecurityException("Decrypted length does not match");
            }
        }
    }

    private IvParameterSpec generateDataPageIv(Cipher cipher, long pageIndex, byte[] salt, SecretKey dataKey) throws GeneralSecurityException {
        byte[] iv = new byte[cipher.getBlockSize()];
        Utils.encodeLongLE(iv, 0, pageIndex);
        this.initCipher(cipher, 1, dataKey, new IvParameterSpec(iv));
        return new IvParameterSpec(cipher.doFinal(salt));
    }

    @Override
    public final OutputStream newEncryptingStream(long id, OutputStream out) throws GeneralSecurityException, IOException {
        Cipher cipher = this.newStreamCipher();
        this.initCipher(cipher, 1, this.mRootKey);
        byte[] iv = cipher.getIV();
        CipherCrypto.checkBlockLength(iv);
        out.write((byte)(iv.length - 1));
        out.write(iv);
        return new CipherOutputStream(out, cipher);
    }

    @Override
    public final InputStream newDecryptingStream(long id, InputStream in) throws GeneralSecurityException, IOException {
        int length = in.read();
        if (length < 0) {
            throw new EOFException();
        }
        byte[] iv = new byte[length + 1];
        Utils.readFully(in, iv, 0, iv.length);
        Cipher cipher = this.newStreamCipher();
        this.initCipher(cipher, 2, this.mRootKey, new IvParameterSpec(iv));
        return new CipherInputStream(in, cipher);
    }

    public static String toString(SecretKey key) {
        return CipherCrypto.toString(key.getEncoded());
    }

    public static String toString(byte[] key) {
        StringBuilder b = new StringBuilder(200);
        b.append('{');
        for (int i = 0; i < key.length; ++i) {
            if (i > 0) {
                b.append(',');
            }
            b.append(key[i]);
        }
        b.append('}');
        return b.toString();
    }

    protected String algorithm() {
        return "AES";
    }

    protected int keySize() {
        return 128;
    }

    protected SecretKey generateKey() throws GeneralSecurityException {
        KeyGenerator gen = KeyGenerator.getInstance(this.algorithm());
        gen.init(this.keySize());
        return gen.generateKey();
    }

    protected Cipher newCipher(String transformation) throws GeneralSecurityException {
        return Cipher.getInstance(transformation);
    }

    protected Cipher newPageCipher() throws GeneralSecurityException {
        return this.newCipher(this.algorithm() + "/CTR/NoPadding");
    }

    protected Cipher newStreamCipher() throws GeneralSecurityException {
        return this.newCipher(this.algorithm() + "/CTR/NoPadding");
    }

    protected void initCipher(Cipher cipher, int opmode, SecretKey key) throws GeneralSecurityException {
        cipher.init(opmode, key);
    }

    protected void initCipher(Cipher cipher, int opmode, SecretKey key, IvParameterSpec ivSpec) throws GeneralSecurityException {
        cipher.init(opmode, (Key)key, ivSpec);
    }

    private Cipher headerPageCipher() throws GeneralSecurityException {
        Cipher cipher = this.mHeaderPageCipher.get();
        if (cipher == null) {
            cipher = this.newStreamCipher();
            this.mHeaderPageCipher.set(cipher);
        }
        return cipher;
    }

    private Cipher dataPageCipher() throws GeneralSecurityException {
        Cipher cipher = this.mDataPageCipher.get();
        if (cipher == null) {
            cipher = this.newPageCipher();
            this.mDataPageCipher.set(cipher);
        }
        return cipher;
    }

    private static void checkBlockLength(byte[] bytes) throws GeneralSecurityException {
        if (bytes.length == 0 || bytes.length > 256) {
            throw new GeneralSecurityException("Unsupported block length: " + bytes.length);
        }
    }

    private static int encodeBlock(byte[] dst, int offset, byte[] value) {
        dst[--offset] = (byte)(value.length - 1);
        System.arraycopy(value, 0, dst, offset -= value.length, value.length);
        return offset;
    }

    private static int encodeBlock(long dstPtr, int offset, byte[] value) {
        DirectPageOps.p_bytePut(dstPtr, --offset, value.length - 1);
        DirectPageOps.p_copyFromArray(value, 0, dstPtr, offset -= value.length, value.length);
        return offset;
    }

    private static byte[] decodeBlock(byte[] src, int offset) {
        byte[] value = new byte[(src[--offset] & 0xFF) + 1];
        System.arraycopy(src, offset - value.length, value, 0, value.length);
        return value;
    }

    private static byte[] decodeBlock(long srcPtr, int offset) {
        byte[] value = new byte[DirectPageOps.p_ubyteGet(srcPtr, --offset) + 1];
        DirectPageOps.p_copyToArray(srcPtr, offset - value.length, value, 0, value.length);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int cipherDoFinal(Cipher cipher, long srcPage, int srcStart, int srcLen, long dstPage, int dstStart) throws GeneralSecurityException {
        ByteBuffer src = DirectAccess.ref(srcPage + (long)srcStart, srcLen);
        try {
            int n;
            ByteBuffer dst = DirectAccess.ref2(dstPage + (long)dstStart, srcLen);
            try {
                n = cipher.doFinal(src, dst);
            }
            catch (Throwable throwable) {
                DirectAccess.unref(dst);
                throw throwable;
            }
            DirectAccess.unref(dst);
            return n;
        }
        finally {
            DirectAccess.unref(src);
        }
    }
}

