/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import org.cojen.tupl.BoundedView;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.Transaction;

final class BoundedCursor
implements Cursor {
    private final BoundedView mView;
    private final Cursor mSource;

    BoundedCursor(BoundedView view, Cursor source) {
        this.mView = view;
        this.mSource = source;
    }

    @Override
    public Ordering getOrdering() {
        return this.mSource.getOrdering();
    }

    @Override
    public Transaction link(Transaction txn) {
        return this.mSource.link(txn);
    }

    @Override
    public Transaction link() {
        return this.mSource.link();
    }

    @Override
    public byte[] key() {
        return this.mSource.key();
    }

    @Override
    public byte[] value() {
        return this.mSource.value();
    }

    @Override
    public boolean autoload(boolean mode) {
        return this.mSource.autoload(mode);
    }

    @Override
    public boolean autoload() {
        return this.mSource.autoload();
    }

    @Override
    public int compareKeyTo(byte[] rkey) {
        return this.mSource.compareKeyTo(rkey);
    }

    @Override
    public int compareKeyTo(byte[] rkey, int offset, int length) {
        return this.mSource.compareKeyTo(rkey, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockResult first() throws IOException {
        BoundedView view = this.mView;
        if (view.mEnd == null) {
            return this.toFirst();
        }
        Cursor source = this.mSource;
        Transaction txn = source.link(Transaction.BOGUS);
        boolean autoload = source.autoload(false);
        try {
            this.toFirst();
            byte[] key = source.key();
            if (key == null) {
                LockResult lockResult = LockResult.UNOWNED;
                return lockResult;
            }
            if (view.endRangeCompare(key) > 0) {
                source.reset();
                LockResult lockResult = LockResult.UNOWNED;
                return lockResult;
            }
        }
        finally {
            this.autoload(autoload);
            this.link(txn);
        }
        return source.load();
    }

    private LockResult toFirst() throws IOException {
        BoundedView view = this.mView;
        byte[] start = view.mStart;
        Cursor source = this.mSource;
        if (start == null) {
            return source.first();
        }
        if ((view.mMode & 0xFFFFFFFE) == 0) {
            return source.findGe(start);
        }
        return source.findGt(start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockResult last() throws IOException {
        BoundedView view = this.mView;
        if (view.mStart == null) {
            return this.toLast();
        }
        Cursor source = this.mSource;
        Transaction txn = source.link(Transaction.BOGUS);
        boolean autoload = source.autoload(false);
        try {
            this.toLast();
            byte[] key = source.key();
            if (key == null) {
                LockResult lockResult = LockResult.UNOWNED;
                return lockResult;
            }
            if (view.startRangeCompare(key) < 0) {
                source.reset();
                LockResult lockResult = LockResult.UNOWNED;
                return lockResult;
            }
        }
        finally {
            this.autoload(autoload);
            this.link(txn);
        }
        return source.load();
    }

    private LockResult toLast() throws IOException {
        BoundedView view = this.mView;
        byte[] end = view.mEnd;
        Cursor source = this.mSource;
        if (end == null) {
            return this.mSource.last();
        }
        if ((view.mMode & 1) == 0) {
            return source.findLe(end);
        }
        return source.findLt(end);
    }

    @Override
    public LockResult skip(long amount) throws IOException {
        boolean inclusive;
        byte[] limitKey;
        BoundedView view = this.mView;
        if (amount >= 0L) {
            limitKey = view.mEnd;
            inclusive = (view.mMode & 1) == 0;
        } else {
            limitKey = view.mStart;
            inclusive = (view.mMode & 0xFFFFFFFE) == 0;
        }
        return this.mSource.skip(amount, limitKey, inclusive);
    }

    @Override
    public LockResult skip(long amount, byte[] limitKey, boolean inclusive) throws IOException {
        if (amount == 0L || limitKey == null) {
            return this.mSource.skip(0L);
        }
        BoundedView view = this.mView;
        if (amount > 0L) {
            if (view.endRangeCompare(limitKey) > 0) {
                limitKey = view.mEnd;
                inclusive = (view.mMode & 1) == 0;
            }
        } else if (view.startRangeCompare(limitKey) < 0) {
            limitKey = view.mStart;
            inclusive = (view.mMode & 0xFFFFFFFE) == 0;
        }
        return this.mSource.skip(amount, limitKey, inclusive);
    }

    @Override
    public LockResult next() throws IOException {
        BoundedView view = this.mView;
        byte[] end = view.mEnd;
        Cursor source = this.mSource;
        if (end == null) {
            return source.next();
        }
        if ((view.mMode & 1) == 0) {
            return source.nextLe(end);
        }
        return source.nextLt(end);
    }

    @Override
    public LockResult nextLe(byte[] limitKey) throws IOException {
        if (this.mView.endRangeCompare(limitKey) <= 0) {
            return this.mSource.nextLe(limitKey);
        }
        return this.next();
    }

    @Override
    public LockResult nextLt(byte[] limitKey) throws IOException {
        if (this.mView.endRangeCompare(limitKey) <= 0) {
            return this.mSource.nextLt(limitKey);
        }
        return this.next();
    }

    @Override
    public LockResult previous() throws IOException {
        BoundedView view = this.mView;
        byte[] start = view.mStart;
        Cursor source = this.mSource;
        if (start == null) {
            return source.previous();
        }
        if ((view.mMode & 0xFFFFFFFE) == 0) {
            return source.previousGe(start);
        }
        return source.previousGt(start);
    }

    @Override
    public LockResult previousGe(byte[] limitKey) throws IOException {
        if (this.mView.startRangeCompare(limitKey) >= 0) {
            return this.mSource.previousGe(limitKey);
        }
        return this.previous();
    }

    @Override
    public LockResult previousGt(byte[] limitKey) throws IOException {
        if (this.mView.startRangeCompare(limitKey) >= 0) {
            return this.mSource.previousGt(limitKey);
        }
        return this.previous();
    }

    @Override
    public LockResult find(byte[] key) throws IOException {
        if (this.mView.inRange(key)) {
            return this.mSource.find(key);
        }
        this.reset();
        return LockResult.UNOWNED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockResult findGe(byte[] key) throws IOException {
        BoundedView view = this.mView;
        if (view.startRangeCompare(key) < 0) {
            return this.first();
        }
        Cursor source = this.mSource;
        if (view.mEnd == null) {
            return source.findGe(key);
        }
        Transaction txn = source.link(Transaction.BOGUS);
        boolean autoload = source.autoload(false);
        try {
            source.findGe(key);
            key = source.key();
            if (key == null) {
                LockResult lockResult = LockResult.UNOWNED;
                return lockResult;
            }
            if (view.endRangeCompare(key) > 0) {
                source.reset();
                LockResult lockResult = LockResult.UNOWNED;
                return lockResult;
            }
        }
        finally {
            this.autoload(autoload);
            this.link(txn);
        }
        return source.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockResult findGt(byte[] key) throws IOException {
        BoundedView view = this.mView;
        if (view.startRangeCompare(key) < 0) {
            return this.first();
        }
        Cursor source = this.mSource;
        if (view.mEnd == null) {
            return source.findGt(key);
        }
        Transaction txn = source.link(Transaction.BOGUS);
        boolean autoload = source.autoload(false);
        try {
            source.findGt(key);
            key = source.key();
            if (key == null) {
                LockResult lockResult = LockResult.UNOWNED;
                return lockResult;
            }
            if (view.endRangeCompare(key) > 0) {
                source.reset();
                LockResult lockResult = LockResult.UNOWNED;
                return lockResult;
            }
        }
        finally {
            this.autoload(autoload);
            this.link(txn);
        }
        return source.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockResult findLe(byte[] key) throws IOException {
        BoundedView view = this.mView;
        if (view.endRangeCompare(key) > 0) {
            return this.last();
        }
        Cursor source = this.mSource;
        if (view.mStart == null) {
            return source.findLe(key);
        }
        Transaction txn = source.link(Transaction.BOGUS);
        boolean autoload = source.autoload(false);
        try {
            source.findLe(key);
            key = source.key();
            if (key == null) {
                LockResult lockResult = LockResult.UNOWNED;
                return lockResult;
            }
            if (view.startRangeCompare(key) < 0) {
                source.reset();
                LockResult lockResult = LockResult.UNOWNED;
                return lockResult;
            }
        }
        finally {
            this.autoload(autoload);
            this.link(txn);
        }
        return source.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockResult findLt(byte[] key) throws IOException {
        BoundedView view = this.mView;
        if (view.endRangeCompare(key) > 0) {
            return this.last();
        }
        Cursor source = this.mSource;
        if (view.mStart == null) {
            return source.findLt(key);
        }
        Transaction txn = source.link(Transaction.BOGUS);
        boolean autoload = source.autoload(false);
        try {
            source.findLt(key);
            key = source.key();
            if (key == null) {
                LockResult lockResult = LockResult.UNOWNED;
                return lockResult;
            }
            if (view.startRangeCompare(key) < 0) {
                source.reset();
                LockResult lockResult = LockResult.UNOWNED;
                return lockResult;
            }
        }
        finally {
            this.autoload(autoload);
            this.link(txn);
        }
        return source.load();
    }

    @Override
    public LockResult findNearby(byte[] key) throws IOException {
        if (this.mView.inRange(key)) {
            return this.mSource.findNearby(key);
        }
        this.reset();
        return LockResult.UNOWNED;
    }

    @Override
    public LockResult random(byte[] lowKey, byte[] highKey) throws IOException {
        return this.mSource.random(this.mView.adjustLowKey(lowKey), this.mView.adjustHighKey(highKey));
    }

    @Override
    public LockResult load() throws IOException {
        return this.mSource.load();
    }

    @Override
    public void store(byte[] value) throws IOException {
        this.mSource.store(value);
    }

    @Override
    public void commit(byte[] value) throws IOException {
        this.mSource.commit(value);
    }

    @Override
    public Cursor copy() {
        return new BoundedCursor(this.mView, this.mSource.copy());
    }

    @Override
    public void reset() {
        this.mSource.reset();
    }
}

